/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.exception.InvalidChecksumException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.exception.UnsupportedAlgorithmException;
import org.fcrepo.kernel.api.models.Binary;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.services.FixityService;
import org.fcrepo.kernel.api.utils.ContentDigest;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.persistence.common.MultiDigestInputStreamWrapper;
import org.springframework.stereotype.Component;

@Component
public class FixityServiceImpl
extends AbstractService
implements FixityService {
    private static final Literal successResource = ResourceFactory.createTypedLiteral((Object)"SUCCESS");
    private static final Literal badChecksumResource = ResourceFactory.createTypedLiteral((Object)"BAD_CHECKSUM");

    public Collection<URI> getFixity(Binary binary, Collection<String> algorithms) throws UnsupportedAlgorithmException {
        List list;
        block8: {
            List digestAlgs = algorithms.stream().map(ContentDigest.DIGEST_ALGORITHM::fromAlgorithm).collect(Collectors.toList());
            InputStream content = binary.getContent();
            try {
                MultiDigestInputStreamWrapper digestWrapper = new MultiDigestInputStreamWrapper(content, null, digestAlgs);
                list = digestWrapper.getDigests();
                if (content == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RepositoryRuntimeException("Problem reading content stream from " + binary.getId(), (Throwable)e);
                }
            }
            content.close();
        }
        return list;
    }

    public RdfStream checkFixity(Binary binary) throws InvalidChecksumException {
        Model model = ModelFactory.createDefaultModel();
        Resource subject = model.createResource(binary.getId());
        Resource fixityResult = model.createResource(binary.getFedoraId().resolve("#" + UUID.randomUUID().toString()).getFullId());
        model.add(subject, RdfLexicon.HAS_FIXITY_RESULT, (RDFNode)fixityResult);
        model.add(fixityResult, RDF.type, (RDFNode)RdfLexicon.PREMIS_FIXITY);
        model.add(fixityResult, RDF.type, (RDFNode)RdfLexicon.PREMIS_EVENT_OUTCOME_DETAIL);
        model.add(fixityResult, RdfLexicon.HAS_SIZE, (RDFNode)ResourceFactory.createTypedLiteral((Object)binary.getContentSize()));
        ArrayList<URI> existingDigestList = new ArrayList<URI>();
        existingDigestList.add(binary.getContentDigest());
        List digestAlgs = existingDigestList.stream().map(URI::toString).map(a -> a.replace("urn:", "").split(":")[0]).map(ContentDigest.DIGEST_ALGORITHM::fromAlgorithm).collect(Collectors.toList());
        try (InputStream content = binary.getContent();){
            MultiDigestInputStreamWrapper digestWrapper = new MultiDigestInputStreamWrapper(content, existingDigestList, digestAlgs);
            digestWrapper.getDigests().forEach(d -> model.add(fixityResult, RdfLexicon.HAS_MESSAGE_DIGEST, (RDFNode)model.createResource(d.toString())));
            digestWrapper.checkFixity();
            model.add(fixityResult, RdfLexicon.HAS_FIXITY_STATE, (RDFNode)successResource);
        }
        catch (IOException e) {
            throw new RepositoryRuntimeException("Problem reading content stream from " + binary.getId(), (Throwable)e);
        }
        catch (InvalidChecksumException e) {
            model.add(fixityResult, RdfLexicon.HAS_FIXITY_STATE, (RDFNode)badChecksumResource);
        }
        return DefaultRdfStream.fromModel((Node)subject.asNode(), (Model)model);
    }
}

