/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.fcrepo.config.OcflPropsConfig;
import org.fcrepo.kernel.api.RdfCollectors;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.Binary;
import org.fcrepo.kernel.api.models.Container;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.api.models.Tombstone;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.services.MembershipService;
import org.fcrepo.kernel.impl.services.MembershipIndexManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MembershipServiceImpl
implements MembershipService {
    private static final Logger log = LoggerFactory.getLogger(MembershipServiceImpl.class);
    public static final Instant NO_END_INSTANT = Instant.parse("9999-12-31T00:00:00.000Z");
    @Inject
    private MembershipIndexManager indexManager;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private OcflPropsConfig propsConfig;

    @Transactional
    public void resourceCreated(String txId, FedoraId fedoraId) {
        FedoraResource fedoraResc = this.getFedoraResource(txId, fedoraId);
        if (!(fedoraResc instanceof Container) && !(fedoraResc instanceof Binary)) {
            return;
        }
        FedoraResource parentResc = this.getParentResource(fedoraResc);
        if (this.isDirectContainer(parentResc)) {
            Resource parentRdfResc = this.getRdfResource(parentResc);
            Triple newMembership = this.generateDirectMembership(parentRdfResc, fedoraResc);
            this.indexManager.addMembership(txId, parentResc.getFedoraId(), newMembership, fedoraResc.getCreatedDate());
        }
    }

    @Transactional
    public void resourceModified(String txId, FedoraId fedoraId) {
        FedoraResource fedoraResc = this.getFedoraResource(txId, fedoraId);
        if (this.isDirectContainer(fedoraResc)) {
            log.debug("Modified DirectContainer {}, recomputing generated membership relations", (Object)fedoraId);
            if (this.propsConfig.isAutoVersioningEnabled()) {
                this.modifyDCAutoversioned(txId, fedoraResc);
            } else {
                this.modifyDCOnDemandVersioning(txId, fedoraResc);
            }
            return;
        }
    }

    private void modifyDCAutoversioned(String txId, FedoraResource dcResc) {
        FedoraId dcId = dcResc.getFedoraId();
        Resource dcRdfResc = this.getRdfResource(dcResc);
        Instant dcLastModified = dcResc.getLastModifiedDate();
        this.indexManager.endMembershipForSource(txId, dcResc.getFedoraId(), dcLastModified);
        dcResc.getChildren().filter(child -> !(child instanceof Tombstone)).map(child -> this.generateDirectMembership(dcRdfResc, (FedoraResource)child)).forEach(newMembership -> this.indexManager.addMembership(txId, dcId, (Triple)newMembership, dcLastModified));
    }

    private void modifyDCOnDemandVersioning(String txId, FedoraResource dcResc) {
        FedoraId dcId = dcResc.getFedoraId();
        List mementoDatetimes = dcResc.getTimeMap().listMementoDatetimes();
        Instant lastVersionDatetime = mementoDatetimes.size() == 0 ? null : (Instant)mementoDatetimes.get(mementoDatetimes.size() - 1);
        this.indexManager.deleteMembershipForSourceAfter(txId, dcId, lastVersionDatetime);
        this.populateMembershipHistory(txId, dcResc, lastVersionDatetime);
    }

    private Triple generateDirectMembership(Resource dcRdfResc, FedoraResource memberResc) {
        Resource memberRdfResc = this.getRdfResource(memberResc.getFedoraId());
        Resource membershipResc = this.getMembershipResource(dcRdfResc);
        Resource memberOfRel = this.getMemberOfRelation(dcRdfResc);
        Resource hasMemberRel = this.getHasMemberRelation(dcRdfResc);
        return this.generateMembershipTriple(membershipResc.asNode(), memberRdfResc.asNode(), hasMemberRel.asNode(), memberOfRel == null ? null : memberOfRel.asNode());
    }

    private Triple generateMembershipTriple(Node membership, Node member, Node hasMemberRel, Node memberOfRel) {
        if (memberOfRel != null) {
            return new Triple(member, memberOfRel, membership);
        }
        return new Triple(membership, hasMemberRel, member);
    }

    private boolean isDirectContainer(FedoraResource fedoraResc) {
        return fedoraResc instanceof Container && fedoraResc.hasType(RdfLexicon.DIRECT_CONTAINER.getURI());
    }

    private Resource getRdfResource(FedoraResource fedoraResc) {
        Model model = (Model)fedoraResc.getTriples().collect(RdfCollectors.toModel());
        return model.getResource(fedoraResc.getFedoraId().getFullId());
    }

    private Resource getRdfResource(FedoraId fedoraId) {
        return org.apache.jena.rdf.model.ResourceFactory.createResource((String)fedoraId.getFullId());
    }

    private Resource getMemberOfRelation(Resource resc) {
        Statement memberOfRelStmt = resc.getProperty(RdfLexicon.IS_MEMBER_OF_RELATION);
        if (memberOfRelStmt != null) {
            return memberOfRelStmt.getResource();
        }
        return null;
    }

    private Resource getHasMemberRelation(Resource resc) {
        Statement hasMemberStmt = resc.getProperty(RdfLexicon.HAS_MEMBER_RELATION);
        if (hasMemberStmt != null) {
            return hasMemberStmt.getResource();
        }
        return RdfLexicon.LDP_MEMBER;
    }

    private Resource getMembershipResource(Resource containerResc) {
        return containerResc.getPropertyResourceValue(RdfLexicon.MEMBERSHIP_RESOURCE);
    }

    private FedoraResource getFedoraResource(String txId, FedoraId fedoraId) {
        try {
            return this.resourceFactory.getResource(txId, fedoraId);
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private FedoraResource getParentResource(FedoraResource resc) {
        try {
            return resc.getParent();
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Transactional
    public void resourceDeleted(String txId, FedoraId fedoraId) {
        FedoraResource parentResc;
        FedoraResource fedoraResc;
        try {
            fedoraResc = this.getFedoraResource(txId, fedoraId);
        }
        catch (PathNotFoundRuntimeException e) {
            log.debug("Deleted resource {} does not have a tombstone, cleanup any references", (Object)fedoraId);
            this.indexManager.deleteMembershipReferences(txId, fedoraId);
            return;
        }
        if (fedoraResc instanceof Tombstone) {
            fedoraResc = ((Tombstone)fedoraResc).getDeletedObject();
        }
        if (this.isDirectContainer(fedoraResc)) {
            this.indexManager.endMembershipForSource(txId, fedoraId, fedoraResc.getLastModifiedDate());
        }
        if (this.isDirectContainer(parentResc = this.getParentResource(fedoraResc))) {
            Resource parentRdfResc = this.getRdfResource(parentResc);
            Triple deletedMembership = this.generateDirectMembership(parentRdfResc, fedoraResc);
            this.indexManager.endMembership(txId, parentResc.getFedoraId(), deletedMembership, fedoraResc.getLastModifiedDate());
        }
    }

    public RdfStream getMembership(String txId, FedoraId fedoraId) {
        FedoraId subjectId = fedoraId.isDescription() ? fedoraId.asBaseId() : fedoraId;
        Node subject = NodeFactory.createURI((String)subjectId.getBaseId());
        Stream<Triple> membershipStream = this.indexManager.getMembership(txId, subjectId);
        return new DefaultRdfStream(subject, membershipStream);
    }

    @Transactional
    public void commitTransaction(String txId) {
        this.indexManager.commitTransaction(txId);
    }

    public void rollbackTransaction(String txId) {
        this.indexManager.deleteTransaction(txId);
    }

    public void reset() {
        this.indexManager.clearIndex();
    }

    @Transactional
    public void populateMembershipHistory(String txId, FedoraId containerId) {
        FedoraResource fedoraResc = this.getFedoraResource(txId, containerId);
        if (this.isDirectContainer(fedoraResc)) {
            this.populateMembershipHistory(txId, fedoraResc, null);
        }
    }

    private void populateMembershipHistory(String txId, FedoraResource fedoraResc, Instant afterTime) {
        FedoraId containerId = fedoraResc.getFedoraId();
        List<DirectContainerProperties> propertyTimeline = this.makePropertyTimeline(fedoraResc);
        List<DirectContainerProperties> timeline = afterTime != null ? propertyTimeline.stream().filter(e -> e.startDatetime.compareTo(afterTime) >= 0 || e.endDatetime.compareTo(afterTime) >= 0).collect(Collectors.toList()) : propertyTimeline;
        fedoraResc.getChildren().forEach(member -> {
            boolean memberDeleted = member instanceof Tombstone;
            Node memberNode = NodeFactory.createURI((String)member.getFedoraId().getFullId());
            log.debug("Populating membership history for DirectContainer {}member {}", (Object)(memberDeleted ? "deleted " : ""), (Object)member.getFedoraId());
            Instant memberCreated = memberDeleted ? ((Tombstone)member).getDeletedObject().getCreatedDate() : member.getCreatedDate();
            Instant memberModified = member.getLastModifiedDate();
            Instant memberEnd = memberDeleted ? memberModified : NO_END_INSTANT;
            Stream<DirectContainerProperties> timelineStream = timeline.stream().filter(e -> e.endDatetime.compareTo(memberCreated) > 0);
            if (memberDeleted) {
                timelineStream = timelineStream.filter(e -> e.startDatetime.compareTo(memberModified) < 0);
            }
            timelineStream.forEach(e -> this.indexManager.addMembership(txId, containerId, this.generateMembershipTriple(e.membershipResource, memberNode, e.hasMemberRelation, e.isMemberOfRelation), this.instantMax(memberCreated, e.startDatetime), this.instantMin(memberEnd, e.endDatetime)));
        });
    }

    private Instant instantMax(Instant first, Instant second) {
        if (first.isAfter(second)) {
            return first;
        }
        return second;
    }

    private Instant instantMin(Instant first, Instant second) {
        if (first.isBefore(second)) {
            return first;
        }
        return second;
    }

    private List<DirectContainerProperties> makePropertyTimeline(FedoraResource fedoraResc) {
        ArrayList entryList = fedoraResc.getTimeMap().getChildren().map(memento -> new DirectContainerProperties((FedoraResource)memento)).collect(Collectors.toCollection(ArrayList::new));
        if (!this.propsConfig.isAutoVersioningEnabled()) {
            entryList.add(new DirectContainerProperties(fedoraResc));
        }
        ((DirectContainerProperties)entryList.get((int)0)).startDatetime = fedoraResc.getCreatedDate();
        ArrayList<DirectContainerProperties> changeEntries = new ArrayList<DirectContainerProperties>();
        DirectContainerProperties curr = (DirectContainerProperties)entryList.get(0);
        changeEntries.add(curr);
        for (int i = 1; i < entryList.size(); ++i) {
            DirectContainerProperties next = (DirectContainerProperties)entryList.get(i);
            if (Objects.equals(next.membershipResource, curr.membershipResource) && Objects.equals(next.hasMemberRelation, curr.hasMemberRelation) && Objects.equals(next.isMemberOfRelation, curr.isMemberOfRelation)) continue;
            curr.endDatetime = next.startDatetime;
            changeEntries.add(next);
            curr = next;
        }
        return changeEntries;
    }

    public Instant getLastUpdatedTimestamp(String txId, FedoraId fedoraId) {
        return this.indexManager.getLastUpdated(txId, fedoraId);
    }

    public void setMembershipIndexManager(MembershipIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    private static class DirectContainerProperties {
        public Node membershipResource;
        public Node hasMemberRelation;
        public Node isMemberOfRelation;
        public Instant startDatetime;
        public Instant endDatetime = NO_END_INSTANT;

        public DirectContainerProperties(FedoraResource fedoraResc) {
            this.startDatetime = fedoraResc.isMemento() ? fedoraResc.getMementoDatetime() : fedoraResc.getLastModifiedDate();
            fedoraResc.getTriples().forEach(triple -> {
                if (RdfLexicon.MEMBERSHIP_RESOURCE.asNode().equals((Object)triple.getPredicate())) {
                    this.membershipResource = triple.getObject();
                } else if (RdfLexicon.HAS_MEMBER_RELATION.asNode().equals((Object)triple.getPredicate())) {
                    this.hasMemberRelation = triple.getObject();
                } else if (RdfLexicon.IS_MEMBER_OF_RELATION.asNode().equals((Object)triple.getPredicate())) {
                    this.isMemberOfRelation = triple.getObject();
                }
            });
        }
    }
}

