/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ExternalContent;
import org.fcrepo.kernel.api.operations.NonRdfSourceOperation;
import org.fcrepo.kernel.api.operations.NonRdfSourceOperationBuilder;
import org.fcrepo.kernel.api.operations.NonRdfSourceOperationFactory;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.services.ReplaceBinariesService;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.common.MultiDigestInputStreamWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReplaceBinariesServiceImpl
extends AbstractService
implements ReplaceBinariesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplaceBinariesServiceImpl.class);
    @Inject
    private PersistentStorageSessionManager psManager;
    @Inject
    private NonRdfSourceOperationFactory factory;

    public void perform(Transaction tx, String userPrincipal, FedoraId fedoraId, String filename, String contentType, Collection<URI> digests, InputStream contentBody, long contentSize, ExternalContent externalContent) {
        String txId = tx.getId();
        try {
            NonRdfSourceOperationBuilder builder;
            PersistentStorageSession pSession = this.psManager.getSession(txId);
            String mimeType = contentType;
            long size = contentSize;
            if (externalContent == null || externalContent.isCopy()) {
                InputStream contentInputStream = contentBody;
                if (externalContent != null) {
                    LOGGER.debug("External content COPY '{}', '{}'", (Object)fedoraId, (Object)externalContent.getURL());
                    contentInputStream = externalContent.fetchExternalContent();
                }
                builder = this.factory.updateInternalBinaryBuilder(fedoraId, contentInputStream);
            } else {
                builder = this.factory.updateExternalBinaryBuilder(fedoraId, externalContent.getHandling(), externalContent.getURI());
                if (contentSize == -1L) {
                    size = externalContent.getContentSize();
                }
                if (!digests.isEmpty()) {
                    MultiDigestInputStreamWrapper multiDigestWrapper = new MultiDigestInputStreamWrapper(externalContent.fetchExternalContent(), digests, Collections.emptyList());
                    multiDigestWrapper.checkFixity();
                }
            }
            if (externalContent != null && externalContent.getContentType() != null) {
                mimeType = externalContent.getContentType();
            }
            builder.mimeType(mimeType).contentSize(size).filename(filename).contentDigests(digests).userPrincipal(userPrincipal);
            NonRdfSourceOperation replaceOp = builder.build();
            this.lockArchivalGroupResource(tx, pSession, fedoraId);
            tx.lockResource(fedoraId);
            tx.lockResource(fedoraId.asDescription());
            pSession.persist((ResourceOperation)replaceOp);
            this.recordEvent(txId, fedoraId, (ResourceOperation)replaceOp);
        }
        catch (PersistentStorageException ex) {
            throw new RepositoryRuntimeException(String.format("failed to replace binary %s", fedoraId), (Throwable)ex);
        }
    }
}

