/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.VersionResourceOperationFactory;
import org.fcrepo.kernel.api.services.VersionService;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.springframework.stereotype.Component;

@Component
public class VersionServiceImpl
extends AbstractService
implements VersionService {
    @Inject
    private PersistentStorageSessionManager psManager;
    @Inject
    private VersionResourceOperationFactory versionOperationFactory;

    public void createVersion(Transaction transaction, FedoraId fedoraId, String userPrincipal) {
        PersistentStorageSession session = this.psManager.getSession(transaction.getId());
        ResourceOperation operation = this.versionOperationFactory.createBuilder(fedoraId).userPrincipal(userPrincipal).build();
        this.lockArchivalGroupResource(transaction, session, fedoraId);
        ResourceHeaders headers = session.getHeaders(fedoraId, null);
        if ("http://fedora.info/definitions/v4/repository#NonRdfSourceDescription".equals(headers.getInteractionModel())) {
            transaction.lockResource(fedoraId.asBaseId());
        }
        if (RdfLexicon.NON_RDF_SOURCE.toString().equals(headers.getInteractionModel())) {
            transaction.lockResource(fedoraId.asDescription());
        }
        transaction.lockResource(fedoraId);
        try {
            session.persist(operation);
            this.recordEvent(transaction.getId(), fedoraId, operation);
        }
        catch (PersistentStorageException e) {
            throw new RepositoryRuntimeException(String.format("Failed to create new version of %s", fedoraId.getResourceId()), (Throwable)e);
        }
    }

    @VisibleForTesting
    void setPsManager(PersistentStorageSessionManager psManager) {
        this.psManager = psManager;
    }

    @VisibleForTesting
    void setVersionOperationFactory(VersionResourceOperationFactory versionOperationFactory) {
        this.versionOperationFactory = versionOperationFactory;
    }
}

