/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import javax.inject.Inject;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundRuntimeException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.api.models.WebacAcl;
import org.fcrepo.kernel.api.operations.CreateRdfSourceOperation;
import org.fcrepo.kernel.api.operations.RdfSourceOperationFactory;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.services.WebacAclService;
import org.fcrepo.kernel.impl.models.WebacAclImpl;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.springframework.stereotype.Component;

@Component
public class WebacAclServiceImpl
extends AbstractService
implements WebacAclService {
    @Inject
    private PersistentStorageSessionManager psManager;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private RdfSourceOperationFactory rdfSourceOperationFactory;

    public WebacAcl find(Transaction transaction, FedoraId fedoraId) {
        try {
            return (WebacAcl)this.resourceFactory.getResource(transaction, fedoraId, WebacAclImpl.class);
        }
        catch (PathNotFoundException exc) {
            throw new PathNotFoundRuntimeException(exc.getMessage(), (Throwable)exc);
        }
    }

    public void create(Transaction transaction, FedoraId fedoraId, String userPrincipal, Model model) {
        PersistentStorageSession pSession = this.psManager.getSession(transaction.getId());
        this.ensureValidACLAuthorization(model);
        RdfStream stream = DefaultRdfStream.fromModel((Node)model.getResource(fedoraId.getFullId()).asNode(), (Model)model);
        CreateRdfSourceOperation createOp = this.rdfSourceOperationFactory.createBuilder(fedoraId, "http://fedora.info/definitions/v4/webac#Acl").parentId(fedoraId.asBaseId()).triples(stream).relaxedProperties(model).userPrincipal(userPrincipal).build();
        this.lockArchivalGroupResourceFromParent(transaction, pSession, fedoraId.asBaseId());
        transaction.lockResource(fedoraId);
        try {
            pSession.persist((ResourceOperation)createOp);
            this.recordEvent(transaction.getId(), fedoraId, (ResourceOperation)createOp);
        }
        catch (PersistentStorageException exc) {
            throw new RepositoryRuntimeException(String.format("failed to create resource %s", fedoraId), (Throwable)exc);
        }
    }
}

