/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.Instant;
import java.util.stream.Stream;
import org.fcrepo.common.metrics.MetricsHelper;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="containmentIndex")
public class ContainmentIndexMetrics
implements ContainmentIndex {
    private static final String METRIC_NAME = "fcrepo.db";
    private static final String DB = "db";
    private static final String CONTAINMENT = "containment";
    private static final String OPERATION = "operation";
    private static final Timer getContainsTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "getContains"});
    private static final Timer getContainsDeletedTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "getContainsDeleted"});
    private static final Timer getContainsByTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "getContainsBy"});
    private static final Timer removeContainedByTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "removeContainedBy"});
    private static final Timer removeResourceTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "removeResource"});
    private static final Timer purgeResourceTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "purgeResource"});
    private static final Timer addContainedByTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "addContainedBy"});
    private static final Timer commitTransactionTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "commitTransaction"});
    private static final Timer rollbackTransactionTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "rollbackTransaction"});
    private static final Timer resourceExistsTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "resourceExists"});
    private static final Timer getContainerIdByPathTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "getContainerIdByPath"});
    private static final Timer resetTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "reset"});
    private static final Timer hasResourcesStartingWithTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "hasResourcesStartingWith"});
    private static final Timer containmentLastUpdateTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "containmentLastUpdated"});
    @Autowired
    @Qualifier(value="containmentIndexImpl")
    private ContainmentIndex containmentIndexImpl;

    public Stream<String> getContains(Transaction tx, FedoraId fedoraId) {
        return (Stream)MetricsHelper.time((Timer)getContainsTimer, () -> this.containmentIndexImpl.getContains(tx, fedoraId));
    }

    public Stream<String> getContainsDeleted(Transaction tx, FedoraId fedoraId) {
        return (Stream)MetricsHelper.time((Timer)getContainsDeletedTimer, () -> this.containmentIndexImpl.getContainsDeleted(tx, fedoraId));
    }

    public String getContainedBy(Transaction tx, FedoraId resource) {
        return (String)MetricsHelper.time((Timer)getContainsByTimer, () -> this.containmentIndexImpl.getContainedBy(tx, resource));
    }

    public void removeContainedBy(Transaction tx, FedoraId parent, FedoraId child) {
        removeContainedByTimer.record(() -> this.containmentIndexImpl.removeContainedBy(tx, parent, child));
    }

    public void removeResource(Transaction tx, FedoraId resource) {
        removeResourceTimer.record(() -> this.containmentIndexImpl.removeResource(tx, resource));
    }

    public void purgeResource(Transaction tx, FedoraId resource) {
        purgeResourceTimer.record(() -> this.containmentIndexImpl.purgeResource(tx, resource));
    }

    public void addContainedBy(Transaction tx, FedoraId parent, FedoraId child) {
        addContainedByTimer.record(() -> this.containmentIndexImpl.addContainedBy(tx, parent, child));
    }

    public void addContainedBy(Transaction tx, FedoraId parent, FedoraId child, Instant startTime, Instant endTime) {
        addContainedByTimer.record(() -> this.containmentIndexImpl.addContainedBy(tx, parent, child, startTime, endTime));
    }

    public void commitTransaction(Transaction tx) {
        commitTransactionTimer.record(() -> this.containmentIndexImpl.commitTransaction(tx));
    }

    public void rollbackTransaction(Transaction tx) {
        rollbackTransactionTimer.record(() -> this.containmentIndexImpl.rollbackTransaction(tx));
    }

    public boolean resourceExists(Transaction tx, FedoraId fedoraId, boolean includeDeleted) {
        return (Boolean)MetricsHelper.time((Timer)resourceExistsTimer, () -> this.containmentIndexImpl.resourceExists(tx, fedoraId, includeDeleted));
    }

    public FedoraId getContainerIdByPath(Transaction tx, FedoraId fedoraId, boolean checkDeleted) {
        return (FedoraId)MetricsHelper.time((Timer)getContainerIdByPathTimer, () -> this.containmentIndexImpl.getContainerIdByPath(tx, fedoraId, checkDeleted));
    }

    public void reset() {
        resetTimer.record(() -> this.containmentIndexImpl.reset());
    }

    public boolean hasResourcesStartingWith(Transaction tx, FedoraId fedoraId) {
        return (Boolean)MetricsHelper.time((Timer)hasResourcesStartingWithTimer, () -> this.containmentIndexImpl.hasResourcesStartingWith(tx, fedoraId));
    }

    public Instant containmentLastUpdated(Transaction tx, FedoraId fedoraId) {
        return (Instant)MetricsHelper.time((Timer)containmentLastUpdateTimer, () -> this.containmentIndexImpl.containmentLastUpdated(tx, fedoraId));
    }
}

