/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.net.URI;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.XSDDateTimeType;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.vocabulary.RDF;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.models.Binary;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.NonRdfSourceDescription;
import org.fcrepo.kernel.api.models.TimeMap;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.services.ManagedPropertiesService;
import org.springframework.stereotype.Component;

@Component
public class ManagedPropertiesServiceImpl
implements ManagedPropertiesService {
    public Stream<Triple> get(FedoraResource resource) {
        ArrayList<Triple> triples = new ArrayList<Triple>();
        Node subject = NodeFactory.createURI((String)this.resolveId(resource.getDescribedResource()));
        triples.add(Triple.create((Node)subject, (Node)RdfLexicon.CREATED_DATE.asNode(), (Node)NodeFactory.createLiteral((String)resource.getCreatedDate().toString(), (RDFDatatype)XSDDateTimeType.XSDdateTime)));
        triples.add(Triple.create((Node)subject, (Node)RdfLexicon.LAST_MODIFIED_DATE.asNode(), (Node)NodeFactory.createLiteral((String)resource.getLastModifiedDate().toString(), (RDFDatatype)XSDDateTimeType.XSDdateTime)));
        if (resource.getCreatedBy() != null) {
            triples.add(Triple.create((Node)subject, (Node)RdfLexicon.CREATED_BY.asNode(), (Node)NodeFactory.createLiteral((String)resource.getCreatedBy())));
        }
        if (resource.getLastModifiedBy() != null) {
            triples.add(Triple.create((Node)subject, (Node)RdfLexicon.LAST_MODIFIED_BY.asNode(), (Node)NodeFactory.createLiteral((String)resource.getLastModifiedBy())));
        }
        resource.getDescribedResource().getSystemTypes(true).forEach(triple -> triples.add(Triple.create((Node)subject, (Node)RDF.type.asNode(), (Node)NodeFactory.createURI((String)triple.toString()))));
        if (resource instanceof NonRdfSourceDescription) {
            Binary binary = (Binary)resource.getDescribedResource();
            triples.add(Triple.create((Node)subject, (Node)RdfLexicon.HAS_SIZE.asNode(), (Node)NodeFactory.createLiteral((String)String.valueOf(binary.getContentSize()), (RDFDatatype)XSDDatatype.XSDlong)));
            if (binary.getFilename() != null) {
                triples.add(Triple.create((Node)subject, (Node)RdfLexicon.HAS_ORIGINAL_NAME.asNode(), (Node)NodeFactory.createLiteral((String)binary.getFilename())));
            }
            if (binary.getMimeType() != null) {
                triples.add(Triple.create((Node)subject, (Node)RdfLexicon.HAS_MIME_TYPE.asNode(), (Node)NodeFactory.createLiteral((String)binary.getMimeType())));
            }
            if (binary.getContentDigests() != null) {
                for (URI digest : binary.getContentDigests()) {
                    triples.add(Triple.create((Node)subject, (Node)RdfLexicon.HAS_MESSAGE_DIGEST.asNode(), (Node)NodeFactory.createURI((String)digest.toString())));
                }
            }
        }
        return new DefaultRdfStream(subject, triples.stream());
    }

    private String resolveId(FedoraResource resource) {
        if (resource instanceof TimeMap) {
            return resource.getFedoraId().getFullId();
        }
        return resource.getId();
    }
}

