/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.cache.UserTypesCache;
import org.fcrepo.kernel.api.exception.ACLAuthorizationConstraintViolationException;
import org.fcrepo.kernel.api.exception.MalformedRdfException;
import org.fcrepo.kernel.api.exception.RequestWithAclLinkHeaderException;
import org.fcrepo.kernel.api.exception.ServerManagedPropertyException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.observer.EventAccumulator;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.services.MembershipService;
import org.fcrepo.kernel.api.services.ReferenceService;
import org.fcrepo.kernel.impl.services.ReplacePropertiesServiceImpl;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.search.api.SearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractService {
    private static final Logger log = LoggerFactory.getLogger(ReplacePropertiesServiceImpl.class);
    private static final Node WEBAC_ACCESS_TO_URI = NodeFactory.createURI((String)"http://www.w3.org/ns/auth/acl#accessTo");
    private static final Node WEBAC_ACCESS_TO_CLASS_URI = NodeFactory.createURI((String)"http://www.w3.org/ns/auth/acl#accessToClass");
    @Autowired
    @Qualifier(value="containmentIndex")
    protected ContainmentIndex containmentIndex;
    @Inject
    private EventAccumulator eventAccumulator;
    @Autowired
    @Qualifier(value="referenceService")
    protected ReferenceService referenceService;
    @Inject
    protected MembershipService membershipService;
    @Inject
    protected SearchIndex searchIndex;
    @Inject
    protected FedoraPropsConfig fedoraPropsConfig;
    @Inject
    protected UserTypesCache userTypesCache;

    protected String determineInteractionModel(List<String> linkTypes, boolean isRdfContentType, boolean contentPresent, boolean isExternalContent) {
        String interactionModel;
        String string = interactionModel = linkTypes == null ? null : (String)linkTypes.stream().filter(RdfLexicon.INTERACTION_MODELS_FULL::contains).findFirst().orElse(null);
        if (interactionModel != null) {
            return interactionModel;
        }
        if (isExternalContent || contentPresent && !isRdfContentType) {
            return RdfLexicon.NON_RDF_SOURCE.toString();
        }
        return RdfLexicon.DEFAULT_INTERACTION_MODEL.toString();
    }

    protected void checkAclLinkHeader(List<String> links) throws RequestWithAclLinkHeaderException {
        Predicate<String> matcher = Pattern.compile("rel=[\"']?acl[\"']?").asPredicate();
        if (links != null && links.stream().anyMatch(matcher)) {
            throw new RequestWithAclLinkHeaderException("Unable to handle request with the specified LDP-RS as the ACL.");
        }
    }

    protected void ensureValidDirectContainer(FedoraId fedoraId, String interactionModel, Model model) {
        boolean isIndirect = RdfLexicon.INDIRECT_CONTAINER.getURI().equals(interactionModel);
        if (!RdfLexicon.DIRECT_CONTAINER.getURI().equals(interactionModel) && !isIndirect) {
            return;
        }
        Resource dcResc = model.getResource(fedoraId.getFullId());
        AtomicBoolean hasMembershipResc = new AtomicBoolean(false);
        AtomicBoolean hasRelation = new AtomicBoolean(false);
        AtomicInteger insertedContentRelationCount = new AtomicInteger(0);
        dcResc.listProperties().forEachRemaining(stmt -> {
            Property predicate = stmt.getPredicate();
            if (RdfLexicon.MEMBERSHIP_RESOURCE.equals(predicate)) {
                if (hasMembershipResc.get()) {
                    throw new MalformedRdfException("Direct and Indirect containers must specify exactly one ldp:membershipResource property, multiple are present");
                }
                if (!stmt.getObject().isURIResource()) throw new MalformedRdfException("Direct and Indirect containers must specify a ldp:membershipResource property with a resource as the object");
                hasMembershipResc.set(true);
                return;
            } else if (RdfLexicon.HAS_MEMBER_RELATION.equals(predicate) || RdfLexicon.IS_MEMBER_OF_RELATION.equals(predicate)) {
                if (hasRelation.get()) {
                    throw new MalformedRdfException("Direct and Indirect containers must specify exactly one ldp:hasMemberRelation or ldp:isMemberOfRelation property, but multiple were present");
                }
                RDFNode obj = stmt.getObject();
                if (!obj.isURIResource()) throw new MalformedRdfException("Direct and Indirect containers must specify either ldp:hasMemberRelation or ldp:isMemberOfRelation properties, with a predicate as the object");
                String uri = obj.asResource().getURI();
                if (RdfLexicon.isManagedPredicate.test(ResourceFactory.createProperty((String)uri))) {
                    throw new ServerManagedPropertyException(String.format("%s cannot take a server managed property as an object: property value = %s.", predicate.getLocalName(), uri));
                }
                hasRelation.set(true);
                return;
            } else {
                if (!isIndirect || !RdfLexicon.INSERTED_CONTENT_RELATION.equals(predicate)) return;
                insertedContentRelationCount.incrementAndGet();
                RDFNode obj = stmt.getObject();
                if (!obj.isURIResource()) throw new MalformedRdfException("Indirect containers must specify an ldp:insertedContentRelation property with a URI property as the object");
                String uri = obj.asResource().getURI();
                if (!RdfLexicon.isManagedPredicate.test(ResourceFactory.createProperty((String)uri))) return;
                throw new ServerManagedPropertyException(String.format("%s cannot take a server managed property as an object: property value = %s.", predicate.getLocalName(), uri));
            }
        });
        if (isIndirect) {
            if (insertedContentRelationCount.get() > 1) {
                throw new MalformedRdfException("Indirect containers must contain exactly one triple with the predicate ldp:insertedContentRelation and a property as the object.");
            }
            if (insertedContentRelationCount.get() == 0) {
                dcResc.addProperty(RdfLexicon.INSERTED_CONTENT_RELATION, (RDFNode)RdfLexicon.MEMBER_SUBJECT);
            }
        }
        if (!hasMembershipResc.get()) {
            dcResc.addProperty(RdfLexicon.MEMBERSHIP_RESOURCE, (RDFNode)dcResc);
        }
        if (!hasRelation.get()) {
            dcResc.addProperty(RdfLexicon.HAS_MEMBER_RELATION, (RDFNode)RdfLexicon.LDP_MEMBER);
        }
    }

    protected void ensureValidACLAuthorization(Model inputModel) {
        HashSet uniqueAuthSubjects = new HashSet();
        inputModel.listStatements().forEachRemaining(s -> {
            log.debug("statement: s={}, p={}, o={}", new Object[]{s.getSubject(), s.getPredicate(), s.getObject()});
            Node subject = s.getSubject().asNode();
            if (subject.toString().contains("/fcr:acl#")) {
                uniqueAuthSubjects.add(subject);
            }
        });
        Graph graph = inputModel.getGraph();
        uniqueAuthSubjects.forEach(subject -> {
            if (graph.contains(subject, WEBAC_ACCESS_TO_URI, Node.ANY) && graph.contains(subject, WEBAC_ACCESS_TO_CLASS_URI, Node.ANY)) {
                throw new ACLAuthorizationConstraintViolationException(String.format("Using both accessTo and accessToClass within a single Authorization is not allowed: %s.", subject.toString().substring(subject.toString().lastIndexOf("#"))));
            }
            if (!graph.contains(subject, WEBAC_ACCESS_TO_URI, Node.ANY) && !graph.contains(subject, WEBAC_ACCESS_TO_CLASS_URI, Node.ANY)) {
                inputModel.add(this.createDefaultAccessToStatement(subject.toString()));
            }
        });
    }

    protected void recordEvent(Transaction transaction, FedoraId fedoraId, ResourceOperation operation) {
        this.eventAccumulator.recordEventForOperation(transaction, fedoraId, operation);
    }

    protected void updateReferences(Transaction transaction, FedoraId resourceId, String user, Model model) {
        this.referenceService.updateReferences(transaction, resourceId, user, DefaultRdfStream.fromModel((Node)model.getResource(resourceId.getFullId()).asNode(), (Model)model));
    }

    protected void lockArchivalGroupResource(Transaction tx, PersistentStorageSession pSession, FedoraId fedoraId) {
        ResourceHeaders headers = pSession.getHeaders(fedoraId, null);
        if (headers.getArchivalGroupId() != null) {
            tx.lockResource(headers.getArchivalGroupId());
        }
    }

    protected void lockArchivalGroupResourceFromParent(Transaction tx, PersistentStorageSession pSession, FedoraId parentId) {
        if (parentId != null && !parentId.isRepositoryRoot()) {
            ResourceHeaders parentHeaders = pSession.getHeaders(parentId, null);
            if (parentHeaders.isArchivalGroup()) {
                tx.lockResource(parentId);
            } else if (parentHeaders.getArchivalGroupId() != null) {
                tx.lockResource(parentHeaders.getArchivalGroupId());
            }
        }
    }

    private Statement createDefaultAccessToStatement(String authSubject) {
        String currentResourcePath = authSubject.substring(0, authSubject.indexOf("/fcr:acl"));
        return ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)authSubject), (Property)RdfLexicon.WEBAC_ACCESS_TO_PROPERTY, (RDFNode)ResourceFactory.createResource((String)currentResourcePath));
    }
}

