/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Link;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.CannotCreateResourceException;
import org.fcrepo.kernel.api.exception.InteractionModelViolationException;
import org.fcrepo.kernel.api.exception.ItemNotFoundException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ExternalContent;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.operations.CreateNonRdfSourceOperationBuilder;
import org.fcrepo.kernel.api.operations.CreateRdfSourceOperation;
import org.fcrepo.kernel.api.operations.NonRdfSourceOperation;
import org.fcrepo.kernel.api.operations.NonRdfSourceOperationFactory;
import org.fcrepo.kernel.api.operations.RdfSourceOperationFactory;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.services.CreateResourceService;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentItemNotFoundException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.common.MultiDigestInputStreamWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CreateResourceServiceImpl
extends AbstractService
implements CreateResourceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateResourceServiceImpl.class);
    @Inject
    private PersistentStorageSessionManager psManager;
    @Inject
    private RdfSourceOperationFactory rdfSourceOperationFactory;
    @Inject
    private NonRdfSourceOperationFactory nonRdfSourceOperationFactory;

    public void perform(Transaction tx, String userPrincipal, FedoraId fedoraId, String contentType, String filename, long contentSize, List<String> linkHeaders, Collection<URI> digest, InputStream requestBody, ExternalContent externalContent) {
        CreateNonRdfSourceOperationBuilder builder;
        PersistentStorageSession pSession = this.psManager.getSession(tx);
        this.checkAclLinkHeader(linkHeaders);
        FedoraId parentId = this.containmentIndex.getContainerIdByPath(tx, fedoraId, true);
        this.checkParent(pSession, parentId);
        String mimeType = contentType;
        long size = contentSize;
        if (externalContent == null || externalContent.isCopy()) {
            InputStream contentInputStream = requestBody;
            if (externalContent != null) {
                LOGGER.debug("External content COPY '{}', '{}'", (Object)fedoraId, (Object)externalContent.getURL());
                contentInputStream = externalContent.fetchExternalContent();
            }
            builder = this.nonRdfSourceOperationFactory.createInternalBinaryBuilder(tx, fedoraId, contentInputStream);
        } else {
            builder = this.nonRdfSourceOperationFactory.createExternalBinaryBuilder(tx, fedoraId, externalContent.getHandling(), externalContent.getURI());
            if (contentSize == -1L) {
                size = externalContent.getContentSize();
            }
            if (!digest.isEmpty()) {
                MultiDigestInputStreamWrapper multiDigestWrapper = new MultiDigestInputStreamWrapper(externalContent.fetchExternalContent(), digest, Collections.emptyList());
                multiDigestWrapper.checkFixity();
            }
        }
        if (externalContent != null && externalContent.getContentType() != null) {
            mimeType = externalContent.getContentType();
        }
        NonRdfSourceOperation createOp = builder.parentId(parentId).userPrincipal(userPrincipal).contentDigests(digest).mimeType(mimeType).contentSize(size).filename(filename).build();
        this.lockArchivalGroupResourceFromParent(tx, pSession, parentId);
        tx.lockResource(fedoraId);
        try {
            pSession.persist((ResourceOperation)createOp);
        }
        catch (PersistentStorageException exc) {
            throw new RepositoryRuntimeException(String.format("failed to create resource %s", fedoraId), (Throwable)exc);
        }
        this.createDescription(tx, pSession, userPrincipal, fedoraId);
        this.addToContainmentIndex(tx, parentId, fedoraId);
        this.membershipService.resourceCreated(tx, fedoraId);
        this.addToSearchIndex(tx, fedoraId, pSession);
        this.recordEvent(tx, fedoraId, (ResourceOperation)createOp);
    }

    private void createDescription(Transaction tx, PersistentStorageSession pSession, String userPrincipal, FedoraId binaryId) {
        FedoraId descId = binaryId.asDescription();
        CreateRdfSourceOperation createOp = this.rdfSourceOperationFactory.createBuilder(tx, descId, "http://fedora.info/definitions/v4/repository#NonRdfSourceDescription", this.fedoraPropsConfig.getServerManagedPropsMode()).userPrincipal(userPrincipal).parentId(binaryId).build();
        tx.lockResource(descId);
        try {
            pSession.persist((ResourceOperation)createOp);
            this.userTypesCache.cacheUserTypes(descId, Collections.emptyList(), pSession.getId());
        }
        catch (PersistentStorageException exc) {
            throw new RepositoryRuntimeException(String.format("failed to create description %s", descId), (Throwable)exc);
        }
    }

    public void perform(Transaction tx, String userPrincipal, FedoraId fedoraId, List<String> linkHeaders, Model model) {
        PersistentStorageSession pSession = this.psManager.getSession(tx);
        this.checkAclLinkHeader(linkHeaders);
        FedoraId parentId = this.containmentIndex.getContainerIdByPath(tx, fedoraId, true);
        this.checkParent(pSession, parentId);
        List<String> rdfTypes = CollectionUtils.isEmpty(linkHeaders) ? Collections.emptyList() : this.getTypes(linkHeaders);
        String interactionModel = this.determineInteractionModel(rdfTypes, true, model != null, false);
        RdfStream stream = DefaultRdfStream.fromModel((Node)model.getResource(fedoraId.getFullId()).asNode(), (Model)model);
        this.ensureValidDirectContainer(fedoraId, interactionModel, model);
        CreateRdfSourceOperation createOp = this.rdfSourceOperationFactory.createBuilder(tx, fedoraId, interactionModel, this.fedoraPropsConfig.getServerManagedPropsMode()).parentId(parentId).triples(stream).relaxedProperties(model).archivalGroup(rdfTypes.contains(RdfLexicon.ARCHIVAL_GROUP.getURI())).userPrincipal(userPrincipal).build();
        this.lockArchivalGroupResourceFromParent(tx, pSession, parentId);
        tx.lockResource(fedoraId);
        try {
            pSession.persist((ResourceOperation)createOp);
        }
        catch (PersistentStorageException exc) {
            throw new RepositoryRuntimeException(String.format("failed to create resource %s", fedoraId), (Throwable)exc);
        }
        this.userTypesCache.cacheUserTypes(fedoraId, DefaultRdfStream.fromModel((Node)model.getResource(fedoraId.getFullId()).asNode(), (Model)model), pSession.getId());
        this.updateReferences(tx, fedoraId, userPrincipal, model);
        this.addToContainmentIndex(tx, parentId, fedoraId);
        this.membershipService.resourceCreated(tx, fedoraId);
        this.addToSearchIndex(tx, fedoraId, pSession);
        this.recordEvent(tx, fedoraId, (ResourceOperation)createOp);
    }

    private void addToSearchIndex(Transaction tx, FedoraId fedoraId, PersistentStorageSession persistentStorageSession) {
        ResourceHeaders resourceHeaders = persistentStorageSession.getHeaders(fedoraId, null);
        this.searchIndex.addUpdateIndex(tx, resourceHeaders);
    }

    private void checkParent(PersistentStorageSession pSession, FedoraId fedoraId) throws RepositoryRuntimeException {
        if (fedoraId != null && !fedoraId.isRepositoryRoot()) {
            ResourceHeaders parent;
            try {
                parent = pSession.getHeaders(fedoraId.asResourceId(), null);
            }
            catch (PersistentItemNotFoundException exc) {
                throw new ItemNotFoundException(String.format("Item %s was not found", fedoraId), (Throwable)exc);
            }
            catch (PersistentStorageException exc) {
                throw new RepositoryRuntimeException(String.format("Failed to find storage headers for %s", fedoraId), (Throwable)exc);
            }
            if (parent.isDeleted()) {
                throw new CannotCreateResourceException(String.format("Cannot create resource as child of a tombstone. Tombstone found at %s", fedoraId.getFullIdPath()));
            }
            boolean isParentBinary = RdfLexicon.NON_RDF_SOURCE.toString().equals(parent.getInteractionModel());
            if (isParentBinary) {
                throw new InteractionModelViolationException("NonRdfSource resources cannot contain other resources");
            }
            boolean isPairTree = RdfLexicon.FEDORA_PAIR_TREE.toString().equals(parent.getInteractionModel());
            if (isPairTree) {
                throw new CannotCreateResourceException("Objects cannot be created under pairtree nodes");
            }
        }
    }

    private List<String> getTypes(List<String> headers) {
        List<Link> hdrobjs = this.getLinkHeaders(headers);
        try {
            return hdrobjs == null ? Collections.emptyList() : hdrobjs.stream().filter(p -> p.getRel().equalsIgnoreCase("type")).map(Link::getUri).map(URI::toString).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new BadRequestException("Invalid Link header type found", (Throwable)e);
        }
    }

    private List<Link> getLinkHeaders(List<String> headers) {
        return headers == null ? null : headers.stream().map(Link::valueOf).collect(Collectors.toList());
    }

    private void addToContainmentIndex(Transaction tx, FedoraId parentId, FedoraId id) {
        this.containmentIndex.addContainedBy(tx, parentId, id);
    }
}

