/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.lock;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.fcrepo.kernel.api.exception.ConcurrentUpdateException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.lock.ResourceLockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InMemoryResourceLockManager
implements ResourceLockManager {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryResourceLockManager.class);
    private final Map<String, Set<String>> transactionLocks = new ConcurrentHashMap<String, Set<String>>();
    private final Set<String> lockedResources = Sets.newConcurrentHashSet();
    private final Map<String, Object> internalResourceLocks = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build().asMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(String txId, FedoraId resourceId) {
        String resourceIdStr = resourceId.getResourceId();
        if (this.transactionHoldsLock(txId, resourceIdStr)) {
            return;
        }
        Object object = this.acquireInternalLock(resourceIdStr);
        synchronized (object) {
            if (this.transactionHoldsLock(txId, resourceIdStr)) {
                return;
            }
            if (this.lockedResources.contains(resourceIdStr)) {
                throw new ConcurrentUpdateException(String.format("Cannot update %s because it is being updated by another transaction.", resourceIdStr));
            }
            LOG.debug("Transaction {} acquiring lock on {}", (Object)txId, (Object)resourceIdStr);
            this.lockedResources.add(resourceIdStr);
            this.transactionLocks.computeIfAbsent(txId, key -> Sets.newConcurrentHashSet()).add(resourceIdStr);
        }
    }

    public void releaseAll(String txId) {
        Set<String> locks = this.transactionLocks.remove(txId);
        if (locks != null) {
            locks.forEach(resourceId -> {
                LOG.debug("Transaction {} releasing lock on {}", (Object)txId, resourceId);
                Object object = this.acquireInternalLock((String)resourceId);
                synchronized (object) {
                    this.lockedResources.remove(resourceId);
                    this.internalResourceLocks.remove(resourceId);
                }
            });
        }
    }

    private Object acquireInternalLock(String resourceId) {
        return this.internalResourceLocks.computeIfAbsent(resourceId, key -> new Object());
    }

    private boolean transactionHoldsLock(String txId, String resourceId) {
        Set<String> locks = this.transactionLocks.get(txId);
        return locks != null && locks.contains(resourceId);
    }
}

