/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.operations;

import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.fcrepo.config.ServerManagedPropsMode;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.RdfSourceOperationBuilder;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.utils.RelaxedPropertiesHelper;
import org.fcrepo.kernel.impl.operations.AbstractRelaxableResourceOperationBuilder;

public abstract class AbstractRdfSourceOperationBuilder
extends AbstractRelaxableResourceOperationBuilder
implements RdfSourceOperationBuilder {
    protected RdfStream tripleStream;
    protected String userPrincipal;
    protected final String interactionModel;

    protected AbstractRdfSourceOperationBuilder(Transaction transaction, FedoraId rescId, String model, ServerManagedPropsMode serverManagedPropsMode) {
        super(transaction, rescId, serverManagedPropsMode);
        this.interactionModel = model;
    }

    public RdfSourceOperationBuilder userPrincipal(String userPrincipal) {
        this.userPrincipal = userPrincipal;
        return this;
    }

    public RdfSourceOperationBuilder triples(RdfStream triples) {
        this.tripleStream = this.serverManagedPropsMode.equals((Object)ServerManagedPropsMode.RELAXED) ? new DefaultRdfStream(triples.topic(), triples.filter(t -> {
            try {
                RelaxedPropertiesHelper.checkTripleForDisallowed((Triple)t);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        })) : triples;
        return this;
    }

    public RdfSourceOperationBuilder relaxedProperties(Model model) {
        return (RdfSourceOperationBuilder)super.relaxedProperties(model);
    }
}

