/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.fcrepo.config.ServerManagedPropsMode;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.MalformedRdfException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.operations.NonRdfSourceOperationFactory;
import org.fcrepo.kernel.api.operations.RdfSourceOperation;
import org.fcrepo.kernel.api.operations.RdfSourceOperationFactory;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.services.ReplacePropertiesService;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.springframework.stereotype.Component;

@Component
public class ReplacePropertiesServiceImpl
extends AbstractService
implements ReplacePropertiesService {
    @Inject
    private PersistentStorageSessionManager psManager;
    @Inject
    private RdfSourceOperationFactory factory;
    @Inject
    private NonRdfSourceOperationFactory nonRdfFactory;

    public void perform(Transaction tx, String userPrincipal, FedoraId fedoraId, Model inputModel) throws MalformedRdfException {
        try {
            Optional<Object> secondaryOp;
            RdfSourceOperation primaryOp;
            PersistentStorageSession pSession = this.psManager.getSession(tx);
            ResourceHeaders headers = pSession.getHeaders(fedoraId, null);
            String interactionModel = headers.getInteractionModel();
            this.ensureValidDirectContainer(fedoraId, interactionModel, inputModel);
            this.ensureValidACLAuthorization(inputModel);
            BinaryHeaderDetails binHeaders = this.extractNonRdfSourceHeaderTriples(fedoraId, inputModel);
            RdfStream rdfStream = DefaultRdfStream.fromModel((Node)inputModel.createResource(fedoraId.getFullId()).asNode(), (Model)inputModel);
            ServerManagedPropsMode serverManagedMode = this.fedoraPropsConfig.getServerManagedPropsMode();
            if (fedoraId.isDescription()) {
                primaryOp = this.factory.updateBuilder(tx, fedoraId, serverManagedMode).userPrincipal(userPrincipal).triples(rdfStream).build();
                secondaryOp = Optional.of(this.nonRdfFactory.updateHeadersBuilder(tx, fedoraId, serverManagedMode).relaxedProperties(inputModel).userPrincipal(userPrincipal).filename(binHeaders.getFilename()).mimeType(binHeaders.getMimetype()).build());
            } else {
                primaryOp = this.factory.updateBuilder(tx, fedoraId, serverManagedMode).relaxedProperties(inputModel).userPrincipal(userPrincipal).triples(rdfStream).build();
                secondaryOp = Optional.empty();
            }
            this.lockArchivalGroupResource(tx, pSession, fedoraId);
            tx.lockResource(fedoraId);
            if ("http://fedora.info/definitions/v4/repository#NonRdfSourceDescription".equals(interactionModel)) {
                tx.lockResource(fedoraId.asBaseId());
            }
            pSession.persist((ResourceOperation)primaryOp);
            this.userTypesCache.cacheUserTypes(fedoraId, DefaultRdfStream.fromModel((Node)inputModel.getResource(fedoraId.getFullId()).asNode(), (Model)inputModel), pSession.getId());
            this.updateReferences(tx, fedoraId, userPrincipal, inputModel);
            this.membershipService.resourceModified(tx, fedoraId);
            this.searchIndex.addUpdateIndex(tx, pSession.getHeaders(fedoraId, null));
            this.recordEvent(tx, fedoraId, (ResourceOperation)primaryOp);
            secondaryOp.ifPresent(operation -> this.updateBinaryHeaders(tx, pSession, (ResourceOperation)operation));
        }
        catch (PersistentStorageException ex) {
            throw new RepositoryRuntimeException(String.format("failed to replace resource %s", fedoraId), (Throwable)ex);
        }
    }

    private void updateBinaryHeaders(Transaction tx, PersistentStorageSession pSession, ResourceOperation operation) {
        pSession.persist(operation);
        this.recordEvent(tx, operation.getResourceId(), operation);
    }

    protected BinaryHeaderDetails extractNonRdfSourceHeaderTriples(FedoraId fedoraId, Model model) {
        if (!fedoraId.isDescription()) {
            return null;
        }
        BinaryHeaderDetails details = new BinaryHeaderDetails();
        Resource binResc = model.getResource(fedoraId.getBaseId());
        if (binResc.hasProperty(RdfLexicon.HAS_MIME_TYPE)) {
            List mimetypes = binResc.listProperties(RdfLexicon.HAS_MIME_TYPE).toList();
            if (mimetypes.size() > 1) {
                throw new MalformedRdfException("Invalid RDF, cannot provided multiple values for property " + RdfLexicon.HAS_MIME_TYPE);
            }
            details.setMimetype(((Statement)mimetypes.get(0)).getString());
            binResc.removeAll(RdfLexicon.HAS_MIME_TYPE);
        }
        if (binResc.hasProperty(RdfLexicon.HAS_ORIGINAL_NAME)) {
            List filenames = binResc.listProperties(RdfLexicon.HAS_ORIGINAL_NAME).toList();
            if (filenames.size() > 1) {
                throw new MalformedRdfException("Invalid RDF, cannot provided multiple values for property " + RdfLexicon.HAS_ORIGINAL_NAME);
            }
            details.setFilename(((Statement)filenames.get(0)).getString());
            binResc.removeAll(RdfLexicon.HAS_ORIGINAL_NAME);
        }
        return details;
    }

    private static class BinaryHeaderDetails {
        private String mimetype;
        private String filename;

        private BinaryHeaderDetails() {
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public void setMimetype(String mimetype) {
            this.mimetype = mimetype;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }
    }
}

