/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.services.ContainmentTriplesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ContainmentTriplesServiceImpl
implements ContainmentTriplesService {
    @Autowired
    @Qualifier(value="containmentIndex")
    private ContainmentIndex containmentIndex;

    public Stream<Triple> get(Transaction tx, FedoraResource resource) {
        FedoraId fedoraId = resource.getFedoraId();
        String nodeUri = fedoraId.isMemento() ? fedoraId.getBaseId() : fedoraId.getFullId();
        Node currentNode = NodeFactory.createURI((String)nodeUri);
        return this.containmentIndex.getContains(tx, fedoraId).map(c -> new Triple(currentNode, RdfLexicon.CONTAINS.asNode(), NodeFactory.createURI((String)c)));
    }
}

