/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.XSDDateTimeType;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.vocabulary.RDF;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.models.Binary;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.TimeMap;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.services.ManagedPropertiesService;
import org.springframework.stereotype.Component;

@Component
public class ManagedPropertiesServiceImpl
implements ManagedPropertiesService {
    public Stream<Triple> get(FedoraResource resource) {
        ArrayList<Triple> triples = new ArrayList<Triple>();
        FedoraResource describedResource = resource.getDescribedResource();
        Node subject = NodeFactory.createURI((String)this.resolveId(describedResource));
        String createdBy = resource.getCreatedBy();
        Instant createdDate = resource.getCreatedDate();
        String lastModifiedBy = resource.getLastModifiedBy();
        Instant lastModifiedDate = resource.getLastModifiedDate();
        if (describedResource instanceof Binary) {
            Binary binary = (Binary)describedResource;
            createdBy = binary.getCreatedBy();
            createdDate = binary.getCreatedDate();
            lastModifiedBy = binary.getLastModifiedBy();
            lastModifiedDate = binary.getLastModifiedDate();
            triples.add(Triple.create((Node)subject, (Node)RdfLexicon.HAS_SIZE.asNode(), (Node)NodeFactory.createLiteral((String)String.valueOf(binary.getContentSize()), (RDFDatatype)XSDDatatype.XSDlong)));
            if (binary.getFilename() != null) {
                triples.add(Triple.create((Node)subject, (Node)RdfLexicon.HAS_ORIGINAL_NAME.asNode(), (Node)NodeFactory.createLiteral((String)binary.getFilename())));
            }
            if (binary.getMimeType() != null) {
                triples.add(Triple.create((Node)subject, (Node)RdfLexicon.HAS_MIME_TYPE.asNode(), (Node)NodeFactory.createLiteral((String)binary.getMimeType())));
            }
            if (binary.getContentDigests() != null) {
                for (URI digest : binary.getContentDigests()) {
                    triples.add(Triple.create((Node)subject, (Node)RdfLexicon.HAS_MESSAGE_DIGEST.asNode(), (Node)NodeFactory.createURI((String)digest.toString())));
                }
            }
        }
        triples.add(Triple.create((Node)subject, (Node)RdfLexicon.CREATED_DATE.asNode(), (Node)NodeFactory.createLiteral((String)createdDate.toString(), (RDFDatatype)XSDDateTimeType.XSDdateTime)));
        triples.add(Triple.create((Node)subject, (Node)RdfLexicon.LAST_MODIFIED_DATE.asNode(), (Node)NodeFactory.createLiteral((String)lastModifiedDate.toString(), (RDFDatatype)XSDDateTimeType.XSDdateTime)));
        if (createdBy != null) {
            triples.add(Triple.create((Node)subject, (Node)RdfLexicon.CREATED_BY.asNode(), (Node)NodeFactory.createLiteral((String)createdBy)));
        }
        if (lastModifiedBy != null) {
            triples.add(Triple.create((Node)subject, (Node)RdfLexicon.LAST_MODIFIED_BY.asNode(), (Node)NodeFactory.createLiteral((String)lastModifiedBy)));
        }
        describedResource.getSystemTypes(true).forEach(triple -> triples.add(Triple.create((Node)subject, (Node)RDF.type.asNode(), (Node)NodeFactory.createURI((String)triple.toString()))));
        return new DefaultRdfStream(subject, triples.stream());
    }

    private String resolveId(FedoraResource resource) {
        if (resource instanceof TimeMap) {
            return resource.getFedoraId().getFullId();
        }
        return resource.getId();
    }
}

