/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.util.stream.Stream;
import javax.inject.Inject;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.operations.DeleteResourceOperationFactory;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.services.PurgeResourceService;
import org.fcrepo.kernel.impl.services.AbstractDeleteResourceService;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PurgeResourceServiceImpl
extends AbstractDeleteResourceService
implements PurgeResourceService {
    private static final Logger log = LoggerFactory.getLogger(PurgeResourceServiceImpl.class);
    @Inject
    private DeleteResourceOperationFactory deleteResourceFactory;

    @Override
    protected Stream<String> getContained(Transaction tx, FedoraResource resource) {
        return this.containmentIndex.getContainsDeleted(tx, resource.getFedoraId());
    }

    @Override
    protected void doAction(Transaction tx, PersistentStorageSession pSession, FedoraId resourceId, String userPrincipal) throws PersistentStorageException {
        log.debug("starting purge of {}", (Object)resourceId.getFullId());
        ResourceOperation purgeOp = this.deleteResourceFactory.purgeBuilder(tx, resourceId).userPrincipal(userPrincipal).build();
        this.lockArchivalGroupResource(tx, pSession, resourceId);
        tx.lockResource(resourceId);
        pSession.persist(purgeOp);
        this.containmentIndex.purgeResource(tx, resourceId);
        this.recordEvent(tx, resourceId, purgeOp);
        log.debug("purged {}", (Object)resourceId.getFullId());
    }
}

