/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.models;

import java.net.URI;
import java.util.List;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.cache.UserTypesCache;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.NonRdfSourceDescription;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.impl.models.FedoraResourceImpl;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;

public class NonRdfSourceDescriptionImpl
extends FedoraResourceImpl
implements NonRdfSourceDescription {
    private static final URI RDF_SOURCE_URI = URI.create(RdfLexicon.RDF_SOURCE.getURI());

    public NonRdfSourceDescriptionImpl(FedoraId fedoraID, Transaction transaction, PersistentStorageSessionManager pSessionManager, ResourceFactory resourceFactory, UserTypesCache userTypesCache) {
        super(fedoraID, transaction, pSessionManager, resourceFactory, userTypesCache);
    }

    @Override
    public String getId() {
        return this.getFedoraId().getResourceId();
    }

    @Override
    public FedoraResource getDescribedResource() {
        FedoraId describedId = this.getFedoraId().asBaseId();
        if (this.getFedoraId().isMemento()) {
            describedId = describedId.asMemento(this.getFedoraId().getMementoInstant());
        }
        try {
            return this.resourceFactory.getResource(this.transaction, describedId);
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<URI> getSystemTypes(boolean forRdf) {
        List<URI> types = this.resolveSystemTypes(forRdf);
        if (types == null) {
            types = super.getSystemTypes(forRdf);
            types.add(RDF_SOURCE_URI);
        }
        return types;
    }

    @Override
    public RdfStream getTriples() {
        Node describedID = NodeFactory.createURI((String)this.getDescribedResource().getId());
        Stream triples = super.getTriples().map(t -> {
            if (t.getSubject().hasURI(this.getId())) {
                return new Triple(describedID, t.getPredicate(), t.getObject());
            }
            return t;
        });
        return new DefaultRdfStream(describedID, triples);
    }
}

