/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.util.stream.Stream;
import javax.inject.Inject;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.operations.DeleteResourceOperationFactory;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.services.DeleteResourceService;
import org.fcrepo.kernel.impl.services.AbstractDeleteResourceService;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeleteResourceServiceImpl
extends AbstractDeleteResourceService
implements DeleteResourceService {
    private static final Logger log = LoggerFactory.getLogger(DeleteResourceService.class);
    @Inject
    private DeleteResourceOperationFactory deleteResourceFactory;

    @Override
    protected Stream<String> getContained(Transaction tx, FedoraResource resource) {
        return this.containmentIndex.getContains(tx, resource.getFedoraId());
    }

    @Override
    protected void doAction(Transaction tx, PersistentStorageSession pSession, FedoraId fedoraId, String userPrincipal) throws PersistentStorageException {
        log.debug("starting delete of {}", (Object)fedoraId.getFullId());
        ResourceOperation deleteOp = this.deleteResourceFactory.deleteBuilder(tx, fedoraId).userPrincipal(userPrincipal).build();
        this.lockArchivalGroupResource(tx, pSession, fedoraId);
        tx.lockResource(fedoraId);
        pSession.persist(deleteOp);
        this.membershipService.resourceDeleted(tx, fedoraId);
        this.containmentIndex.removeResource(tx, fedoraId);
        this.referenceService.deleteAllReferences(tx, fedoraId);
        this.searchIndex.removeFromIndex(tx, fedoraId);
        this.recordEvent(tx, fedoraId, deleteOp);
        log.debug("deleted {}", (Object)fedoraId.getFullId());
    }
}

