/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import javax.inject.Inject;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.TransactionManager;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.ReindexResourceOperationFactory;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.services.ReindexService;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.springframework.stereotype.Component;

@Component
public class ReindexServiceImpl
extends AbstractService
implements ReindexService {
    @Inject
    private TransactionManager transactionManager;
    @Inject
    private PersistentStorageSessionManager persistentStorageSessionManager;
    @Inject
    private ReindexResourceOperationFactory resourceOperationFactory;

    public void reindexByFedoraId(Transaction transaction, String principal, FedoraId fedoraId) {
        Transaction tx = this.transactionManager.get(transaction.getId());
        PersistentStorageSession psession = this.persistentStorageSessionManager.getSession(transaction);
        ResourceOperation operation = this.resourceOperationFactory.create(transaction, fedoraId).userPrincipal(principal).build();
        tx.lockResource(fedoraId);
        psession.persist(operation);
    }
}

