/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.fcrepo.common.db.DbPlatform;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="containmentIndexImpl")
public class ContainmentIndexImpl
implements ContainmentIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainmentIndexImpl.class);
    private int containsLimit = 50000;
    @Inject
    private DataSource dataSource;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private DbPlatform dbPlatform;
    public static final String RESOURCES_TABLE = "containment";
    private static final String TRANSACTION_OPERATIONS_TABLE = "containment_transactions";
    public static final String FEDORA_ID_COLUMN = "fedora_id";
    private static final String PARENT_COLUMN = "parent";
    private static final String TRANSACTION_ID_COLUMN = "transaction_id";
    private static final String OPERATION_COLUMN = "operation";
    private static final String START_TIME_COLUMN = "start_time";
    private static final String END_TIME_COLUMN = "end_time";
    private static final String UPDATED_COLUMN = "updated";
    private static final String SELECT_CHILDREN = "SELECT fedora_id FROM containment WHERE parent = :parent AND end_time IS NULL ORDER BY fedora_id LIMIT :containsLimit OFFSET :offSet";
    private static final String SELECT_CHILDREN_OF_MEMENTO = "SELECT fedora_id FROM containment WHERE parent = :parent AND start_time <= :asOfTime AND (end_time > :asOfTime OR end_time IS NULL) ORDER BY fedora_id LIMIT :containsLimit OFFSET :offSet";
    private static final String SELECT_CHILDREN_IN_TRANSACTION = "SELECT x.fedora_id FROM (SELECT fedora_id FROM containment WHERE parent = :parent AND end_time IS NULL  UNION SELECT fedora_id FROM containment_transactions WHERE parent = :parent AND transaction_id = :transactionId AND operation = 'add') x WHERE NOT EXISTS  (SELECT 1 FROM containment_transactions WHERE parent = :parent AND fedora_id = x.fedora_id AND transaction_id = :transactionId AND operation IN ('delete', 'purge')) ORDER BY x.fedora_id LIMIT :containsLimit OFFSET :offSet";
    private static final String SELECT_DELETED_CHILDREN = "SELECT fedora_id FROM containment WHERE parent = :parent AND end_time IS NOT NULL ORDER BY fedora_id LIMIT :containsLimit OFFSET :offSet";
    private static final String SELECT_DELETED_CHILDREN_IN_TRANSACTION = "SELECT x.fedora_id FROM (SELECT fedora_id FROM containment WHERE parent = :parent AND end_time IS NOT NULL UNION SELECT fedora_id FROM containment_transactions WHERE parent = :parent AND transaction_id = :transactionId AND operation = 'delete') x WHERE NOT EXISTS (SELECT 1 FROM containment_transactions WHERE parent = :parent AND fedora_id = x.fedora_id AND transaction_id = :transactionId AND operation = 'add') ORDER BY x.fedora_id LIMIT :containsLimit OFFSET :offSet";
    private static final String UPSERT_RECORDS_POSTGRESQL = "INSERT INTO containment_transactions ( parent, fedora_id, start_time, end_time, transaction_id, operation) VALUES (:parent, :child, :startTime, :endTime, :transactionId, :operation) ON CONFLICT ( fedora_id, transaction_id) DO UPDATE SET parent = EXCLUDED.parent, start_time = EXCLUDED.start_time, end_time = EXCLUDED.end_time, operation = EXCLUDED.operation";
    private static final String UPSERT_RECORDS_MYSQL_MARIA = "INSERT INTO containment_transactions (parent, fedora_id, start_time, end_time, transaction_id, operation) VALUES (:parent, :child, :startTime, :endTime, :transactionId, :operation) ON DUPLICATE KEY UPDATE parent = VALUES(parent), start_time = VALUES(start_time), end_time = VALUES(end_time), operation = VALUES(operation)";
    private static final String UPSERT_RECORDS_H2 = "MERGE INTO containment_transactions (parent, fedora_id, start_time, end_time, transaction_id, operation) KEY (fedora_id, transaction_id) VALUES (:parent, :child, :startTime, :endTime, :transactionId, :operation)";
    private static final String DIRECT_UPDATE_END_TIME = "UPDATE containment SET end_time = :endTime WHERE parent = :parent AND fedora_id = :child";
    private static final Map<DbPlatform, String> UPSERT_MAPPING = Map.of(DbPlatform.H2, "MERGE INTO containment_transactions (parent, fedora_id, start_time, end_time, transaction_id, operation) KEY (fedora_id, transaction_id) VALUES (:parent, :child, :startTime, :endTime, :transactionId, :operation)", DbPlatform.MYSQL, "INSERT INTO containment_transactions (parent, fedora_id, start_time, end_time, transaction_id, operation) VALUES (:parent, :child, :startTime, :endTime, :transactionId, :operation) ON DUPLICATE KEY UPDATE parent = VALUES(parent), start_time = VALUES(start_time), end_time = VALUES(end_time), operation = VALUES(operation)", DbPlatform.MARIADB, "INSERT INTO containment_transactions (parent, fedora_id, start_time, end_time, transaction_id, operation) VALUES (:parent, :child, :startTime, :endTime, :transactionId, :operation) ON DUPLICATE KEY UPDATE parent = VALUES(parent), start_time = VALUES(start_time), end_time = VALUES(end_time), operation = VALUES(operation)", DbPlatform.POSTGRESQL, "INSERT INTO containment_transactions ( parent, fedora_id, start_time, end_time, transaction_id, operation) VALUES (:parent, :child, :startTime, :endTime, :transactionId, :operation) ON CONFLICT ( fedora_id, transaction_id) DO UPDATE SET parent = EXCLUDED.parent, start_time = EXCLUDED.start_time, end_time = EXCLUDED.end_time, operation = EXCLUDED.operation");
    private static final String DIRECT_INSERT_RECORDS = "INSERT INTO containment (parent, fedora_id, start_time, end_time) VALUES (:parent, :child, :startTime, :endTime)";
    private static final String DIRECT_INSERT_POSTGRESQL = " ON CONFLICT ( fedora_id)DO UPDATE SET parent = EXCLUDED.parent, start_time = EXCLUDED.start_time, end_time = EXCLUDED.end_time";
    private static final String DIRECT_INSERT_MYSQL_MARIA = " ON DUPLICATE KEY UPDATE parent = VALUES(parent), start_time = VALUES(start_time), end_time = VALUES(end_time)";
    private static final String DIRECT_INSERT_H2 = "MERGE INTO containment (parent, fedora_id, start_time, end_time) KEY (fedora_id) VALUES (:parent, :child, :startTime, :endTime)";
    private static final Map<DbPlatform, String> DIRECT_UPSERT_MAPPING = Map.of(DbPlatform.H2, "MERGE INTO containment (parent, fedora_id, start_time, end_time) KEY (fedora_id) VALUES (:parent, :child, :startTime, :endTime)", DbPlatform.MYSQL, "INSERT INTO containment (parent, fedora_id, start_time, end_time) VALUES (:parent, :child, :startTime, :endTime) ON DUPLICATE KEY UPDATE parent = VALUES(parent), start_time = VALUES(start_time), end_time = VALUES(end_time)", DbPlatform.MARIADB, "INSERT INTO containment (parent, fedora_id, start_time, end_time) VALUES (:parent, :child, :startTime, :endTime) ON DUPLICATE KEY UPDATE parent = VALUES(parent), start_time = VALUES(start_time), end_time = VALUES(end_time)", DbPlatform.POSTGRESQL, "INSERT INTO containment (parent, fedora_id, start_time, end_time) VALUES (:parent, :child, :startTime, :endTime) ON CONFLICT ( fedora_id)DO UPDATE SET parent = EXCLUDED.parent, start_time = EXCLUDED.start_time, end_time = EXCLUDED.end_time");
    private static final String DIRECT_PURGE = "DELETE FROM containment WHERE fedora_id = :child";
    private static final String UNDO_INSERT_CHILD_IN_TRANSACTION = "DELETE FROM containment_transactions WHERE parent = :parent AND fedora_id = :child AND transaction_id = :transactionId AND operation = 'add'";
    private static final String UNDO_DELETE_CHILD_IN_TRANSACTION_NO_PARENT = "DELETE FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'delete'";
    private static final String IS_CHILD_ADDED_IN_TRANSACTION = "SELECT TRUE FROM containment_transactions WHERE fedora_id = :child AND parent = :parent AND transaction_id = :transactionId AND operation = 'add'";
    private static final String IS_CHILD_DELETED_IN_TRANSACTION_NO_PARENT = "SELECT TRUE FROM containment_transactions WHERE fedora_id = :child  AND transaction_id = :transactionId AND operation = 'delete'";
    private static final String DELETE_ENTIRE_TRANSACTION = "DELETE FROM containment_transactions WHERE transaction_id = :transactionId";
    private static final String COMMIT_ADD_RECORDS_POSTGRESQL = "INSERT INTO containment ( fedora_id, parent, start_time, end_time) SELECT fedora_id, parent, start_time, end_time FROM containment_transactions WHERE operation = 'add' AND transaction_id = :transactionId ON CONFLICT ( fedora_id ) DO UPDATE SET parent = EXCLUDED.parent, start_time = EXCLUDED.start_time, end_time = EXCLUDED.end_time";
    private static final String COMMIT_ADD_RECORDS_MYSQL_MARIA = "INSERT INTO containment (fedora_id, parent, start_time, end_time) SELECT fedora_id, parent, start_time, end_time FROM containment_transactions WHERE operation = 'add' AND transaction_id = :transactionId ON DUPLICATE KEY UPDATE parent = VALUES(parent), start_time = VALUES(start_time), end_time = VALUES(end_time)";
    private static final String COMMIT_ADD_RECORDS_H2 = "MERGE INTO containment (fedora_id, parent, start_time, end_time) KEY (fedora_id) SELECT fedora_id, parent, start_time, end_time FROM containment_transactions WHERE operation = 'add' AND transaction_id = :transactionId";
    private static final Map<DbPlatform, String> COMMIT_ADD_RECORDS_MAP = Map.of(DbPlatform.H2, "MERGE INTO containment (fedora_id, parent, start_time, end_time) KEY (fedora_id) SELECT fedora_id, parent, start_time, end_time FROM containment_transactions WHERE operation = 'add' AND transaction_id = :transactionId", DbPlatform.MYSQL, "INSERT INTO containment (fedora_id, parent, start_time, end_time) SELECT fedora_id, parent, start_time, end_time FROM containment_transactions WHERE operation = 'add' AND transaction_id = :transactionId ON DUPLICATE KEY UPDATE parent = VALUES(parent), start_time = VALUES(start_time), end_time = VALUES(end_time)", DbPlatform.MARIADB, "INSERT INTO containment (fedora_id, parent, start_time, end_time) SELECT fedora_id, parent, start_time, end_time FROM containment_transactions WHERE operation = 'add' AND transaction_id = :transactionId ON DUPLICATE KEY UPDATE parent = VALUES(parent), start_time = VALUES(start_time), end_time = VALUES(end_time)", DbPlatform.POSTGRESQL, "INSERT INTO containment ( fedora_id, parent, start_time, end_time) SELECT fedora_id, parent, start_time, end_time FROM containment_transactions WHERE operation = 'add' AND transaction_id = :transactionId ON CONFLICT ( fedora_id ) DO UPDATE SET parent = EXCLUDED.parent, start_time = EXCLUDED.start_time, end_time = EXCLUDED.end_time");
    private static final String COMMIT_DELETE_RECORDS_H2 = "UPDATE containment r SET r.end_time = ( SELECT t.end_time FROM containment_transactions t  WHERE t.fedora_id = r.fedora_id AND t.transaction_id = :transactionId AND t.operation = 'delete' AND t.parent = r.parent AND r.end_time IS NULL) WHERE EXISTS (SELECT 1 FROM containment_transactions t WHERE t.fedora_id = r.fedora_id AND t.transaction_id = :transactionId AND t.operation = 'delete' AND t.parent = r.parent AND r.end_time IS NULL)";
    private static final String COMMIT_DELETE_RECORDS_MYSQL = "UPDATE containment r INNER JOIN containment_transactions t ON t.fedora_id = r.fedora_id SET r.end_time = t.end_time WHERE t.parent = r.parent AND t.transaction_id = :transactionId AND t.operation = 'delete' AND r.end_time IS NULL";
    private static final String COMMIT_DELETE_RECORDS_POSTGRES = "UPDATE containment SET end_time = t.end_time FROM containment_transactions t WHERE t.fedora_id = containment.fedora_id AND t.parent = containment.parent AND t.transaction_id = :transactionId AND t.operation = 'delete' AND containment.end_time IS NULL";
    private final Map<DbPlatform, String> COMMIT_DELETE_RECORDS = Map.of(DbPlatform.H2, "UPDATE containment r SET r.end_time = ( SELECT t.end_time FROM containment_transactions t  WHERE t.fedora_id = r.fedora_id AND t.transaction_id = :transactionId AND t.operation = 'delete' AND t.parent = r.parent AND r.end_time IS NULL) WHERE EXISTS (SELECT 1 FROM containment_transactions t WHERE t.fedora_id = r.fedora_id AND t.transaction_id = :transactionId AND t.operation = 'delete' AND t.parent = r.parent AND r.end_time IS NULL)", DbPlatform.MARIADB, "UPDATE containment r INNER JOIN containment_transactions t ON t.fedora_id = r.fedora_id SET r.end_time = t.end_time WHERE t.parent = r.parent AND t.transaction_id = :transactionId AND t.operation = 'delete' AND r.end_time IS NULL", DbPlatform.MYSQL, "UPDATE containment r INNER JOIN containment_transactions t ON t.fedora_id = r.fedora_id SET r.end_time = t.end_time WHERE t.parent = r.parent AND t.transaction_id = :transactionId AND t.operation = 'delete' AND r.end_time IS NULL", DbPlatform.POSTGRESQL, "UPDATE containment SET end_time = t.end_time FROM containment_transactions t WHERE t.fedora_id = containment.fedora_id AND t.parent = containment.parent AND t.transaction_id = :transactionId AND t.operation = 'delete' AND containment.end_time IS NULL");
    private static final String COMMIT_PURGE_RECORDS = "DELETE FROM containment WHERE EXISTS (SELECT 1 FROM containment_transactions t WHERE t.transaction_id = :transactionId AND t.operation = 'purge' AND t.fedora_id = containment.fedora_id AND t.parent = containment.parent)";
    private static final String RESOURCE_EXISTS = "SELECT fedora_id FROM containment WHERE fedora_id = :child AND end_time IS NULL";
    private static final String RESOURCE_EXISTS_IN_TRANSACTION = "SELECT x.fedora_id FROM (SELECT fedora_id FROM containment WHERE fedora_id = :child  AND end_time IS NULL UNION SELECT fedora_id FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'add') x WHERE NOT EXISTS  (SELECT 1 FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation IN ('delete', 'purge'))";
    private static final String RESOURCE_OR_TOMBSTONE_EXISTS = "SELECT fedora_id FROM containment WHERE fedora_id = :child";
    private static final String RESOURCE_OR_TOMBSTONE_EXISTS_IN_TRANSACTION = "SELECT x.fedora_id FROM (SELECT fedora_id FROM containment WHERE fedora_id = :child UNION SELECT fedora_id FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'add') x WHERE NOT EXISTS  (SELECT 1 FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation IN ('delete', 'purge'))";
    private static final String PARENT_EXISTS = "SELECT parent FROM containment WHERE fedora_id = :child AND end_time IS NULL";
    private static final String PARENT_EXISTS_IN_TRANSACTION = "SELECT x.parent FROM (SELECT parent FROM containment WHERE fedora_id = :child AND end_time IS NULL UNION SELECT parent FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'add') x WHERE NOT EXISTS  (SELECT 1 FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'delete')";
    private static final String PARENT_EXISTS_DELETED = "SELECT parent FROM containment WHERE fedora_id = :child AND end_time IS NOT NULL";
    private static final String PARENT_EXISTS_DELETED_IN_TRANSACTION = "SELECT x.parent FROM (SELECT parent FROM containment WHERE fedora_id = :child AND end_time IS NOT NULL UNION SELECT parent FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'delete') x WHERE NOT EXISTS  (SELECT 1 FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'add')";
    private static final String IS_CHILD_ADDED_IN_TRANSACTION_NO_PARENT = "SELECT TRUE FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'add'";
    private static final String UNDO_INSERT_CHILD_IN_TRANSACTION_NO_PARENT = "DELETE FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'add'";
    private static final String TRUNCATE_TABLE = "TRUNCATE TABLE ";
    private static final String SELECT_ID_LIKE = "SELECT fedora_id FROM containment WHERE fedora_id LIKE :resourceId";
    private static final String SELECT_ID_LIKE_IN_TRANSACTION = "SELECT x.fedora_id FROM (SELECT fedora_id FROM containment WHERE fedora_id LIKE :resourceId UNION SELECT fedora_id FROM containment_transactions WHERE fedora_id LIKE :resourceId AND transaction_id = :transactionId AND operation = 'add') x WHERE NOT EXISTS (SELECT 1 FROM containment_transactions WHERE fedora_id LIKE :resourceId AND transaction_id = :transactionId AND operation = 'delete')";
    private static final String SELECT_LAST_UPDATED = "SELECT updated FROM containment WHERE fedora_id = :resourceId";
    private static final String UPDATE_LAST_UPDATED = "UPDATE containment SET updated = :updated WHERE fedora_id = :resourceId";
    private static final String CONDITIONALLY_UPDATE_LAST_UPDATED = "UPDATE containment SET updated = :updated WHERE fedora_id = :resourceId AND (updated IS NULL OR updated < :updated)";
    private static final String SELECT_LAST_UPDATED_IN_TX = "SELECT MAX(x.updated) FROM (SELECT updated as updated FROM containment WHERE fedora_id = :resourceId UNION SELECT start_time as updated FROM containment_transactions WHERE parent = :resourceId AND operation = 'add' AND transaction_id = :transactionId UNION SELECT end_time as updated FROM containment_transactions WHERE parent = :resourceId AND operation = 'delete' AND transaction_id = :transactionId UNION SELECT end_time as updated FROM containment_transactions WHERE parent = :resourceId AND operation = 'add' AND transaction_id = :transactionId) x";
    private static final String GET_UPDATED_RESOURCES = "SELECT DISTINCT parent FROM containment_transactions WHERE transaction_id = :transactionId AND operation in ('add', 'delete')";
    private static final String GET_START_TIME = "SELECT start_time FROM containment WHERE fedora_id = :child";
    private static final String GET_DELETED_RESOURCES = "SELECT fedora_id FROM containment_transactions WHERE transaction_id = :transactionId AND operation = 'delete'";
    private static final String GET_ADDED_RESOURCES = "SELECT fedora_id FROM containment_transactions WHERE transaction_id = :transactionId AND operation = 'add'";
    @Inject
    private FedoraPropsConfig fedoraPropsConfig;
    private Cache<String, String> getContainedByCache;
    private Cache<String, Boolean> resourceExistsCache;

    @PostConstruct
    private void setup() {
        this.jdbcTemplate = this.getNamedParameterJdbcTemplate();
        this.dbPlatform = DbPlatform.fromDataSource((DataSource)this.dataSource);
        this.getContainedByCache = Caffeine.newBuilder().maximumSize(this.fedoraPropsConfig.getContainmentCacheSize()).expireAfterAccess(this.fedoraPropsConfig.getContainmentCacheTimeout(), TimeUnit.MINUTES).build();
        this.resourceExistsCache = Caffeine.newBuilder().maximumSize(this.fedoraPropsConfig.getContainmentCacheSize()).expireAfterAccess(this.fedoraPropsConfig.getContainmentCacheTimeout(), TimeUnit.MINUTES).build();
    }

    private NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return new NamedParameterJdbcTemplate(this.getDataSource());
    }

    void setContainsLimit(int limit) {
        this.containsLimit = limit;
    }

    public Stream<String> getContains(@Nonnull Transaction tx, FedoraId fedoraId) {
        String query;
        String resourceId = fedoraId.isMemento() ? fedoraId.getBaseId() : fedoraId.getFullId();
        Instant asOfTime = fedoraId.isMemento() ? fedoraId.getMementoInstant() : null;
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(PARENT_COLUMN, (Object)resourceId);
        LOGGER.debug("getContains for {} in transaction {} and instant {}", new Object[]{resourceId, tx, asOfTime});
        if (asOfTime == null) {
            if (tx.isOpenLongRunning()) {
                parameterSource.addValue("transactionId", (Object)tx.getId());
                query = SELECT_CHILDREN_IN_TRANSACTION;
            } else {
                query = SELECT_CHILDREN;
            }
        } else {
            parameterSource.addValue("asOfTime", (Object)this.formatInstant(asOfTime));
            query = SELECT_CHILDREN_OF_MEMENTO;
        }
        return StreamSupport.stream(new ContainmentIterator(query, parameterSource), false);
    }

    public Stream<String> getContainsDeleted(@Nonnull Transaction tx, FedoraId fedoraId) {
        String query;
        String resourceId = fedoraId.getFullId();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(PARENT_COLUMN, (Object)resourceId);
        if (tx.isOpenLongRunning()) {
            parameterSource.addValue("transactionId", (Object)tx.getId());
            query = SELECT_DELETED_CHILDREN_IN_TRANSACTION;
        } else {
            query = SELECT_DELETED_CHILDREN;
        }
        LOGGER.debug("getContainsDeleted for {} in transaction {}", (Object)resourceId, (Object)tx);
        return StreamSupport.stream(new ContainmentIterator(query, parameterSource), false);
    }

    public String getContainedBy(@Nonnull Transaction tx, FedoraId resource) {
        String resourceID = resource.getFullId();
        String parentID = tx.isOpenLongRunning() ? (String)this.jdbcTemplate.queryForList(PARENT_EXISTS_IN_TRANSACTION, Map.of("child", resourceID, "transactionId", tx.getId()), String.class).stream().findFirst().orElse(null) : (String)this.getContainedByCache.get((Object)resourceID, key -> this.jdbcTemplate.queryForList(PARENT_EXISTS, Map.of("child", key), String.class).stream().findFirst().orElse(null));
        return parentID;
    }

    public void addContainedBy(@Nonnull Transaction tx, FedoraId parent, FedoraId child) {
        this.addContainedBy(tx, parent, child, Instant.now(), null);
    }

    public void addContainedBy(@Nonnull Transaction tx, FedoraId parent, FedoraId child, Instant startTime, Instant endTime) {
        if (this.childShouldNotBeContained(child)) {
            return;
        }
        tx.doInTx(() -> {
            String parentID = parent.getFullId();
            String childID = child.getFullId();
            if (!tx.isShortLived()) {
                LOGGER.debug("Adding: parent: {}, child: {}, in txn: {}, start time {}, end time {}", new Object[]{parentID, childID, tx.getId(), this.formatInstant(startTime), this.formatInstant(endTime)});
                this.doUpsert(tx, parentID, childID, startTime, endTime, "add");
            } else {
                LOGGER.debug("Adding: parent: {}, child: {}, start time {}, end time {}", new Object[]{parentID, childID, this.formatInstant(startTime), this.formatInstant(endTime)});
                this.doDirectUpsert(parentID, childID, startTime, endTime);
            }
        });
    }

    private boolean childShouldNotBeContained(FedoraId child) {
        return child.isAcl();
    }

    public void removeContainedBy(@Nonnull Transaction tx, FedoraId parent, FedoraId child) {
        tx.doInTx(() -> {
            String parentID = parent.getFullId();
            String childID = child.getFullId();
            if (!tx.isShortLived()) {
                boolean addedInTxn;
                MapSqlParameterSource parameterSource = new MapSqlParameterSource();
                parameterSource.addValue(PARENT_COLUMN, (Object)parentID);
                parameterSource.addValue("child", (Object)childID);
                parameterSource.addValue("transactionId", (Object)tx.getId());
                boolean bl = addedInTxn = !this.jdbcTemplate.queryForList(IS_CHILD_ADDED_IN_TRANSACTION, (SqlParameterSource)parameterSource).isEmpty();
                if (addedInTxn) {
                    this.jdbcTemplate.update(UNDO_INSERT_CHILD_IN_TRANSACTION, (SqlParameterSource)parameterSource);
                } else {
                    this.doUpsert(tx, parentID, childID, null, Instant.now(), "delete");
                }
            } else {
                this.doDirectUpsert(parentID, childID, null, Instant.now());
                this.getContainedByCache.invalidate((Object)childID);
            }
        });
    }

    public void removeResource(@Nonnull Transaction tx, FedoraId resource) {
        tx.doInTx(() -> {
            String resourceID = resource.getFullId();
            if (!tx.isShortLived()) {
                boolean addedInTxn;
                MapSqlParameterSource parameterSource = new MapSqlParameterSource();
                parameterSource.addValue("child", (Object)resourceID);
                parameterSource.addValue("transactionId", (Object)tx.getId());
                boolean bl = addedInTxn = !this.jdbcTemplate.queryForList(IS_CHILD_ADDED_IN_TRANSACTION_NO_PARENT, (SqlParameterSource)parameterSource).isEmpty();
                if (addedInTxn) {
                    this.jdbcTemplate.update(UNDO_INSERT_CHILD_IN_TRANSACTION_NO_PARENT, (SqlParameterSource)parameterSource);
                } else {
                    String parent = this.getContainedBy(tx, resource);
                    if (parent != null) {
                        LOGGER.debug("Marking containment relationship between parent ({}) and child ({}) deleted", (Object)parent, (Object)resourceID);
                        this.doUpsert(tx, parent, resourceID, null, Instant.now(), "delete");
                    }
                }
            } else {
                String parent = this.getContainedBy(tx, resource);
                if (parent != null) {
                    LOGGER.debug("Marking containment relationship between parent ({}) and child ({}) deleted", (Object)parent, (Object)resourceID);
                    this.doDirectUpsert(parent, resourceID, null, Instant.now());
                    this.getContainedByCache.invalidate((Object)resourceID);
                }
            }
        });
    }

    public void purgeResource(@Nonnull Transaction tx, FedoraId resource) {
        tx.doInTx(() -> {
            String resourceID = resource.getFullId();
            String parent = this.getContainedByDeleted(tx, resource);
            if (parent != null) {
                LOGGER.debug("Removing containment relationship between parent ({}) and child ({})", (Object)parent, (Object)resourceID);
                if (!tx.isShortLived()) {
                    this.doUpsert(tx, parent, resourceID, null, null, "purge");
                } else {
                    MapSqlParameterSource parameterSource = new MapSqlParameterSource();
                    parameterSource.addValue("child", (Object)resourceID);
                    this.jdbcTemplate.update(DIRECT_PURGE, (SqlParameterSource)parameterSource);
                }
            }
        });
    }

    private void doUpsert(Transaction tx, String parentId, String resourceId, Instant startTime, Instant endTime, String operation) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("child", (Object)resourceId);
        parameterSource.addValue("transactionId", (Object)tx.getId());
        parameterSource.addValue(PARENT_COLUMN, (Object)parentId);
        if (startTime == null) {
            parameterSource.addValue("startTime", (Object)this.formatInstant(this.getCurrentStartTime(resourceId)));
        } else {
            parameterSource.addValue("startTime", (Object)this.formatInstant(startTime));
        }
        parameterSource.addValue("endTime", (Object)this.formatInstant(endTime));
        parameterSource.addValue(OPERATION_COLUMN, (Object)operation);
        this.jdbcTemplate.update(UPSERT_MAPPING.get(this.dbPlatform), (SqlParameterSource)parameterSource);
    }

    private void doDirectUpsert(String parentId, String resourceId, Instant startTime, Instant endTime) {
        String query;
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("child", (Object)resourceId);
        parameterSource.addValue(PARENT_COLUMN, (Object)parentId);
        parameterSource.addValue("endTime", (Object)this.formatInstant(endTime));
        if (startTime == null) {
            query = DIRECT_UPDATE_END_TIME;
        } else {
            parameterSource.addValue("startTime", (Object)this.formatInstant(startTime));
            query = DIRECT_UPSERT_MAPPING.get(this.dbPlatform);
        }
        this.jdbcTemplate.update(query, (SqlParameterSource)parameterSource);
        this.updateParentTimestamp(parentId, startTime, endTime);
        this.resourceExistsCache.invalidate((Object)resourceId);
    }

    private void updateParentTimestamp(String parentId, Instant startTime, Instant endTime) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        Instant updated = endTime == null ? startTime : endTime;
        parameterSource.addValue("resourceId", (Object)parentId);
        parameterSource.addValue(UPDATED_COLUMN, (Object)this.formatInstant(updated));
        this.jdbcTemplate.update(CONDITIONALLY_UPDATE_LAST_UPDATED, (SqlParameterSource)parameterSource);
    }

    private String getContainedByDeleted(Transaction tx, FedoraId resource) {
        List parentID;
        String resourceID = resource.getFullId();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("child", (Object)resourceID);
        if (tx.isOpenLongRunning()) {
            parameterSource.addValue("transactionId", (Object)tx.getId());
            parentID = this.jdbcTemplate.queryForList(PARENT_EXISTS_DELETED_IN_TRANSACTION, (SqlParameterSource)parameterSource, String.class);
        } else {
            parentID = this.jdbcTemplate.queryForList(PARENT_EXISTS_DELETED, (SqlParameterSource)parameterSource, String.class);
        }
        return parentID.stream().findFirst().orElse(null);
    }

    public void commitTransaction(Transaction tx) {
        if (!tx.isShortLived()) {
            tx.ensureCommitting();
            try {
                MapSqlParameterSource parameterSource = new MapSqlParameterSource();
                parameterSource.addValue("transactionId", (Object)tx.getId());
                List changedParents = this.jdbcTemplate.queryForList(GET_UPDATED_RESOURCES, (SqlParameterSource)parameterSource, String.class);
                List removedResources = this.jdbcTemplate.queryForList(GET_DELETED_RESOURCES, (SqlParameterSource)parameterSource, String.class);
                List addedResources = this.jdbcTemplate.queryForList(GET_ADDED_RESOURCES, (SqlParameterSource)parameterSource, String.class);
                int purged = this.jdbcTemplate.update(COMMIT_PURGE_RECORDS, (SqlParameterSource)parameterSource);
                int deleted = this.jdbcTemplate.update(this.COMMIT_DELETE_RECORDS.get(this.dbPlatform), (SqlParameterSource)parameterSource);
                int added = this.jdbcTemplate.update(COMMIT_ADD_RECORDS_MAP.get(this.dbPlatform), (SqlParameterSource)parameterSource);
                for (String parent : changedParents) {
                    Timestamp updated = (Timestamp)this.jdbcTemplate.queryForObject(SELECT_LAST_UPDATED_IN_TX, Map.of("resourceId", parent, "transactionId", tx.getId()), Timestamp.class);
                    if (updated == null) continue;
                    this.jdbcTemplate.update(UPDATE_LAST_UPDATED, Map.of("resourceId", parent, UPDATED_COLUMN, updated));
                }
                this.jdbcTemplate.update(DELETE_ENTIRE_TRANSACTION, (SqlParameterSource)parameterSource);
                this.getContainedByCache.invalidateAll((Iterable)removedResources);
                removedResources.addAll(addedResources);
                this.resourceExistsCache.invalidateAll((Iterable)removedResources);
                LOGGER.debug("Commit of tx {} complete with {} adds, {} deletes and {} purges", new Object[]{tx.getId(), added, deleted, purged});
            }
            catch (Exception e) {
                LOGGER.warn("Unable to commit containment index transaction {}: {}", (Object)tx, (Object)e.getMessage());
                throw new RepositoryRuntimeException("Unable to commit containment index transaction", (Throwable)e);
            }
        }
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void rollbackTransaction(Transaction tx) {
        if (!tx.isShortLived()) {
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("transactionId", (Object)tx.getId());
            this.jdbcTemplate.update(DELETE_ENTIRE_TRANSACTION, (SqlParameterSource)parameterSource);
        }
    }

    public void clearAllTransactions() {
        this.jdbcTemplate.update("TRUNCATE TABLE containment_transactions", Collections.emptyMap());
    }

    public boolean resourceExists(@Nonnull Transaction tx, FedoraId fedoraId, boolean includeDeleted) {
        String resourceId = fedoraId.getBaseId();
        LOGGER.debug("Checking if {} exists in transaction {}", (Object)resourceId, (Object)tx);
        if (fedoraId.isRepositoryRoot()) {
            return true;
        }
        if (tx.isOpenLongRunning()) {
            String queryToUse = includeDeleted ? RESOURCE_OR_TOMBSTONE_EXISTS_IN_TRANSACTION : RESOURCE_EXISTS_IN_TRANSACTION;
            return !this.jdbcTemplate.queryForList(queryToUse, Map.of("child", resourceId, "transactionId", tx.getId()), String.class).isEmpty();
        }
        if (includeDeleted) {
            Boolean exists = (Boolean)this.resourceExistsCache.getIfPresent((Object)resourceId);
            if (exists != null && exists.booleanValue()) {
                return true;
            }
            return !this.jdbcTemplate.queryForList(RESOURCE_OR_TOMBSTONE_EXISTS, Map.of("child", resourceId), String.class).isEmpty();
        }
        return (Boolean)this.resourceExistsCache.get((Object)resourceId, key -> !this.jdbcTemplate.queryForList(RESOURCE_EXISTS, Map.of("child", resourceId), String.class).isEmpty());
    }

    public FedoraId getContainerIdByPath(Transaction tx, FedoraId fedoraId, boolean checkDeleted) {
        if (fedoraId.isRepositoryRoot()) {
            return fedoraId;
        }
        String parent = this.getContainedBy(tx, fedoraId);
        if (parent != null) {
            return FedoraId.create((String[])new String[]{parent});
        }
        String fullId = fedoraId.getFullId();
        while (fullId.contains("/")) {
            fullId = fedoraId.getResourceId().substring(0, fullId.lastIndexOf("/"));
            if (fullId.equals("info:fedora")) {
                return FedoraId.getRepositoryRootId();
            }
            FedoraId testID = FedoraId.create((String[])new String[]{fullId});
            if (!this.resourceExists(tx, testID, checkDeleted)) continue;
            return testID;
        }
        return FedoraId.getRepositoryRootId();
    }

    public void reset() {
        try {
            this.jdbcTemplate.update("TRUNCATE TABLE containment", Collections.emptyMap());
            this.jdbcTemplate.update("TRUNCATE TABLE containment_transactions", Collections.emptyMap());
            this.getContainedByCache.invalidateAll();
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException("Failed to truncate containment tables", (Throwable)e);
        }
    }

    public boolean hasResourcesStartingWith(Transaction tx, FedoraId fedoraId) {
        boolean matchingIds;
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("resourceId", (Object)(fedoraId.getFullId() + "/%"));
        if (tx.isOpenLongRunning()) {
            parameterSource.addValue("transactionId", (Object)tx.getId());
            matchingIds = !this.jdbcTemplate.queryForList(SELECT_ID_LIKE_IN_TRANSACTION, (SqlParameterSource)parameterSource, String.class).isEmpty();
        } else {
            matchingIds = !this.jdbcTemplate.queryForList(SELECT_ID_LIKE, (SqlParameterSource)parameterSource, String.class).isEmpty();
        }
        return matchingIds;
    }

    public Instant containmentLastUpdated(Transaction tx, FedoraId fedoraId) {
        String queryToUse;
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("resourceId", (Object)fedoraId.getFullId());
        if (tx.isOpenLongRunning()) {
            parameterSource.addValue("transactionId", (Object)tx.getId());
            queryToUse = SELECT_LAST_UPDATED_IN_TX;
        } else {
            queryToUse = SELECT_LAST_UPDATED;
        }
        try {
            return this.fromTimestamp((Timestamp)this.jdbcTemplate.queryForObject(queryToUse, (SqlParameterSource)parameterSource, Timestamp.class));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private Instant getCurrentStartTime(String resourceId) {
        return this.fromTimestamp((Timestamp)this.jdbcTemplate.queryForObject(GET_START_TIME, Map.of("child", resourceId), Timestamp.class));
    }

    private Instant fromTimestamp(Timestamp timestamp) {
        if (timestamp != null) {
            return timestamp.toInstant();
        }
        return null;
    }

    private Timestamp formatInstant(Instant instant) {
        if (instant == null) {
            return null;
        }
        return Timestamp.from(instant.truncatedTo(ChronoUnit.SECONDS));
    }

    private class ContainmentIterator
    extends Spliterators.AbstractSpliterator<String> {
        final Queue<String> children;
        int numOffsets;
        final String queryToUse;
        final MapSqlParameterSource parameterSource;

        public ContainmentIterator(String query, MapSqlParameterSource parameters) {
            super(Long.MAX_VALUE, 16);
            this.children = new ConcurrentLinkedQueue<String>();
            this.numOffsets = 0;
            this.queryToUse = query;
            this.parameterSource = parameters;
            this.parameterSource.addValue("containsLimit", (Object)ContainmentIndexImpl.this.containsLimit);
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> action) {
            try {
                action.accept(this.children.remove());
            }
            catch (NoSuchElementException e) {
                this.parameterSource.addValue("offSet", (Object)(this.numOffsets * ContainmentIndexImpl.this.containsLimit));
                ++this.numOffsets;
                this.children.addAll(ContainmentIndexImpl.this.jdbcTemplate.queryForList(this.queryToUse, (SqlParameterSource)this.parameterSource, String.class));
                if (this.children.size() == 0) {
                    return false;
                }
                action.accept(this.children.remove());
            }
            return true;
        }
    }
}

