/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.lock;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.fcrepo.kernel.api.exception.ConcurrentUpdateException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.lock.ResourceLock;
import org.fcrepo.kernel.api.lock.ResourceLockManager;
import org.fcrepo.kernel.api.lock.ResourceLockType;
import org.fcrepo.kernel.impl.lock.ResourceLockImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InMemoryResourceLockManager
implements ResourceLockManager {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryResourceLockManager.class);
    private final Map<String, Set<ResourceLock>> transactionLocks = new ConcurrentHashMap<String, Set<ResourceLock>>();
    private final Map<FedoraId, Set<ResourceLock>> resourceLocks = new ConcurrentHashMap<FedoraId, Set<ResourceLock>>();
    private final Map<String, Object> internalResourceLocks = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build().asMap();

    public void acquireExclusive(String txId, FedoraId resourceId) {
        this.acquireInternal(txId, resourceId, ResourceLockType.EXCLUSIVE);
    }

    public void acquireNonExclusive(String txId, FedoraId resourceId) {
        this.acquireInternal(txId, resourceId, ResourceLockType.NONEXCLUSIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireInternal(String txId, FedoraId resourceId, ResourceLockType lockType) {
        ResourceLockImpl resourceLock = new ResourceLockImpl(lockType, txId, resourceId);
        if (this.transactionHoldsAdequateLock(resourceLock)) {
            return;
        }
        Object object = this.acquireInternalLock(resourceId);
        synchronized (object) {
            if (this.transactionHoldsAdequateLock(resourceLock)) {
                return;
            }
            Set<ResourceLock> locks = this.resourceLocks.get(resourceId);
            if (locks != null) {
                for (ResourceLock lock : locks) {
                    if ((lockType != ResourceLockType.EXCLUSIVE || lock.getTransactionId().equals(txId)) && !lock.hasLockType(ResourceLockType.EXCLUSIVE)) continue;
                    throw new ConcurrentUpdateException(resourceId.getResourceId(), txId, lock.getTransactionId());
                }
            }
            LOG.debug("Transaction {} acquiring lock on {}", (Object)txId, (Object)resourceId.getResourceId());
            this.resourceLocks.computeIfAbsent(resourceId, key -> new HashSet()).add(resourceLock);
            this.transactionLocks.computeIfAbsent(txId, key -> Sets.newConcurrentHashSet()).add(resourceLock);
        }
    }

    public void releaseAll(String txId) {
        Set<ResourceLock> txLocks = this.transactionLocks.remove(txId);
        if (txLocks != null) {
            txLocks.forEach(lock -> {
                LOG.debug("Transaction {} releasing lock on {}", (Object)txId, lock);
                Object object = this.acquireInternalLock(lock.getResourceId());
                synchronized (object) {
                    Set<ResourceLock> locks = this.resourceLocks.get(lock.getResourceId());
                    locks.remove(lock);
                    if (locks.isEmpty()) {
                        this.resourceLocks.remove(lock.getResourceId());
                    }
                }
            });
        }
    }

    private Object acquireInternalLock(FedoraId resourceId) {
        return this.internalResourceLocks.computeIfAbsent(resourceId.getResourceId(), key -> new Object());
    }

    private boolean transactionHoldsAdequateLock(ResourceLock requested) {
        Set<ResourceLock> locks = this.transactionLocks.get(requested.getTransactionId());
        if (locks == null) {
            return false;
        }
        Optional<ResourceLock> held = locks.stream().filter(l -> Objects.equals(requested, l)).findFirst();
        return held.map(l -> l.isAdequate(requested.getLockType())).orElse(false);
    }
}

