/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.lock;

import java.util.Objects;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.lock.ResourceLock;
import org.fcrepo.kernel.api.lock.ResourceLockType;

public class ResourceLockImpl
implements ResourceLock {
    private final String transactionId;
    private final ResourceLockType resourceLockType;
    private final FedoraId resourceId;

    ResourceLockImpl(ResourceLockType resourceLock, String txId, FedoraId id) {
        this.resourceLockType = resourceLock;
        this.transactionId = txId;
        this.resourceId = id;
    }

    ResourceLockImpl(String lockType, String txId, FedoraId resourceId) {
        this(ResourceLockType.fromString((String)lockType), txId, resourceId);
    }

    public FedoraId getResourceId() {
        return this.resourceId;
    }

    public boolean hasResource(FedoraId resourceId) {
        return this.resourceId.equals((Object)resourceId);
    }

    public ResourceLockType getLockType() {
        return this.resourceLockType;
    }

    public boolean hasLockType(ResourceLockType lockType) {
        return this.resourceLockType.equals((Object)lockType);
    }

    public boolean isAdequate(ResourceLockType lockType) {
        return this.resourceLockType == ResourceLockType.EXCLUSIVE || lockType == ResourceLockType.NONEXCLUSIVE;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String toString() {
        return String.format("type: %s, txId: %s, resource: %s", this.resourceLockType, this.transactionId, this.resourceId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceLockImpl that = (ResourceLockImpl)o;
        return this.transactionId.equals(that.transactionId) && this.resourceId.equals((Object)that.resourceId);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.resourceId);
    }
}

