/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.models;

import java.net.URI;
import java.util.List;
import java.util.stream.Stream;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.cache.UserTypesCache;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.Container;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.impl.models.FedoraResourceImpl;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;

public class ContainerImpl
extends FedoraResourceImpl
implements Container {
    private static final URI RDF_SOURCE_URI = URI.create(RdfLexicon.RDF_SOURCE.toString());
    private static final URI CONTAINER_URI = URI.create(RdfLexicon.CONTAINER.toString());
    private static final URI FEDORA_CONTAINER_URI = URI.create(RdfLexicon.FEDORA_CONTAINER.toString());

    public ContainerImpl(FedoraId fedoraID, Transaction transaction, PersistentStorageSessionManager pSessionManager, ResourceFactory resourceFactory, UserTypesCache userTypesCache) {
        super(fedoraID, transaction, pSessionManager, resourceFactory, userTypesCache);
    }

    @Override
    public FedoraResource getDescribedResource() {
        return this;
    }

    @Override
    public List<URI> getSystemTypes(boolean forRdf) {
        List<URI> types = this.resolveSystemTypes(forRdf);
        if (types == null) {
            types = super.getSystemTypes(forRdf);
            types.add(RDF_SOURCE_URI);
            types.add(CONTAINER_URI);
            types.add(FEDORA_CONTAINER_URI);
        }
        return types;
    }

    @Override
    public Stream<FedoraResource> getChildren(Boolean recursive) {
        return this.resourceFactory.getChildren(this.transaction, this.fedoraId);
    }
}

