/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.models;

import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.vocabulary.RDF;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.cache.UserTypesCache;
import org.fcrepo.kernel.api.exception.ItemNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundRuntimeException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.models.TimeMap;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.impl.models.TimeMapImpl;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentItemNotFoundException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;

public class FedoraResourceImpl
implements FedoraResource {
    private static final URI RESOURCE_URI = URI.create(RdfLexicon.RESOURCE.toString());
    private static final URI FEDORA_RESOURCE_URI = URI.create(RdfLexicon.FEDORA_RESOURCE.getURI());
    private static final URI ARCHIVAL_GROUP_URI = URI.create(RdfLexicon.ARCHIVAL_GROUP.getURI());
    private static final URI MEMENTO_URI = URI.create("http://mementoweb.org/ns#Memento");
    private static final URI VERSIONED_RESOURCE_URI = URI.create(RdfLexicon.VERSIONED_RESOURCE.getURI());
    private static final URI VERSIONING_TIMEGATE_URI = URI.create("http://mementoweb.org/ns#TimeGate");
    private static final URI REPOSITORY_ROOT_URI = URI.create(RdfLexicon.REPOSITORY_ROOT.getURI());
    private final PersistentStorageSessionManager pSessionManager;
    protected final ResourceFactory resourceFactory;
    private final UserTypesCache userTypesCache;
    protected final FedoraId fedoraId;
    private FedoraId parentId;
    private FedoraId archivalGroupId;
    private List<URI> types;
    private List<URI> systemTypes;
    private List<URI> systemTypesForRdf;
    private List<URI> userTypes;
    private Instant lastModifiedDate;
    private String lastModifiedBy;
    private Instant createdDate;
    private String createdBy;
    private Instant mementoDatetime;
    private String stateToken;
    private String etag;
    private boolean isMemento;
    private String interactionModel;
    protected final Transaction transaction;
    private boolean isArchivalGroup;
    private Path storageRelativePath;

    protected FedoraResourceImpl(FedoraId fedoraId, Transaction transaction, PersistentStorageSessionManager pSessionManager, ResourceFactory resourceFactory, UserTypesCache userTypesCache) {
        this.fedoraId = fedoraId;
        this.transaction = transaction;
        this.pSessionManager = pSessionManager;
        this.resourceFactory = resourceFactory;
        this.userTypesCache = userTypesCache;
    }

    public String getId() {
        return this.fedoraId.getResourceId();
    }

    public Stream<FedoraResource> getChildren(Boolean recursive) {
        return Stream.empty();
    }

    public FedoraResource getContainer() {
        return this.resourceFactory.getContainer(this.transaction, this.fedoraId);
    }

    public FedoraResource getOriginalResource() {
        if (this.isMemento()) {
            try {
                FedoraId fedoraId = FedoraId.create((String[])new String[]{this.getFedoraId().getResourceId()});
                return this.getFedoraResource(fedoraId);
            }
            catch (PathNotFoundException e) {
                throw new PathNotFoundRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    private FedoraResource getFedoraResource(FedoraId fedoraId) throws PathNotFoundException {
        return this.resourceFactory.getResource(this.transaction, fedoraId);
    }

    public TimeMap getTimeMap() {
        return new TimeMapImpl(this.getOriginalResource(), this.transaction, this.pSessionManager, this.resourceFactory);
    }

    public Instant getMementoDatetime() {
        return this.mementoDatetime;
    }

    public boolean isMemento() {
        return this.isMemento;
    }

    public boolean isAcl() {
        return false;
    }

    public FedoraResource findMementoByDatetime(Instant mementoDatetime) {
        FedoraResource match = null;
        long matchDiff = 0L;
        Iterator it = this.getTimeMap().getChildren().filter(FedoraResource::isMemento).iterator();
        while (it.hasNext()) {
            FedoraResource current = (FedoraResource)it.next();
            long diff = Duration.between(current.getMementoDatetime(), mementoDatetime).toSeconds();
            if (match != null && (matchDiff >= 0L || diff < matchDiff) && (diff < 0L || diff > matchDiff)) continue;
            match = current;
            matchDiff = diff;
        }
        return match;
    }

    public FedoraResource getAcl() {
        if (this.isAcl()) {
            return this;
        }
        try {
            FedoraId aclId = this.fedoraId.asAcl();
            return this.getFedoraResource(aclId);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public boolean hasProperty(String relPath) {
        return false;
    }

    public Instant getCreatedDate() {
        return this.createdDate;
    }

    public Instant getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public boolean hasType(String type) {
        return this.getTypes().contains(URI.create(type));
    }

    public List<URI> getTypes() {
        if (this.types == null) {
            this.types = new ArrayList<URI>();
            this.types.addAll(this.getSystemTypes(false));
            this.types.addAll(this.getUserTypes());
        }
        return this.types;
    }

    public List<URI> getSystemTypes(boolean forRdf) {
        List<URI> types = this.resolveSystemTypes(forRdf);
        if (types == null) {
            types = new ArrayList<URI>();
            types.add(URI.create(this.interactionModel));
            types.add(RESOURCE_URI);
            types.add(FEDORA_RESOURCE_URI);
            if (this.getFedoraId().isRepositoryRoot()) {
                types.add(REPOSITORY_ROOT_URI);
            }
            if (!forRdf) {
                if (this.isArchivalGroup) {
                    types.add(ARCHIVAL_GROUP_URI);
                }
                if (this.isMemento) {
                    types.add(MEMENTO_URI);
                } else {
                    types.add(VERSIONED_RESOURCE_URI);
                    types.add(VERSIONING_TIMEGATE_URI);
                }
            }
            if (forRdf) {
                this.systemTypesForRdf = types;
            } else {
                this.systemTypes = types;
            }
        }
        return types;
    }

    public List<URI> getUserTypes() {
        if (this.userTypes == null) {
            try {
                FedoraResource description = this.getDescription();
                FedoraId descId = description.getFedoraId().asResourceId();
                if (description.getMementoDatetime() == null && this.userTypesCache != null) {
                    this.userTypes = this.userTypesCache.getUserTypes(descId, this.getSession().getId(), () -> this.getSession().getTriples(descId, null));
                } else {
                    RdfStream triples = this.getSession().getTriples(descId, description.getMementoDatetime());
                    this.userTypes = triples.filter(t -> t.predicateMatches(RDF.type.asNode())).map(Triple::getObject).map(t -> URI.create(t.toString())).collect(Collectors.toList());
                }
            }
            catch (PersistentItemNotFoundException e) {
                ResourceHeaders headers = this.getSession().getHeaders(this.getFedoraId().asResourceId(), this.getMementoDatetime());
                if (headers.isDeleted()) {
                    this.userTypes = Collections.emptyList();
                }
                throw new ItemNotFoundException("Unable to retrieve triples for " + this.getId(), (Throwable)e);
            }
            catch (PersistentStorageException e) {
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        return this.userTypes;
    }

    public RdfStream getTriples() {
        try {
            Node subject = NodeFactory.createURI((String)this.getId());
            RdfStream triples = this.getSession().getTriples(this.getFedoraId().asResourceId(), this.getMementoDatetime());
            return new DefaultRdfStream(subject, (Stream)triples);
        }
        catch (PersistentItemNotFoundException e) {
            throw new ItemNotFoundException("Unable to retrieve triples for " + this.getId(), (Throwable)e);
        }
        catch (PersistentStorageException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public String getEtagValue() {
        return this.etag;
    }

    public String getStateToken() {
        return this.stateToken;
    }

    public boolean isOriginalResource() {
        return !this.isMemento();
    }

    public FedoraResource getDescription() {
        return this;
    }

    public FedoraResource getDescribedResource() {
        return this;
    }

    protected PersistentStorageSession getSession() {
        if (this.transaction.isOpen()) {
            return this.pSessionManager.getSession(this.transaction);
        }
        return this.pSessionManager.getReadOnlySession();
    }

    public FedoraResource getParent() throws PathNotFoundException {
        return this.resourceFactory.getResource(this.transaction, this.parentId);
    }

    public FedoraId getParentId() {
        return this.parentId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public FedoraId getFedoraId() {
        return this.fedoraId;
    }

    public String getInteractionModel() {
        return this.interactionModel;
    }

    public Path getStorageRelativePath() {
        return this.storageRelativePath;
    }

    protected void setParentId(FedoraId parentId) {
        this.parentId = parentId;
    }

    protected void setTypes(List<URI> types) {
        this.types = types;
    }

    protected void setLastModifiedDate(Instant lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    protected void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    protected void setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
    }

    protected void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    protected void setMementoDatetime(Instant mementoDatetime) {
        this.mementoDatetime = mementoDatetime;
    }

    protected void setStateToken(String stateToken) {
        this.stateToken = stateToken;
    }

    protected void setEtag(String etag) {
        this.etag = etag;
    }

    public void setIsMemento(boolean isMemento) {
        this.isMemento = isMemento;
    }

    public void setIsArchivalGroup(boolean isArchivalGroup) {
        this.isArchivalGroup = isArchivalGroup;
    }

    public void setInteractionModel(String interactionModel) {
        this.interactionModel = interactionModel;
    }

    protected List<URI> resolveSystemTypes(boolean forRdf) {
        return forRdf ? this.systemTypesForRdf : this.systemTypes;
    }

    public void setArchivalGroupId(FedoraId archivalGroupId) {
        this.archivalGroupId = archivalGroupId;
    }

    public Optional<FedoraId> getArchivalGroupId() {
        return Optional.ofNullable(this.archivalGroupId);
    }

    protected void setStorageRelativePath(String storageRelativePath) {
        if (storageRelativePath != null) {
            Path tempPath = Path.of(storageRelativePath, new String[0]);
            this.storageRelativePath = tempPath.subpath(0, tempPath.getNameCount() - 4);
        }
    }
}

