/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.observer.Event;
import org.fcrepo.kernel.api.observer.EventType;

public class EventImpl
implements Event {
    private final String eventId = "urn:uuid:" + UUID.randomUUID().toString();
    private final FedoraId fedoraId;
    private final Set<EventType> types;
    private final Set<String> resourceTypes;
    private final String userID;
    private final URI userURI;
    private final String userAgent;
    private final String baseUrl;
    private final Instant date;

    public EventImpl(FedoraId fedoraId, Set<EventType> types, Set<String> resourceTypes, String userID, URI userURI, String userAgent, String baseUrl, Instant date) {
        this.fedoraId = (FedoraId)Preconditions.checkNotNull((Object)fedoraId, (Object)"fedoraId cannot be null");
        this.types = Set.copyOf((Collection)Preconditions.checkNotNull(types, (Object)"types cannot be null"));
        this.resourceTypes = Set.copyOf((Collection)Preconditions.checkNotNull(resourceTypes, (Object)"resourceTypes cannot be null"));
        this.userID = userID;
        this.userURI = userURI;
        this.userAgent = userAgent;
        Preconditions.checkNotNull((Object)baseUrl, (Object)"baseUrl cannot be null");
        this.baseUrl = baseUrl.replaceAll("/+$", "");
        this.date = (Instant)Preconditions.checkNotNull((Object)date, (Object)"date cannot be null");
    }

    public FedoraId getFedoraId() {
        return this.fedoraId;
    }

    public Set<EventType> getTypes() {
        return this.types;
    }

    public Set<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public String getPath() {
        return this.fedoraId.getFullIdPath();
    }

    public String getUserID() {
        return this.userID;
    }

    public Instant getDate() {
        return this.date;
    }

    public String getEventID() {
        return this.eventId;
    }

    public URI getUserURI() {
        return this.userURI;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String toString() {
        return "EventImpl{eventId='" + this.eventId + "', fedoraId=" + String.valueOf(this.fedoraId) + ", types=" + String.valueOf(this.types) + ", resourceTypes=" + String.valueOf(this.resourceTypes) + ", userID='" + this.userID + "', userURI=" + String.valueOf(this.userURI) + ", userAgent=" + this.userAgent + ", baseUrl=" + this.baseUrl + ", date=" + String.valueOf(this.date) + "}";
    }
}

