/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.operations;

import java.time.Instant;
import java.util.Calendar;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.fcrepo.config.ServerManagedPropsMode;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.RelaxableResourceOperationBuilder;
import org.fcrepo.kernel.api.utils.RelaxedPropertiesHelper;
import org.fcrepo.kernel.impl.operations.AbstractResourceOperationBuilder;

public abstract class AbstractRelaxableResourceOperationBuilder
extends AbstractResourceOperationBuilder
implements RelaxableResourceOperationBuilder {
    protected String lastModifiedBy;
    protected String createdBy;
    protected Instant lastModifiedDate;
    protected Instant createdDate;
    protected ServerManagedPropsMode serverManagedPropsMode;

    protected AbstractRelaxableResourceOperationBuilder(Transaction transaction, FedoraId rescId, ServerManagedPropsMode serverManagedPropsMode) {
        super(transaction, rescId);
        this.serverManagedPropsMode = serverManagedPropsMode;
    }

    public RelaxableResourceOperationBuilder relaxedProperties(Model model) {
        if (model != null && this.serverManagedPropsMode == ServerManagedPropsMode.RELAXED) {
            String modifiedBy;
            Calendar modifiedDate;
            String createdByVal;
            Resource resc = model.getResource(this.rescId.asResourceId().getFullDescribedId());
            Calendar createdDateVal = RelaxedPropertiesHelper.getCreatedDate((Resource)resc);
            if (createdDateVal != null) {
                this.createdDate = createdDateVal.toInstant();
            }
            if ((createdByVal = RelaxedPropertiesHelper.getCreatedBy((Resource)resc)) != null) {
                this.createdBy = createdByVal;
            }
            if ((modifiedDate = RelaxedPropertiesHelper.getModifiedDate((Resource)resc)) != null) {
                this.lastModifiedDate = modifiedDate.toInstant();
            }
            if ((modifiedBy = RelaxedPropertiesHelper.getModifiedBy((Resource)resc)) != null) {
                this.lastModifiedBy = modifiedBy;
            }
        }
        return this;
    }
}

