/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.NonRdfSourceDescription;
import org.fcrepo.kernel.api.observer.EventAccumulator;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.services.ReferenceService;
import org.fcrepo.kernel.impl.operations.ReferenceOperation;
import org.fcrepo.kernel.impl.operations.ReferenceOperationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="referenceServiceImpl")
public class ReferenceServiceImpl
implements ReferenceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceServiceImpl.class);
    @Inject
    private DataSource dataSource;
    @Inject
    private EventAccumulator eventAccumulator;
    @Autowired
    @Qualifier(value="containmentIndex")
    private ContainmentIndex containmentIndex;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private static final String TABLE_NAME = "reference";
    private static final String TRANSACTION_TABLE = "reference_transaction_operations";
    private static final String RESOURCE_COLUMN = "fedora_id";
    private static final String SUBJECT_COLUMN = "subject_id";
    private static final String PROPERTY_COLUMN = "property";
    private static final String TARGET_COLUMN = "target_id";
    private static final String OPERATION_COLUMN = "operation";
    private static final String TRANSACTION_COLUMN = "transaction_id";
    private static final String SELECT_INBOUND = "SELECT subject_id, property FROM reference WHERE target_id = :targetId";
    private static final String SELECT_INBOUND_IN_TRANSACTION = "SELECT x.subject_id, x.property FROM (SELECT subject_id, property FROM reference WHERE target_id = :targetId UNION SELECT subject_id, property FROM reference_transaction_operations WHERE target_id = :targetId AND transaction_id = :transactionId AND operation = 'add') x WHERE NOT EXISTS (SELECT 1 FROM reference_transaction_operations WHERE target_id = :targetId AND operation = 'delete')";
    private static final String SELECT_OUTBOUND = "SELECT subject_id, target_id, property FROM reference WHERE fedora_id = :resourceId";
    private static final String SELECT_OUTBOUND_IN_TRANSACTION = "SELECT x.subject_id, x.target_id, x.property FROM (SELECT subject_id, target_id, property FROM reference WHERE fedora_id = :resourceId UNION SELECT subject_id, target_id, property FROM reference_transaction_operations WHERE fedora_id = :resourceId AND transaction_id = :transactionId AND operation = 'add') x WHERE NOT EXISTS (SELECT 1 FROM reference_transaction_operations WHERE fedora_id = :resourceId AND operation = 'delete')";
    private static final String INSERT_REFERENCE_IN_TRANSACTION = "INSERT INTO reference_transaction_operations(fedora_id, subject_id, property, target_id, transaction_id, operation) VALUES (:resourceId, :subjectId, :property, :targetId, :transactionId, 'add')";
    private static final String INSERT_REFERENCE_DIRECT = "INSERT INTO reference(fedora_id, subject_id, property, target_id) VALUES (:resourceId, :subjectId, :property, :targetId)";
    private static final String UNDO_INSERT_REFERENCE_IN_TRANSACTION = "DELETE FROM reference_transaction_operations WHERE fedora_id = :resourceId AND subject_id = :subjectId AND property = :property AND target_id = :targetId AND transaction_id = :transactionId AND operation = 'add'";
    private static final String DELETE_REFERENCE_IN_TRANSACTION = "INSERT INTO reference_transaction_operations(fedora_id, subject_id, property, target_id, transaction_id, operation) VALUES (:resourceId, :subjectId, :property, :targetId, :transactionId, 'delete')";
    private static final String DELETE_REFERENCE_DIRECT = "DELETE FROM reference WHERE fedora_id = :resourceId AND subject_id = :subjectId AND property = :property AND target_id = :targetId";
    private static final String UNDO_DELETE_REFERENCE_IN_TRANSACTION = "DELETE FROM reference_transaction_operations WHERE fedora_id = :resourceId AND subject_id = :subjectId AND property = :property AND target_id = :targetId AND transaction_id = :transactionId AND operation = 'delete'";
    private static final String IS_REFERENCE_ADDED_IN_TRANSACTION = "SELECT TRUE FROM reference_transaction_operations WHERE fedora_id = :resourceId AND subject_id = :subjectId AND property = :property AND target_id = :targetId AND transaction_id = :transactionId AND operation = 'add'";
    private static final String IS_REFERENCE_DELETED_IN_TRANSACTION = "SELECT TRUE FROM reference_transaction_operations WHERE fedora_id = :resourceId AND subject_id = :subjectId AND property = :property AND target_id = :targetId AND transaction_id = :transactionId AND operation = 'delete'";
    private static final String COMMIT_ADD_RECORDS = "INSERT INTO reference ( fedora_id, subject_id, property, target_id ) SELECT fedora_id, subject_id, property, target_id FROM reference_transaction_operations WHERE transaction_id = :transactionId AND operation = 'add'";
    private static final String COMMIT_DELETE_RECORDS = "DELETE FROM reference WHERE EXISTS (SELECT * FROM reference_transaction_operations t WHERE t.transaction_id = :transactionId AND t.operation = 'delete' AND t.fedora_id = reference.fedora_id AND t.subject_id = reference.subject_id AND t.property = reference.property AND t.target_id = reference.target_id)";
    private static final String DELETE_TRANSACTION = "DELETE FROM reference_transaction_operations WHERE transaction_id = :transactionId";
    private static final String TRUNCATE_TABLE = "TRUNCATE TABLE reference";
    private static final String TRUNCATE_TX_TABLE = "TRUNCATE TABLE reference_transaction_operations";

    @PostConstruct
    public void setUp() {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
    }

    public RdfStream getInboundReferences(@Nonnull Transaction tx, FedoraResource resource) {
        String resourceId = resource.getFedoraId().getFullId();
        Node subject = NodeFactory.createURI((String)resourceId);
        Stream<Triple> stream = this.getReferencesInternal(tx, resourceId);
        if (resource instanceof NonRdfSourceDescription) {
            Stream<Triple> stream2 = this.getReferencesInternal(tx, resource.getFedoraId().getBaseId());
            return new DefaultRdfStream(subject, Stream.concat(stream, stream2));
        }
        return new DefaultRdfStream(subject, stream);
    }

    private Stream<Triple> getReferencesInternal(Transaction tx, String targetId) {
        String query;
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("targetId", (Object)targetId);
        Node targetNode = NodeFactory.createURI((String)targetId);
        RowMapper inboundMapper = (rs, rowNum) -> Triple.create((Node)NodeFactory.createURI((String)rs.getString(SUBJECT_COLUMN)), (Node)NodeFactory.createURI((String)rs.getString(PROPERTY_COLUMN)), (Node)targetNode);
        if (tx.isOpenLongRunning()) {
            parameterSource.addValue("transactionId", (Object)tx.getId());
            query = SELECT_INBOUND_IN_TRANSACTION;
        } else {
            query = SELECT_INBOUND;
        }
        List references = this.jdbcTemplate.query(query, (SqlParameterSource)parameterSource, inboundMapper);
        LOGGER.debug("getInboundReferences for {} in transaction {} found {} references", new Object[]{targetId, tx, references.size()});
        return references.stream();
    }

    public void deleteAllReferences(@Nonnull Transaction tx, FedoraId resourceId) {
        List<Quad> deleteReferences = this.getOutboundReferences(tx, resourceId);
        if (resourceId.isDescription()) {
            deleteReferences.addAll(this.getOutboundReferences(tx, resourceId.asBaseId()));
        }
        deleteReferences.forEach(t -> this.removeReference(tx, (Quad)t));
    }

    private List<Quad> getOutboundReferences(Transaction tx, FedoraId resourceId) {
        String query;
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("resourceId", (Object)resourceId.getFullId());
        Node subjectNode = NodeFactory.createURI((String)resourceId.getFullId());
        RowMapper outboundMapper = (rs, rowNum) -> Quad.create((Node)subjectNode, (Node)NodeFactory.createURI((String)rs.getString(SUBJECT_COLUMN)), (Node)NodeFactory.createURI((String)rs.getString(PROPERTY_COLUMN)), (Node)NodeFactory.createURI((String)rs.getString(TARGET_COLUMN)));
        if (tx.isOpenLongRunning()) {
            parameterSource.addValue("transactionId", (Object)tx.getId());
            query = SELECT_OUTBOUND_IN_TRANSACTION;
        } else {
            query = SELECT_OUTBOUND;
        }
        List references = this.jdbcTemplate.query(query, (SqlParameterSource)parameterSource, outboundMapper);
        LOGGER.debug("getOutboundReferences for {} in transaction {} found {} references", new Object[]{resourceId, tx, references.size()});
        return references;
    }

    public void updateReferences(@Nonnull Transaction tx, FedoraId resourceId, String userPrincipal, RdfStream rdfStream) {
        try {
            List addReferences = this.getReferencesFromRdf(rdfStream).collect(Collectors.toList());
            Predicate<Quad> notInAdds = q -> !addReferences.contains(q.asTriple());
            List<Quad> existingReferences = this.getOutboundReferences(tx, resourceId);
            if (resourceId.isDescription()) {
                existingReferences.addAll(this.getOutboundReferences(tx, resourceId.asBaseId()));
            }
            existingReferences.stream().filter(notInAdds).forEach(t -> this.removeReference(tx, (Quad)t));
            Node resourceNode = NodeFactory.createURI((String)resourceId.getFullId());
            Predicate<Triple> alreadyExists = t -> !existingReferences.contains(Quad.create((Node)resourceNode, (Triple)t));
            addReferences.stream().filter(alreadyExists).forEach(r -> this.addReference(tx, Quad.create((Node)resourceNode, (Triple)r), userPrincipal));
        }
        catch (Exception e) {
            LOGGER.warn("Unable to update reference index for resource {} in transaction {}: {}", new Object[]{resourceId.getFullId(), tx.getId(), e.getMessage()});
            throw new RepositoryRuntimeException("Unable to update reference index", (Throwable)e);
        }
    }

    public void commitTransaction(Transaction tx) {
        if (!tx.isShortLived()) {
            tx.ensureCommitting();
            try {
                Map<String, String> parameterSource = Map.of("transactionId", tx.getId());
                this.jdbcTemplate.update(COMMIT_DELETE_RECORDS, parameterSource);
                this.jdbcTemplate.update(COMMIT_ADD_RECORDS, parameterSource);
                this.jdbcTemplate.update(DELETE_TRANSACTION, parameterSource);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to commit reference index transaction {}: {}", (Object)tx, (Object)e.getMessage());
                throw new RepositoryRuntimeException("Unable to commit reference index transaction", (Throwable)e);
            }
        }
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void rollbackTransaction(Transaction tx) {
        if (!tx.isShortLived()) {
            try {
                Map<String, String> parameterSource = Map.of("transactionId", tx.getId());
                this.jdbcTemplate.update(DELETE_TRANSACTION, parameterSource);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to rollback reference index transaction {}: {}", (Object)tx, (Object)e.getMessage());
                throw new RepositoryRuntimeException("Unable to rollback reference index transaction", (Throwable)e);
            }
        }
    }

    public void clearAllTransactions() {
        this.jdbcTemplate.update(TRUNCATE_TX_TABLE, Map.of());
    }

    public void reset() {
        try {
            this.jdbcTemplate.update(TRUNCATE_TABLE, Map.of());
            this.jdbcTemplate.update(TRUNCATE_TX_TABLE, Map.of());
        }
        catch (Exception e) {
            LOGGER.warn("Unable to reset reference index: {}", (Object)e.getMessage());
            throw new RepositoryRuntimeException("Unable to reset reference index", (Throwable)e);
        }
    }

    private void removeReference(Transaction tx, Quad reference) {
        tx.doInTx(() -> {
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("resourceId", (Object)reference.getGraph().getURI());
            parameterSource.addValue("subjectId", (Object)reference.getSubject().getURI());
            parameterSource.addValue(PROPERTY_COLUMN, (Object)reference.getPredicate().getURI());
            parameterSource.addValue("targetId", (Object)reference.getObject().getURI());
            if (!tx.isShortLived()) {
                boolean addedInTx;
                parameterSource.addValue("transactionId", (Object)tx.getId());
                boolean bl = addedInTx = !this.jdbcTemplate.queryForList(IS_REFERENCE_ADDED_IN_TRANSACTION, (SqlParameterSource)parameterSource).isEmpty();
                if (addedInTx) {
                    this.jdbcTemplate.update(UNDO_INSERT_REFERENCE_IN_TRANSACTION, (SqlParameterSource)parameterSource);
                } else {
                    this.jdbcTemplate.update(DELETE_REFERENCE_IN_TRANSACTION, (SqlParameterSource)parameterSource);
                }
            } else {
                this.jdbcTemplate.update(DELETE_REFERENCE_DIRECT, (SqlParameterSource)parameterSource);
            }
        });
    }

    private void addReference(@Nonnull Transaction transaction, Quad reference, String userPrincipal) {
        transaction.doInTx(() -> {
            String targetId = reference.getObject().getURI();
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("resourceId", (Object)reference.getGraph().getURI());
            parameterSource.addValue("subjectId", (Object)reference.getSubject().getURI());
            parameterSource.addValue(PROPERTY_COLUMN, (Object)reference.getPredicate().getURI());
            parameterSource.addValue("targetId", (Object)targetId);
            if (!transaction.isShortLived()) {
                boolean addedInTx;
                parameterSource.addValue("transactionId", (Object)transaction.getId());
                boolean bl = addedInTx = !this.jdbcTemplate.queryForList(IS_REFERENCE_DELETED_IN_TRANSACTION, (SqlParameterSource)parameterSource).isEmpty();
                if (addedInTx) {
                    this.jdbcTemplate.update(UNDO_DELETE_REFERENCE_IN_TRANSACTION, (SqlParameterSource)parameterSource);
                } else {
                    this.jdbcTemplate.update(INSERT_REFERENCE_IN_TRANSACTION, (SqlParameterSource)parameterSource);
                    this.recordEvent(transaction, targetId, userPrincipal);
                }
            } else {
                this.jdbcTemplate.update(INSERT_REFERENCE_DIRECT, (SqlParameterSource)parameterSource);
                this.recordEvent(transaction, targetId, userPrincipal);
            }
        });
    }

    private void recordEvent(Transaction transaction, String resourceId, String userPrincipal) {
        FedoraId fedoraId = FedoraId.create((String[])new String[]{resourceId});
        if (this.containmentIndex.resourceExists(transaction, fedoraId, false)) {
            this.eventAccumulator.recordEventForOperation(transaction, fedoraId, (ResourceOperation)ReferenceServiceImpl.getOperation(transaction, fedoraId, userPrincipal));
        }
    }

    private static ReferenceOperation getOperation(Transaction tx, FedoraId id, String user) {
        ReferenceOperationBuilder builder = new ReferenceOperationBuilder(tx, id);
        builder.userPrincipal(user);
        return builder.build();
    }

    private Stream<Triple> getReferencesFromRdf(RdfStream stream) {
        Predicate<Triple> isInternalReference = t -> {
            Node s = t.getSubject();
            Node o = t.getObject();
            return s.isURI() && s.getURI().startsWith("info:fedora") && o.isURI() && o.getURI().startsWith("info:fedora");
        };
        return stream.filter(isInternalReference);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

