/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.fcrepo.common.db.DbTransactionExecutor;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.TransactionManager;
import org.fcrepo.kernel.api.cache.UserTypesCache;
import org.fcrepo.kernel.api.exception.TransactionClosedException;
import org.fcrepo.kernel.api.exception.TransactionNotFoundException;
import org.fcrepo.kernel.api.lock.ResourceLockManager;
import org.fcrepo.kernel.api.observer.EventAccumulator;
import org.fcrepo.kernel.api.services.MembershipService;
import org.fcrepo.kernel.api.services.ReferenceService;
import org.fcrepo.kernel.impl.TransactionImpl;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.search.api.SearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TransactionManagerImpl
implements TransactionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionManagerImpl.class);
    private final Map<String, Transaction> transactions = new ConcurrentHashMap<String, Transaction>();
    @Autowired
    @Qualifier(value="containmentIndex")
    private ContainmentIndex containmentIndex;
    @Inject
    private PersistentStorageSessionManager pSessionManager;
    @Inject
    private EventAccumulator eventAccumulator;
    @Autowired
    @Qualifier(value="referenceService")
    private ReferenceService referenceService;
    @Inject
    private MembershipService membershipService;
    @Inject
    @Qualifier(value="searchIndex")
    private SearchIndex searchIndex;
    @Inject
    private ResourceLockManager resourceLockManager;
    @Inject
    private FedoraPropsConfig fedoraPropsConfig;
    @Inject
    private DbTransactionExecutor dbTransactionExecutor;
    @Inject
    private UserTypesCache userTypesCache;

    TransactionManagerImpl() {
    }

    @Scheduled(fixedDelayString="#{fedoraPropsConfig.sessionTimeout}")
    public void cleanupClosedTransactions() {
        LOGGER.debug("Cleaning up expired transactions");
        Iterator<Map.Entry<String, Transaction>> txIt = this.transactions.entrySet().iterator();
        while (txIt.hasNext()) {
            Map.Entry<String, Transaction> txEntry = txIt.next();
            Transaction tx = txEntry.getValue();
            if (tx.isCommitted() || tx.isRolledBack()) {
                if (tx.hasExpired()) {
                    txIt.remove();
                }
            } else if (tx.hasExpired()) {
                LOGGER.debug("Rolling back expired transaction {}", (Object)tx.getId());
                try {
                    tx.rollback();
                }
                catch (RuntimeException e) {
                    LOGGER.error("Failed to rollback expired transaction {}", (Object)tx.getId(), (Object)e);
                }
            }
            if (!tx.hasExpired()) continue;
            this.pSessionManager.removeSession(tx.getId());
        }
    }

    public synchronized Transaction create() {
        String txId = UUID.randomUUID().toString();
        while (this.transactions.containsKey(txId)) {
            txId = UUID.randomUUID().toString();
        }
        TransactionImpl tx = new TransactionImpl(txId, this, this.fedoraPropsConfig.getSessionTimeout());
        this.transactions.put(txId, tx);
        return tx;
    }

    public Transaction get(String transactionId) {
        if (this.transactions.containsKey(transactionId)) {
            Transaction transaction = this.transactions.get(transactionId);
            if (transaction.hasExpired()) {
                transaction.rollback();
                throw new TransactionClosedException("Transaction with transactionId: " + transactionId + " expired at " + transaction.getExpires() + "!");
            }
            if (transaction.isCommitted()) {
                throw new TransactionClosedException("Transaction with transactionId: " + transactionId + " has already been committed.");
            }
            if (transaction.isRolledBack()) {
                throw new TransactionClosedException("Transaction with transactionId: " + transactionId + " has already been rolled back.");
            }
            return transaction;
        }
        throw new TransactionNotFoundException("No Transaction found with transactionId: " + transactionId);
    }

    @PreDestroy
    public void cleanupAllTransactions() {
        LOGGER.debug("Shutting down transaction manager, attempt to rollback any incomplete transactions");
        for (Map.Entry<String, Transaction> txEntry : this.transactions.entrySet()) {
            Transaction tx = txEntry.getValue();
            if (!tx.isOpen() && !tx.hasExpired() || tx.isRolledBack()) continue;
            LOGGER.debug("Rolling back transaction as part of shutdown {}", (Object)tx.getId());
            try {
                tx.rollback();
                this.pSessionManager.removeSession(tx.getId());
            }
            catch (RuntimeException e) {
                LOGGER.error("Failed to rollback transaction {}", (Object)tx.getId(), (Object)e);
            }
        }
        LOGGER.debug("Finished rollback of all incomplete transactions as part of shut down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void preCleanTransactions() {
        LOGGER.debug("TransactionManagerImpl initialized, cleaning up leftover transaction entries");
        Map<String, Transaction> map = this.transactions;
        synchronized (map) {
            this.containmentIndex.clearAllTransactions();
            this.membershipService.clearAllTransactions();
            this.referenceService.clearAllTransactions();
            this.searchIndex.clearAllTransactions();
            this.pSessionManager.clearAllSessions();
        }
    }

    protected PersistentStorageSessionManager getPersistentStorageSessionManager() {
        return this.pSessionManager;
    }

    protected ContainmentIndex getContainmentIndex() {
        return this.containmentIndex;
    }

    protected SearchIndex getSearchIndex() {
        return this.searchIndex;
    }

    protected EventAccumulator getEventAccumulator() {
        return this.eventAccumulator;
    }

    protected ReferenceService getReferenceService() {
        return this.referenceService;
    }

    protected MembershipService getMembershipService() {
        return this.membershipService;
    }

    protected ResourceLockManager getResourceLockManager() {
        return this.resourceLockManager;
    }

    protected UserTypesCache getUserTypesCache() {
        return this.userTypesCache;
    }

    public DbTransactionExecutor getDbTransactionExecutor() {
        return this.dbTransactionExecutor;
    }
}

