/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.jena.graph.Triple;
import org.apache.jena.vocabulary.RDF;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.cache.UserTypesCache;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.springframework.stereotype.Component;

@Component
public class UserTypesCacheImpl
implements UserTypesCache {
    private final Cache<FedoraId, List<URI>> globalCache;
    private final Map<String, Cache<FedoraId, List<URI>>> sessionCaches;

    public UserTypesCacheImpl(FedoraPropsConfig config) {
        this.globalCache = Caffeine.newBuilder().maximumSize(config.getUserTypesCacheSize()).expireAfterAccess(config.getUserTypesCacheTimeout(), TimeUnit.MINUTES).build();
        this.sessionCaches = new ConcurrentHashMap<String, Cache<FedoraId, List<URI>>>();
    }

    public List<URI> getUserTypes(FedoraId resourceId, String sessionId, Supplier<RdfStream> rdfProvider) {
        if (this.isNotReadOnlySession(sessionId)) {
            Cache<FedoraId, List<URI>> sessionCache = this.getSessionCache(sessionId);
            return (List)sessionCache.get((Object)resourceId, k -> (List)this.globalCache.get((Object)resourceId, arg_0 -> this.lambda$getUserTypes$0((Supplier)rdfProvider, arg_0)));
        }
        return (List)this.globalCache.get((Object)resourceId, k -> this.extractRdfTypes((RdfStream)rdfProvider.get()));
    }

    public void cacheUserTypes(FedoraId resourceId, RdfStream rdf, String sessionId) {
        if (this.isNotReadOnlySession(sessionId)) {
            this.getSessionCache(sessionId).put((Object)resourceId, this.extractRdfTypes(rdf));
        }
    }

    public void cacheUserTypes(FedoraId resourceId, List<URI> userTypes, String sessionId) {
        if (this.isNotReadOnlySession(sessionId)) {
            this.getSessionCache(sessionId).put((Object)resourceId, userTypes);
        }
    }

    public void mergeSessionCache(String sessionId) {
        if (this.isNotReadOnlySession(sessionId)) {
            Cache<FedoraId, List<URI>> sessionCache = this.getSessionCache(sessionId);
            this.globalCache.putAll((Map)sessionCache.asMap());
            this.dropSessionCache(sessionId);
        }
    }

    public void dropSessionCache(String sessionId) {
        if (this.isNotReadOnlySession(sessionId)) {
            this.sessionCaches.remove(sessionId);
        }
    }

    private Cache<FedoraId, List<URI>> getSessionCache(String sessionId) {
        return this.sessionCaches.computeIfAbsent(sessionId, k -> Caffeine.newBuilder().maximumSize(1024L).build());
    }

    private List<URI> extractRdfTypes(RdfStream rdf) {
        return rdf.filter(t -> t.predicateMatches(RDF.type.asNode())).map(Triple::getObject).map(t -> URI.create(t.toString())).collect(Collectors.toList());
    }

    private boolean isNotReadOnlySession(String sessionId) {
        return !"read-only".equals(sessionId);
    }

    private /* synthetic */ List lambda$getUserTypes$0(Supplier rdfProvider, FedoraId k2) {
        return this.extractRdfTypes((RdfStream)rdfProvider.get());
    }
}

