/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.models;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.input.BoundedInputStream;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.cache.UserTypesCache;
import org.fcrepo.kernel.api.exception.ItemNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundRuntimeException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.Binary;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.impl.models.FedoraResourceImpl;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentItemNotFoundException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;

public class BinaryImpl
extends FedoraResourceImpl
implements Binary {
    private static final URI FEDORA_BINARY_URI = URI.create(RdfLexicon.FEDORA_BINARY.getURI());
    private String externalHandling;
    private String externalUrl;
    private Long contentSize;
    private String filename;
    private String mimeType;
    private Collection<URI> digests;

    public BinaryImpl(FedoraId fedoraID, Transaction transaction, PersistentStorageSessionManager pSessionManager, ResourceFactory resourceFactory, UserTypesCache userTypesCache) {
        super(fedoraID, transaction, pSessionManager, resourceFactory, userTypesCache);
    }

    public InputStream getContent() {
        try {
            if (this.isProxy().booleanValue() || this.isRedirect().booleanValue()) {
                return new BufferedInputStream(URI.create(this.getExternalURL()).toURL().openStream());
            }
            return this.getSession().getBinaryContent(this.getFedoraId().asResourceId(), this.getMementoDatetime());
        }
        catch (PersistentItemNotFoundException e) {
            throw new ItemNotFoundException("Unable to find content for " + this.getId() + " version " + this.getMementoDatetime(), (Throwable)e);
        }
        catch (IOException | PersistentStorageException e) {
            throw new RepositoryRuntimeException(e.getMessage(), e);
        }
    }

    public InputStream getRange(long start, long end) {
        try {
            if (this.isProxy().booleanValue() || this.isRedirect().booleanValue()) {
                long length = end + 1L;
                BoundedInputStream stream = new BoundedInputStream(URI.create(this.getExternalURL()).toURL().openStream(), length);
                stream.skip(start);
                return stream;
            }
            return this.getSession().getBinaryRange(this.getFedoraId().asResourceId(), this.getMementoDatetime(), start, end);
        }
        catch (PersistentItemNotFoundException e) {
            throw new ItemNotFoundException("Unable to find content for " + this.getId() + " version " + this.getMementoDatetime(), (Throwable)e);
        }
        catch (IOException | PersistentStorageException e) {
            throw new RepositoryRuntimeException(e.getMessage(), e);
        }
    }

    public long getContentSize() {
        return this.contentSize;
    }

    public Collection<URI> getContentDigests() {
        if (this.digests == null) {
            return null;
        }
        return this.digests;
    }

    public Boolean isProxy() {
        return "proxy".equals(this.externalHandling);
    }

    public Boolean isRedirect() {
        return "redirect".equals(this.externalHandling);
    }

    public String getExternalURL() {
        return this.externalUrl;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public FedoraResource getDescription() {
        try {
            FedoraId descId = this.getFedoraId().asDescription();
            if (this.isMemento()) {
                FedoraId descIdAsMemento = descId.asMemento(this.getMementoDatetime());
                return this.resourceFactory.getResource(this.transaction, descIdAsMemento);
            }
            return this.resourceFactory.getResource(this.transaction, descId);
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected void setExternalHandling(String externalHandling) {
        this.externalHandling = externalHandling;
    }

    protected void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    protected void setContentSize(Long contentSize) {
        this.contentSize = contentSize;
    }

    protected void setFilename(String filename) {
        this.filename = filename;
    }

    protected void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    protected void setDigests(Collection<URI> digests) {
        this.digests = digests;
    }

    @Override
    public List<URI> getSystemTypes(boolean forRdf) {
        List<URI> types = this.resolveSystemTypes(forRdf);
        if (types == null) {
            types = super.getSystemTypes(forRdf);
            types.add(FEDORA_BINARY_URI);
        }
        return types;
    }

    @Override
    public RdfStream getTriples() {
        return this.getDescription().getTriples();
    }
}

