/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer;

import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.observer.Event;
import org.fcrepo.kernel.api.observer.EventType;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.impl.observer.EventBuilder;
import org.fcrepo.kernel.impl.observer.EventImpl;
import org.fcrepo.kernel.impl.util.UserUtil;

public class ResourceOperationEventBuilder
implements EventBuilder {
    private FedoraId fedoraId;
    private Set<EventType> types;
    private Set<String> resourceTypes;
    private String userID;
    private String userAgent;
    private String baseUrl;
    private Instant date;
    private String userAgentBaseUri;

    public static ResourceOperationEventBuilder fromResourceOperation(FedoraId fedoraId, ResourceOperation operation, String userAgentBaseUri) {
        ResourceOperationEventBuilder builder = new ResourceOperationEventBuilder();
        builder.fedoraId = fedoraId;
        builder.date = Instant.now();
        builder.resourceTypes = new HashSet<String>();
        builder.userID = operation.getUserPrincipal();
        builder.types = new HashSet<EventType>();
        builder.types.add(ResourceOperationEventBuilder.mapOperationToEventType(operation));
        builder.userAgentBaseUri = userAgentBaseUri;
        return builder;
    }

    private static EventType mapOperationToEventType(ResourceOperation operation) {
        switch (operation.getType()) {
            case CREATE: 
            case OVERWRITE_TOMBSTONE: {
                return EventType.RESOURCE_CREATION;
            }
            case UPDATE: 
            case UPDATE_HEADERS: {
                return EventType.RESOURCE_MODIFICATION;
            }
            case DELETE: {
                return EventType.RESOURCE_DELETION;
            }
            case PURGE: {
                return EventType.RESOURCE_PURGE;
            }
            case FOLLOW: {
                return EventType.INBOUND_REFERENCE;
            }
        }
        throw new IllegalStateException(String.format("There is no EventType mapping for ResourceOperation type %s on operation %s", operation.getType(), operation));
    }

    private ResourceOperationEventBuilder() {
    }

    @Override
    public EventBuilder merge(EventBuilder other) {
        if (other == null) {
            return this;
        }
        if (!(other instanceof ResourceOperationEventBuilder)) {
            throw new IllegalStateException(String.format("Cannot merge EventBuilders because they are different types <%s> and <%s>", this.getClass(), other.getClass()));
        }
        ResourceOperationEventBuilder otherCast = (ResourceOperationEventBuilder)other;
        if (!this.fedoraId.equals((Object)otherCast.fedoraId)) {
            throw new IllegalStateException(String.format("Cannot merge events because they are for different resources: <%s> and <%s>", this, otherCast));
        }
        this.types.addAll(otherCast.types);
        this.resourceTypes.addAll(otherCast.resourceTypes);
        if (this.date.isBefore(otherCast.date)) {
            this.date = otherCast.date;
        }
        return this;
    }

    @Override
    public EventBuilder withResourceTypes(Set<String> resourceTypes) {
        this.resourceTypes = Objects.requireNonNullElse(resourceTypes, new HashSet());
        return this;
    }

    @Override
    public EventBuilder withBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public EventBuilder withUserAgent(String userAgent) {
        this.userAgent = userAgent.contains(" ") ? URLEncoder.encode(userAgent, StandardCharsets.UTF_8) : userAgent;
        return this;
    }

    @Override
    public Event build() {
        URI userUri = null;
        if (this.userID != null) {
            userUri = UserUtil.getUserURI(this.userID, this.userAgentBaseUri);
        }
        return new EventImpl(this.fedoraId, this.types, this.resourceTypes, this.userID, userUri, this.userAgent, this.baseUrl, this.date);
    }

    public String toString() {
        return "ResourceOperationEventBuilder{fedoraId=" + this.fedoraId + ", types=" + this.types + ", resourceTypes=" + this.resourceTypes + ", userID='" + this.userID + "', userAgent='" + this.userAgent + "', baseUrl='" + this.baseUrl + "', date=" + this.date + "}";
    }
}

