/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.fcrepo.common.db.DbPlatform;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.impl.services.MembershipServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MembershipIndexManager {
    private static final Logger log = LoggerFactory.getLogger(MembershipIndexManager.class);
    private static final Timestamp NO_END_TIMESTAMP = Timestamp.from(MembershipServiceImpl.NO_END_INSTANT);
    private static final Timestamp NO_START_TIMESTAMP = Timestamp.from(Instant.parse("1000-01-01T00:00:00.000Z"));
    private static final String ADD_OPERATION = "add";
    private static final String DELETE_OPERATION = "delete";
    private static final String FORCE_FLAG = "force";
    private static final String TX_ID_PARAM = "txId";
    private static final String SUBJECT_ID_PARAM = "subjectId";
    private static final String NO_END_TIME_PARAM = "noEndTime";
    private static final String ADD_OP_PARAM = "addOp";
    private static final String DELETE_OP_PARAM = "deleteOp";
    private static final String MEMENTO_TIME_PARAM = "mementoTime";
    private static final String PROPERTY_PARAM = "property";
    private static final String TARGET_ID_PARAM = "targetId";
    private static final String SOURCE_ID_PARAM = "sourceId";
    private static final String PROXY_ID_PARAM = "proxyId";
    private static final String START_TIME_PARAM = "startTime";
    private static final String END_TIME_PARAM = "endTime";
    private static final String LAST_UPDATED_PARAM = "lastUpdated";
    private static final String OPERATION_PARAM = "operation";
    private static final String FORCE_PARAM = "forceFlag";
    private static final String LIMIT_PARAM = "limit";
    private static final String OFFSET_PARAM = "offSet";
    private static final String SELECT_ALL_MEMBERSHIP = "SELECT * FROM membership";
    private static final String SELECT_ALL_OPERATIONS = "SELECT * FROM membership_tx_operations";
    private static final String SELECT_MEMBERSHIP_IN_TX = "SELECT property, object_id FROM membership m WHERE subject_id = :subjectId AND end_time = :noEndTime AND NOT EXISTS ( SELECT 1 FROM membership_tx_operations mto WHERE mto.subject_id = :subjectId AND mto.source_id = m.source_id AND mto.object_id = m.object_id AND mto.tx_id = :txId AND mto.operation = :deleteOp) UNION SELECT property, object_id FROM membership_tx_operations WHERE subject_id = :subjectId AND tx_id = :txId AND end_time = :noEndTime AND operation = :addOp ORDER BY property, object_id LIMIT :limit OFFSET :offSet";
    private static final String DIRECT_SELECT_MEMBERSHIP = "SELECT property, object_id FROM membership WHERE subject_id = :subjectId AND end_time = :noEndTime ORDER BY property, object_id LIMIT :limit OFFSET :offSet";
    private static final String SELECT_MEMBERSHIP_MEMENTO_IN_TX = "SELECT property, object_id FROM membership m WHERE m.subject_id = :subjectId AND m.start_time <= :mementoTime AND m.end_time > :mementoTime AND NOT EXISTS ( SELECT 1 FROM membership_tx_operations mto WHERE mto.subject_id = :subjectId AND mto.source_id = m.source_id AND mto.property = m.property AND mto.object_id = m.object_id AND mto.end_time <= :mementoTime AND mto.tx_id = :txId AND mto.operation = :deleteOp) UNION SELECT property, object_id FROM membership_tx_operations WHERE subject_id = :subjectId AND tx_id = :txId AND start_time <= :mementoTime AND end_time > :mementoTime AND operation = :addOp ORDER BY property, object_id LIMIT :limit OFFSET :offSet";
    private static final String DIRECT_SELECT_MEMBERSHIP_MEMENTO = "SELECT property, object_id FROM membership WHERE subject_id = :subjectId AND start_time <= :mementoTime AND end_time > :mementoTime ORDER BY property, object_id LIMIT :limit OFFSET :offSet";
    private static final String SELECT_LAST_UPDATED = "SELECT max(last_updated) as last_updated FROM membership WHERE subject_id = :subjectId";
    private static final String SELECT_LAST_UPDATED_MEMENTO = "SELECT max(start_time) FROM membership WHERE subject_id = :subjectId AND start_time <= :mementoTime AND end_time > :mementoTime";
    private static final String SELECT_LAST_UPDATED_IN_TX = "SELECT max(combined.updated) as last_updated FROM ( SELECT max(last_updated) as updated FROM membership m WHERE subject_id = :subjectId AND NOT EXISTS ( SELECT 1 FROM membership_tx_operations mto WHERE mto.subject_id = :subjectId AND mto.source_id = m.source_id AND mto.object_id = m.object_id AND mto.tx_id = :txId AND mto.operation = :deleteOp) UNION SELECT max(last_updated) as updated FROM membership_tx_operations WHERE subject_id = :subjectId AND tx_id = :txId) combined";
    private static final String INSERT_MEMBERSHIP_IN_TX = "INSERT INTO membership_tx_operations (subject_id, property, object_id, source_id, proxy_id, start_time, end_time, last_updated, tx_id, operation) VALUES (:subjectId, :property, :targetId, :sourceId, :proxyId, :startTime, :endTime, :lastUpdated, :txId, :operation)";
    private static final String DIRECT_INSERT_MEMBERSHIP = "INSERT INTO membership (subject_id, property, object_id, source_id, proxy_id, start_time, end_time, last_updated) VALUES (:subjectId, :property, :targetId, :sourceId, :proxyId, :startTime, :endTime, :lastUpdated)";
    private static final String END_EXISTING_MEMBERSHIP = "INSERT INTO membership_tx_operations (subject_id, property, object_id, source_id, proxy_id, start_time, end_time, last_updated, tx_id, operation) SELECT m.subject_id, m.property, m.object_id, m.source_id, m.proxy_id, m.start_time, :endTime, :endTime, :txId, :deleteOp FROM membership m WHERE m.source_id = :sourceId AND m.proxy_id = :proxyId AND m.end_time = :noEndTime";
    private static final String DIRECT_END_EXISTING_MEMBERSHIP = "UPDATE membership SET end_time = :endTime, last_updated = :endTime WHERE source_id = :sourceId AND proxy_id = :proxyId AND end_time = :noEndTime";
    private static final String CLEAR_FOR_PROXY_IN_TX = "DELETE FROM membership_tx_operations WHERE source_id = :sourceId AND tx_id = :txId AND proxy_id = :proxyId AND force_flag IS NULL";
    private static final String CLEAR_ALL_ADDED_FOR_SOURCE_IN_TX = "DELETE FROM membership_tx_operations WHERE source_id = :sourceId AND tx_id = :txId AND operation = :addOp";
    private static final String END_EXISTING_FOR_SOURCE = "INSERT INTO membership_tx_operations (subject_id, property, object_id, source_id, proxy_id, start_time, end_time, last_updated, tx_id, operation) SELECT subject_id, property, object_id, source_id, proxy_id, start_time, :endTime, :endTime, :txId, :deleteOp FROM membership m WHERE source_id = :sourceId AND end_time = :noEndTime AND NOT EXISTS ( SELECT TRUE FROM membership_tx_operations mtx WHERE mtx.subject_id = m.subject_id AND mtx.property = m.property AND mtx.object_id = m.object_id AND mtx.source_id = m.source_id AND mtx.proxy_id = m.proxy_id AND mtx.operation = :deleteOp)";
    private static final String DIRECT_END_EXISTING_FOR_SOURCE = "UPDATE membership SET end_time = :endTime, last_updated = :endTime WHERE source_id = :sourceId AND end_time = :noEndTime";
    private static final String DELETE_EXISTING_FOR_SOURCE_AFTER = "INSERT INTO membership_tx_operations(subject_id, property, object_id, source_id, proxy_id, start_time, end_time, last_updated, tx_id, operation, force_flag) SELECT subject_id, property, object_id, source_id, proxy_id, start_time, end_time, last_updated, :txId, :deleteOp, :forceFlag FROM membership m WHERE m.source_id = :sourceId AND (m.start_time >= :startTime OR m.end_time >= :startTime)";
    private static final String DIRECT_DELETE_EXISTING_FOR_SOURCE_AFTER = "DELETE FROM membership WHERE source_id = :sourceId AND (start_time >= :startTime OR end_time >= :startTime)";
    private static final String DELETE_EXISTING_FOR_PROXY_AFTER = "INSERT INTO membership_tx_operations(subject_id, property, object_id, source_id, proxy_id, start_time, end_time, last_updated, tx_id, operation, force_flag) SELECT subject_id, property, object_id, source_id, proxy_id, start_time, end_time, last_updated, :txId, :deleteOp, :forceFlag FROM membership m WHERE m.proxy_id = :proxyId AND (m.start_time >= :startTime OR m.end_time >= :startTime)";
    private static final String DIRECT_DELETE_EXISTING_FOR_PROXY_AFTER = "UPDATE membership SET end_time = :endTime, last_updated = :endTime WHERE proxy_id = :proxyId AND (start_time >= :endTime OR end_time >= :endTime)";
    private static final String PURGE_ALL_REFERENCES_MEMBERSHIP = "DELETE from membership where source_id = :targetId OR subject_id = :targetId OR object_id = :targetId";
    private static final String PURGE_ALL_REFERENCES_TRANSACTION = "DELETE from membership_tx_operations WHERE tx_id = :txId AND (source_id = :targetId OR subject_id = :targetId OR object_id = :targetId)";
    private static final String COMMIT_DELETES = "DELETE from membership WHERE EXISTS ( SELECT TRUE FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND mto.operation = :deleteOp AND mto.force_flag = :forceFlag AND membership.source_id = mto.source_id AND membership.proxy_id = mto.proxy_id AND membership.subject_id = mto.subject_id AND membership.property = mto.property AND membership.object_id = mto.object_id )";
    private static final String COMMIT_ENDS_H2 = "UPDATE membership m SET end_time = ( SELECT mto.end_time FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND m.source_id = mto.source_id AND m.proxy_id = mto.proxy_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id AND mto.operation = :deleteOp ), last_updated = ( SELECT mto.end_time FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND m.source_id = mto.source_id AND m.proxy_id = mto.proxy_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id AND mto.operation = :deleteOp ) WHERE EXISTS (SELECT TRUE FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND mto.operation = :deleteOp AND m.source_id = mto.source_id AND m.proxy_id = mto.proxy_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id )";
    private static final String COMMIT_ENDS_POSTGRES = "UPDATE membership SET end_time = mto.end_time, last_updated = mto.end_time FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND mto.operation = :deleteOp AND membership.source_id = mto.source_id AND membership.proxy_id = mto.proxy_id AND membership.subject_id = mto.subject_id AND membership.property = mto.property AND membership.object_id = mto.object_id";
    private static final String COMMIT_ENDS_MYSQL = "UPDATE membership m INNER JOIN membership_tx_operations mto ON m.source_id = mto.source_id AND m.proxy_id = mto.proxy_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id SET m.end_time = mto.end_time, m.last_updated = mto.end_time WHERE mto.tx_id = :txId AND mto.operation = :deleteOp";
    private static final Map<DbPlatform, String> COMMIT_ENDS_MAP = Map.of(DbPlatform.MYSQL, "UPDATE membership m INNER JOIN membership_tx_operations mto ON m.source_id = mto.source_id AND m.proxy_id = mto.proxy_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id SET m.end_time = mto.end_time, m.last_updated = mto.end_time WHERE mto.tx_id = :txId AND mto.operation = :deleteOp", DbPlatform.MARIADB, "UPDATE membership m INNER JOIN membership_tx_operations mto ON m.source_id = mto.source_id AND m.proxy_id = mto.proxy_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id SET m.end_time = mto.end_time, m.last_updated = mto.end_time WHERE mto.tx_id = :txId AND mto.operation = :deleteOp", DbPlatform.POSTGRESQL, "UPDATE membership SET end_time = mto.end_time, last_updated = mto.end_time FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND mto.operation = :deleteOp AND membership.source_id = mto.source_id AND membership.proxy_id = mto.proxy_id AND membership.subject_id = mto.subject_id AND membership.property = mto.property AND membership.object_id = mto.object_id", DbPlatform.H2, "UPDATE membership m SET end_time = ( SELECT mto.end_time FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND m.source_id = mto.source_id AND m.proxy_id = mto.proxy_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id AND mto.operation = :deleteOp ), last_updated = ( SELECT mto.end_time FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND m.source_id = mto.source_id AND m.proxy_id = mto.proxy_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id AND mto.operation = :deleteOp ) WHERE EXISTS (SELECT TRUE FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND mto.operation = :deleteOp AND m.source_id = mto.source_id AND m.proxy_id = mto.proxy_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id )");
    private static final String COMMIT_ADDS = "INSERT INTO membership (subject_id, property, object_id, source_id, proxy_id, start_time, end_time, last_updated) SELECT subject_id, property, object_id, source_id, proxy_id, start_time, end_time, last_updated FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND mto.operation = :addOp AND NOT EXISTS ( SELECT TRUE FROM membership m WHERE m.source_id = mto.source_id AND m.proxy_id = mto.proxy_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id AND m.start_time = mto.start_time AND m.end_time = mto.end_time )";
    private static final String DELETE_TRANSACTION = "DELETE FROM membership_tx_operations WHERE tx_id = :txId";
    private static final String TRUNCATE_MEMBERSHIP = "TRUNCATE TABLE membership";
    private static final String TRUNCATE_MEMBERSHIP_TX = "TRUNCATE TABLE membership_tx_operations";
    @Inject
    private DataSource dataSource;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private DbPlatform dbPlatform;
    private static final int MEMBERSHIP_LIMIT = 50000;

    @PostConstruct
    public void setUp() {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        this.dbPlatform = DbPlatform.fromDataSource((DataSource)this.dataSource);
    }

    public void endMembershipFromChild(Transaction tx, FedoraId sourceId, FedoraId proxyId, Instant endTime) {
        tx.doInTx(() -> {
            if (!tx.isShortLived()) {
                MapSqlParameterSource parameterSource = new MapSqlParameterSource();
                parameterSource.addValue(TX_ID_PARAM, (Object)tx.getId());
                parameterSource.addValue(SOURCE_ID_PARAM, (Object)sourceId.getFullId());
                parameterSource.addValue(PROXY_ID_PARAM, (Object)proxyId.getFullId());
                int affected = this.jdbcTemplate.update(CLEAR_FOR_PROXY_IN_TX, (SqlParameterSource)parameterSource);
                if (affected == 0) {
                    MapSqlParameterSource parameterSource2 = new MapSqlParameterSource();
                    parameterSource2.addValue(TX_ID_PARAM, (Object)tx.getId());
                    parameterSource2.addValue(SOURCE_ID_PARAM, (Object)sourceId.getFullId());
                    parameterSource2.addValue(PROXY_ID_PARAM, (Object)proxyId.getFullId());
                    parameterSource2.addValue(END_TIME_PARAM, (Object)this.formatInstant(endTime));
                    parameterSource2.addValue(NO_END_TIME_PARAM, (Object)NO_END_TIMESTAMP);
                    parameterSource2.addValue(DELETE_OP_PARAM, (Object)DELETE_OPERATION);
                    this.jdbcTemplate.update(END_EXISTING_MEMBERSHIP, (SqlParameterSource)parameterSource2);
                }
            } else {
                MapSqlParameterSource parameterSource = new MapSqlParameterSource();
                parameterSource.addValue(SOURCE_ID_PARAM, (Object)sourceId.getFullId());
                parameterSource.addValue(PROXY_ID_PARAM, (Object)proxyId.getFullId());
                parameterSource.addValue(END_TIME_PARAM, (Object)this.formatInstant(endTime));
                parameterSource.addValue(NO_END_TIME_PARAM, (Object)NO_END_TIMESTAMP);
                this.jdbcTemplate.update(DIRECT_END_EXISTING_MEMBERSHIP, (SqlParameterSource)parameterSource);
            }
        });
    }

    public void deleteMembershipForProxyAfter(Transaction tx, FedoraId sourceId, FedoraId proxyId, Instant afterTime) {
        tx.doInTx(() -> {
            Timestamp afterTimestamp;
            Timestamp timestamp = afterTimestamp = afterTime == null ? NO_START_TIMESTAMP : this.formatInstant(afterTime);
            if (!tx.isShortLived()) {
                Map<String, String> parameterSource = Map.of(TX_ID_PARAM, tx.getId(), SOURCE_ID_PARAM, sourceId.getFullId(), PROXY_ID_PARAM, proxyId.getFullId(), OPERATION_PARAM, ADD_OPERATION);
                this.jdbcTemplate.update(CLEAR_FOR_PROXY_IN_TX, parameterSource);
                Map<String, String> parameterSource2 = Map.of(TX_ID_PARAM, tx.getId(), PROXY_ID_PARAM, proxyId.getFullId(), START_TIME_PARAM, afterTimestamp, FORCE_PARAM, FORCE_FLAG, DELETE_OP_PARAM, DELETE_OPERATION);
                this.jdbcTemplate.update(DELETE_EXISTING_FOR_PROXY_AFTER, parameterSource2);
            } else {
                Map<String, Timestamp> parameterSource = Map.of(PROXY_ID_PARAM, proxyId.getFullId(), END_TIME_PARAM, afterTimestamp);
                this.jdbcTemplate.update(DIRECT_DELETE_EXISTING_FOR_PROXY_AFTER, parameterSource);
            }
        });
    }

    public void endMembershipForSource(Transaction tx, FedoraId sourceId, Instant endTime) {
        tx.doInTx(() -> {
            if (!tx.isShortLived()) {
                Map<String, String> parameterSource = Map.of(TX_ID_PARAM, tx.getId(), SOURCE_ID_PARAM, sourceId.getFullId(), ADD_OP_PARAM, ADD_OPERATION);
                this.jdbcTemplate.update(CLEAR_ALL_ADDED_FOR_SOURCE_IN_TX, parameterSource);
                Map<String, String> parameterSource2 = Map.of(TX_ID_PARAM, tx.getId(), SOURCE_ID_PARAM, sourceId.getFullId(), END_TIME_PARAM, this.formatInstant(endTime), NO_END_TIME_PARAM, NO_END_TIMESTAMP, DELETE_OP_PARAM, DELETE_OPERATION);
                this.jdbcTemplate.update(END_EXISTING_FOR_SOURCE, parameterSource2);
            } else {
                Map<String, Timestamp> parameterSource = Map.of(SOURCE_ID_PARAM, sourceId.getFullId(), END_TIME_PARAM, this.formatInstant(endTime), NO_END_TIME_PARAM, NO_END_TIMESTAMP);
                this.jdbcTemplate.update(DIRECT_END_EXISTING_FOR_SOURCE, parameterSource);
            }
        });
    }

    public void deleteMembershipForSourceAfter(Transaction tx, FedoraId sourceId, Instant afterTime) {
        tx.doInTx(() -> {
            Timestamp afterTimestamp;
            Timestamp timestamp = afterTimestamp = afterTime == null ? NO_START_TIMESTAMP : this.formatInstant(afterTime);
            if (!tx.isShortLived()) {
                Map<String, String> parameterSource = Map.of(TX_ID_PARAM, tx.getId(), SOURCE_ID_PARAM, sourceId.getFullId(), ADD_OP_PARAM, ADD_OPERATION);
                this.jdbcTemplate.update(CLEAR_ALL_ADDED_FOR_SOURCE_IN_TX, parameterSource);
                Map<String, String> parameterSource2 = Map.of(TX_ID_PARAM, tx.getId(), SOURCE_ID_PARAM, sourceId.getFullId(), START_TIME_PARAM, afterTimestamp, FORCE_PARAM, FORCE_FLAG, DELETE_OP_PARAM, DELETE_OPERATION);
                this.jdbcTemplate.update(DELETE_EXISTING_FOR_SOURCE_AFTER, parameterSource2);
            } else {
                Map<String, Timestamp> parameterSource = Map.of(SOURCE_ID_PARAM, sourceId.getFullId(), START_TIME_PARAM, afterTimestamp);
                this.jdbcTemplate.update(DIRECT_DELETE_EXISTING_FOR_SOURCE_AFTER, parameterSource);
            }
        });
    }

    public void deleteMembershipReferences(String txId, FedoraId targetId) {
        Map<String, String> parameterSource = Map.of(TARGET_ID_PARAM, targetId.getFullId(), TX_ID_PARAM, txId);
        this.jdbcTemplate.update(PURGE_ALL_REFERENCES_TRANSACTION, parameterSource);
        this.jdbcTemplate.update(PURGE_ALL_REFERENCES_MEMBERSHIP, parameterSource);
    }

    public void addMembership(Transaction tx, FedoraId sourceId, FedoraId proxyId, Triple membership, Instant startTime) {
        if (membership == null) {
            return;
        }
        this.addMembership(tx, sourceId, proxyId, membership, startTime, null);
    }

    public void addMembership(Transaction tx, FedoraId sourceId, FedoraId proxyId, Triple membership, Instant startTime, Instant endTime) {
        tx.doInTx(() -> {
            Timestamp lastUpdated;
            Timestamp endTimestamp;
            Timestamp startTimestamp = this.formatInstant(startTime);
            if (endTime == null) {
                endTimestamp = NO_END_TIMESTAMP;
                lastUpdated = startTimestamp;
            } else {
                lastUpdated = endTimestamp = this.formatInstant(endTime);
            }
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue(SUBJECT_ID_PARAM, (Object)membership.getSubject().getURI());
            parameterSource.addValue(PROPERTY_PARAM, (Object)membership.getPredicate().getURI());
            parameterSource.addValue(TARGET_ID_PARAM, (Object)membership.getObject().getURI());
            parameterSource.addValue(SOURCE_ID_PARAM, (Object)sourceId.getFullId());
            parameterSource.addValue(PROXY_ID_PARAM, (Object)proxyId.getFullId());
            parameterSource.addValue(START_TIME_PARAM, (Object)startTimestamp);
            parameterSource.addValue(END_TIME_PARAM, (Object)endTimestamp);
            parameterSource.addValue(LAST_UPDATED_PARAM, (Object)lastUpdated);
            if (!tx.isShortLived()) {
                parameterSource.addValue(TX_ID_PARAM, (Object)tx.getId());
                parameterSource.addValue(OPERATION_PARAM, (Object)ADD_OPERATION);
                this.jdbcTemplate.update(INSERT_MEMBERSHIP_IN_TX, (SqlParameterSource)parameterSource);
            } else {
                this.jdbcTemplate.update(DIRECT_INSERT_MEMBERSHIP, (SqlParameterSource)parameterSource);
            }
        });
    }

    public Stream<Triple> getMembership(Transaction tx, FedoraId subjectId) {
        String query;
        Node subjectNode = NodeFactory.createURI((String)subjectId.getBaseId());
        RowMapper membershipMapper = (rs, rowNum) -> Triple.create((Node)subjectNode, (Node)NodeFactory.createURI((String)rs.getString(PROPERTY_PARAM)), (Node)NodeFactory.createURI((String)rs.getString("object_id")));
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        if (subjectId.isMemento()) {
            parameterSource.addValue(SUBJECT_ID_PARAM, (Object)subjectId.getBaseId());
            parameterSource.addValue(MEMENTO_TIME_PARAM, (Object)this.formatInstant(subjectId.getMementoInstant()));
        } else {
            parameterSource.addValue(SUBJECT_ID_PARAM, (Object)subjectId.getFullId());
            parameterSource.addValue(NO_END_TIME_PARAM, (Object)NO_END_TIMESTAMP);
        }
        if (tx.isOpenLongRunning()) {
            parameterSource.addValue(TX_ID_PARAM, (Object)tx.getId());
            query = subjectId.isMemento() ? SELECT_MEMBERSHIP_MEMENTO_IN_TX : SELECT_MEMBERSHIP_IN_TX;
        } else {
            query = subjectId.isMemento() ? DIRECT_SELECT_MEMBERSHIP_MEMENTO : DIRECT_SELECT_MEMBERSHIP;
        }
        return StreamSupport.stream(new MembershipIterator(query, parameterSource, (RowMapper<Triple>)membershipMapper), false);
    }

    public Instant getLastUpdated(Transaction transaction, FedoraId subjectId) {
        String lastUpdatedQuery;
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(NO_END_TIME_PARAM, (Object)NO_END_TIMESTAMP);
        if (subjectId.isMemento()) {
            lastUpdatedQuery = SELECT_LAST_UPDATED_MEMENTO;
            parameterSource.addValue(SUBJECT_ID_PARAM, (Object)subjectId.getBaseId());
            parameterSource.addValue(MEMENTO_TIME_PARAM, (Object)this.formatInstant(subjectId.getMementoInstant()));
        } else if (transaction.isOpenLongRunning()) {
            lastUpdatedQuery = SELECT_LAST_UPDATED_IN_TX;
            parameterSource.addValue(SUBJECT_ID_PARAM, (Object)subjectId.getFullId());
            parameterSource.addValue(TX_ID_PARAM, (Object)transaction.getId());
            parameterSource.addValue(DELETE_OP_PARAM, (Object)DELETE_OPERATION);
        } else {
            lastUpdatedQuery = SELECT_LAST_UPDATED;
            parameterSource.addValue(SUBJECT_ID_PARAM, (Object)subjectId.getFullId());
        }
        Timestamp updated = (Timestamp)this.jdbcTemplate.queryForObject(lastUpdatedQuery, (SqlParameterSource)parameterSource, Timestamp.class);
        if (updated != null) {
            return updated.toInstant();
        }
        return null;
    }

    public void commitTransaction(Transaction tx) {
        if (!tx.isShortLived()) {
            tx.ensureCommitting();
            Map<String, String> parameterSource = Map.of(TX_ID_PARAM, tx.getId(), ADD_OP_PARAM, ADD_OPERATION, DELETE_OP_PARAM, DELETE_OPERATION, FORCE_PARAM, FORCE_FLAG);
            this.jdbcTemplate.update(COMMIT_DELETES, parameterSource);
            int ends = this.jdbcTemplate.update(COMMIT_ENDS_MAP.get(this.dbPlatform), parameterSource);
            int adds = this.jdbcTemplate.update(COMMIT_ADDS, parameterSource);
            int cleaned = this.jdbcTemplate.update(DELETE_TRANSACTION, parameterSource);
            log.debug("Completed commit, {} ended, {} adds, {} operations", new Object[]{ends, adds, cleaned});
        }
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void deleteTransaction(Transaction tx) {
        if (!tx.isShortLived()) {
            Map<String, String> parameterSource = Map.of(TX_ID_PARAM, tx.getId());
            this.jdbcTemplate.update(DELETE_TRANSACTION, parameterSource);
        }
    }

    private Timestamp formatInstant(Instant instant) {
        Timestamp timestamp = Timestamp.from(instant);
        timestamp.setNanos(0);
        return timestamp;
    }

    public void clearIndex() {
        this.jdbcTemplate.update(TRUNCATE_MEMBERSHIP, Map.of());
        this.jdbcTemplate.update(TRUNCATE_MEMBERSHIP_TX, Map.of());
    }

    public void clearAllTransactions() {
        this.jdbcTemplate.update(TRUNCATE_MEMBERSHIP_TX, Map.of());
    }

    protected void logMembership() {
        log.info("source_id, proxy_id, subject_id, property, object_id, start_time, end_time, last_updated");
        this.jdbcTemplate.query(SELECT_ALL_MEMBERSHIP, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                log.info("{}, {}, {}, {}, {}, {}, {}, {}", new Object[]{rs.getString("source_id"), rs.getString("proxy_id"), rs.getString("subject_id"), rs.getString(MembershipIndexManager.PROPERTY_PARAM), rs.getString("object_id"), rs.getTimestamp("start_time"), rs.getTimestamp("end_time"), rs.getTimestamp("last_updated")});
            }
        });
    }

    protected void logOperations() {
        log.info("source_id, proxy_id, subject_id, property, object_id, start_time, end_time, last_updated, tx_id, operation, force_flag");
        this.jdbcTemplate.query(SELECT_ALL_OPERATIONS, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                log.info("{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}", new Object[]{rs.getString("source_id"), rs.getString("proxy_id"), rs.getString("subject_id"), rs.getString(MembershipIndexManager.PROPERTY_PARAM), rs.getString("object_id"), rs.getTimestamp("start_time"), rs.getTimestamp("end_time"), rs.getTimestamp("last_updated"), rs.getString("tx_id"), rs.getString(MembershipIndexManager.OPERATION_PARAM), rs.getString("force_flag")});
            }
        });
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private class MembershipIterator
    extends Spliterators.AbstractSpliterator<Triple> {
        final Queue<Triple> children;
        int numOffsets;
        final String queryToUse;
        final MapSqlParameterSource parameterSource;
        final RowMapper<Triple> rowMapper;

        public MembershipIterator(String query, MapSqlParameterSource parameters, RowMapper<Triple> mapper) {
            super(Long.MAX_VALUE, 16);
            this.children = new ConcurrentLinkedQueue<Triple>();
            this.numOffsets = 0;
            this.queryToUse = query;
            this.parameterSource = parameters;
            this.rowMapper = mapper;
            this.parameterSource.addValue(MembershipIndexManager.ADD_OP_PARAM, (Object)MembershipIndexManager.ADD_OPERATION);
            this.parameterSource.addValue(MembershipIndexManager.DELETE_OP_PARAM, (Object)MembershipIndexManager.DELETE_OPERATION);
            this.parameterSource.addValue(MembershipIndexManager.LIMIT_PARAM, (Object)50000);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Triple> action) {
            try {
                action.accept((Triple)this.children.remove());
            }
            catch (NoSuchElementException e) {
                this.parameterSource.addValue(MembershipIndexManager.OFFSET_PARAM, (Object)(this.numOffsets * 50000));
                ++this.numOffsets;
                this.children.addAll(MembershipIndexManager.this.jdbcTemplate.query(this.queryToUse, (SqlParameterSource)this.parameterSource, this.rowMapper));
                if (this.children.size() == 0) {
                    return false;
                }
                action.accept((Triple)this.children.remove());
            }
            return true;
        }
    }
}

