/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import org.fcrepo.common.metrics.MetricsHelper;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.services.ReferenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="referenceService")
public class ReferenceServiceMetrics
implements ReferenceService {
    private static final String METRIC_NAME = "fcrepo.db";
    private static final String DB = "db";
    private static final String REFERENCE = "reference";
    private static final String OPERATION = "operation";
    private static final Timer getInboundReferences = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "reference", "operation", "getInboundReferences"});
    private static final Timer deleteAllReferencesTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "reference", "operation", "deleteAllReferences"});
    private static final Timer updateReferencesTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "reference", "operation", "updateReferences"});
    private static final Timer commitTransactionTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "reference", "operation", "commitTransaction"});
    private static final Timer rollbackTransactionTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "reference", "operation", "rollbackTransaction"});
    private static final Timer resetTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "reference", "operation", "reset"});
    private static final Timer clearAllTransactionsTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "reference", "operation", "clearAllTransactions"});
    @Autowired
    @Qualifier(value="referenceServiceImpl")
    private ReferenceService referenceServiceImpl;

    public RdfStream getInboundReferences(Transaction tx, FedoraResource resource) {
        return (RdfStream)MetricsHelper.time((Timer)getInboundReferences, () -> this.referenceServiceImpl.getInboundReferences(tx, resource));
    }

    public void deleteAllReferences(Transaction tx, FedoraId resourceId) {
        deleteAllReferencesTimer.record(() -> this.referenceServiceImpl.deleteAllReferences(tx, resourceId));
    }

    public void updateReferences(Transaction tx, FedoraId resourceId, String userPrincipal, RdfStream rdfStream) {
        updateReferencesTimer.record(() -> this.referenceServiceImpl.updateReferences(tx, resourceId, userPrincipal, rdfStream));
    }

    public void commitTransaction(Transaction tx) {
        commitTransactionTimer.record(() -> this.referenceServiceImpl.commitTransaction(tx));
    }

    public void rollbackTransaction(Transaction tx) {
        rollbackTransactionTimer.record(() -> this.referenceServiceImpl.rollbackTransaction(tx));
    }

    public void clearAllTransactions() {
        clearAllTransactionsTimer.record(() -> this.referenceServiceImpl.clearAllTransactions());
    }

    public void reset() {
        resetTimer.record(() -> this.referenceServiceImpl.reset());
    }
}

