/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.util.ArrayList;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.jena.graph.Triple;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.rdf.LdpTriplePreferences;
import org.fcrepo.kernel.api.services.ContainmentTriplesService;
import org.fcrepo.kernel.api.services.ManagedPropertiesService;
import org.fcrepo.kernel.api.services.MembershipService;
import org.fcrepo.kernel.api.services.ReferenceService;
import org.fcrepo.kernel.api.services.ResourceTripleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ResourceTripleServiceImpl
implements ResourceTripleService {
    @Inject
    private ManagedPropertiesService managedPropertiesService;
    @Inject
    private ContainmentTriplesService containmentTriplesService;
    @Autowired
    @Qualifier(value="referenceService")
    private ReferenceService referenceService;
    @Inject
    private MembershipService membershipService;

    public Stream<Triple> getResourceTriples(Transaction tx, FedoraResource resource, LdpTriplePreferences preferences, int limit) {
        ArrayList<Object> streams = new ArrayList<Object>();
        if (preferences.displayUserRdf()) {
            streams.add(resource.getTriples());
        }
        if (preferences.displayServerManaged()) {
            streams.add(this.managedPropertiesService.get(resource));
        }
        if (preferences.displayContainment()) {
            if (limit == -1) {
                streams.add(this.containmentTriplesService.get(tx, resource));
            } else {
                streams.add(this.containmentTriplesService.get(tx, resource).limit(limit));
            }
        }
        if (preferences.displayMembership()) {
            streams.add(this.membershipService.getMembership(tx, resource.getFedoraId()));
        }
        if (preferences.displayReferences()) {
            streams.add(this.referenceService.getInboundReferences(tx, resource));
        }
        return streams.stream().reduce(Stream.empty(), Stream::concat);
    }
}

