/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import org.apache.tika.io.IOUtils;
import org.fcrepo.Datastream;
import org.fcrepo.FedoraObject;
import org.fcrepo.exception.InvalidChecksumException;
import org.fcrepo.utils.FedoraJcrTypes;
import org.fcrepo.utils.FedoraTypesUtils;
import org.fcrepo.utils.TestHelpers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.Binary;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={FedoraTypesUtils.class})
public class DatastreamTest
implements FedoraJcrTypes {
    String testPid = "testObj";
    String testDsId = "testDs";
    Datastream testObj;
    Session mockSession;
    Node mockRootNode;
    Node mockDsNode;

    @Before
    public void setUp() {
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.mockRootNode = (Node)Mockito.mock(Node.class);
        this.mockDsNode = (Node)Mockito.mock(Node.class);
        NodeType[] nodeTypeArray = new NodeType[]{};
        try {
            Mockito.when((Object)this.mockDsNode.getMixinNodeTypes()).thenReturn((Object)nodeTypeArray);
            Mockito.when((Object)this.mockDsNode.getName()).thenReturn((Object)this.testDsId);
            Mockito.when((Object)this.mockDsNode.getSession()).thenReturn((Object)this.mockSession);
            this.testObj = new Datastream(this.mockDsNode);
        }
        catch (RepositoryException repositoryException) {
            repositoryException.printStackTrace();
            Assert.fail((String)repositoryException.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.mockSession = null;
        this.mockRootNode = null;
        this.mockDsNode = null;
    }

    @Test
    public void testGetNode() {
        Assert.assertEquals((Object)this.testObj.getNode(), (Object)this.mockDsNode);
    }

    @Test
    public void testGetContent() throws RepositoryException, IOException {
        Node node = TestHelpers.getContentNodeMock("asdf");
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)node);
        String string = IOUtils.toString((InputStream)this.testObj.getContent());
        Assert.assertEquals((Object)"asdf", (Object)string);
        ((Node)Mockito.verify((Object)node)).getProperty("jcr:data");
    }

    @Test
    public void testSetContent() throws RepositoryException, InvalidChecksumException {
        Binary binary = (Binary)Mockito.mock(Binary.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        PowerMockito.mockStatic(FedoraTypesUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)FedoraTypesUtils.getBinary((Node)((Node)Matchers.any(Node.class)), (InputStream)((InputStream)Matchers.any(InputStream.class)), (String)((String)Matchers.any(String.class)))).thenReturn((Object)binary);
        Node node = TestHelpers.getContentNodeMock(8);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)node);
        ValueFactory valueFactory = (ValueFactory)Mockito.mock(ValueFactory.class);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)valueFactory);
        Mockito.when((Object)valueFactory.createBinary((InputStream)Matchers.any(InputStream.class))).thenReturn((Object)binary);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node.canAddMixin("fedora:binary")).thenReturn((Object)true);
        Mockito.when((Object)node.setProperty("jcr:data", (javax.jcr.Binary)binary)).thenReturn((Object)property);
        Mockito.when((Object)node.getProperty("jcr:data")).thenReturn((Object)property);
        Mockito.when((Object)property.getBinary()).thenReturn((Object)binary);
        this.testObj.setContent(inputStream);
    }

    @Test(expected=InvalidChecksumException.class)
    public void testSetContentWithChecksumMismatch() throws RepositoryException, InvalidChecksumException, URISyntaxException {
        Binary binary = (Binary)Mockito.mock(Binary.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        PowerMockito.mockStatic(FedoraTypesUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)FedoraTypesUtils.getBinary((Node)((Node)Matchers.any(Node.class)), (InputStream)((InputStream)Matchers.any(InputStream.class)), (String)((String)Matchers.any(String.class)))).thenReturn((Object)binary);
        Node node = TestHelpers.getContentNodeMock(8);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)node);
        ValueFactory valueFactory = (ValueFactory)Mockito.mock(ValueFactory.class);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)valueFactory);
        Mockito.when((Object)valueFactory.createBinary((InputStream)Matchers.any(InputStream.class))).thenReturn((Object)binary);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node.canAddMixin("fedora:binary")).thenReturn((Object)true);
        Mockito.when((Object)node.setProperty("jcr:data", (javax.jcr.Binary)binary)).thenReturn((Object)property);
        Mockito.when((Object)node.getProperty("jcr:data")).thenReturn((Object)property);
        Mockito.when((Object)property.getBinary()).thenReturn((Object)binary);
        this.testObj.setContent(inputStream, null, new URI("urn:sha1:xyz"), null);
    }

    @Test
    public void getContentSize() throws RepositoryException {
        Node node = TestHelpers.getContentNodeMock(2);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)node);
        long l = this.testObj.getContentSize();
        ((Node)Mockito.verify((Object)node)).getProperty("fedora:size");
        Assert.assertEquals((long)2L, (long)l);
    }

    @Test
    public void getContentDigest() throws RepositoryException {
        URI uRI = URI.create(TestHelpers.checksumString("asdf"));
        Node node = TestHelpers.getContentNodeMock("asdf");
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)node);
        URI uRI2 = this.testObj.getContentDigest();
        Assert.assertEquals((Object)uRI, (Object)uRI2);
        ((Node)Mockito.verify((Object)node)).getProperty("fedora:digest");
    }

    @Test
    public void testGetDsId() throws RepositoryException {
        String string = this.testObj.getDsId();
        Assert.assertEquals((Object)this.testDsId, (Object)string);
    }

    @Test
    public void testGetObject() throws RepositoryException {
        Node node = (Node)Mockito.mock(Node.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"fedora:object");
        Mockito.when((Object)node.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{nodeType});
        Mockito.when((Object)this.mockDsNode.getParent()).thenReturn((Object)node);
        FedoraObject fedoraObject = this.testObj.getObject();
        Assert.assertNotNull((Object)fedoraObject);
        Assert.assertEquals((Object)node, (Object)fedoraObject.getNode());
    }

    @Test
    public void testGetMimeType() throws RepositoryException {
        Node node = TestHelpers.getContentNodeMock(8);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)node);
        Mockito.when((Object)this.mockDsNode.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)node.hasProperty("jcr:mimeType")).thenReturn((Object)true);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node.getProperty("jcr:mimeType")).thenReturn((Object)property);
        Mockito.when((Object)property.getString()).thenReturn((Object)"application/x-mime-type");
        Assert.assertEquals((Object)"application/x-mime-type", (Object)this.testObj.getMimeType());
    }

    @Test
    public void testGetMimeTypeWithNoContent() throws RepositoryException {
        Mockito.when((Object)this.mockDsNode.hasNode("jcr:content")).thenReturn((Object)false);
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.testObj.getMimeType());
    }

    @Test
    public void testGetMimeTypeWithDefault() throws RepositoryException {
        Node node = TestHelpers.getContentNodeMock(8);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)node);
        Mockito.when((Object)this.mockDsNode.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)node.hasProperty("jcr:mimeType")).thenReturn((Object)false);
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.testObj.getMimeType());
    }

    @Test
    public void testGetCreatedDate() throws RepositoryException {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.getDate()).thenReturn((Object)calendar);
        Mockito.when((Object)this.mockDsNode.hasProperty("jcr:created")).thenReturn((Object)true);
        Mockito.when((Object)this.mockDsNode.getProperty("jcr:created")).thenReturn((Object)property);
        Date date2 = this.testObj.getCreatedDate();
        Assert.assertEquals((long)date.getTime(), (long)date2.getTime());
    }

    @Test
    public void testGetLastModifiedDate() throws RepositoryException {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.getDate()).thenReturn((Object)calendar);
        Mockito.when((Object)this.mockDsNode.hasProperty("jcr:lastModified")).thenReturn((Object)true);
        Mockito.when((Object)this.mockDsNode.getProperty("jcr:lastModified")).thenReturn((Object)property);
        Date date2 = this.testObj.getLastModifiedDate();
        Assert.assertEquals((long)date.getTime(), (long)date2.getTime());
    }

    @Test
    public void testGetSize() throws RepositoryException {
        Node node = TestHelpers.getContentNodeMock(2);
        Mockito.when((Object)this.mockDsNode.getNode("jcr:content")).thenReturn((Object)node);
        Mockito.when((Object)this.mockDsNode.getProperties()).thenAnswer((Answer)new Answer<PropertyIterator>(){

            public PropertyIterator answer(InvocationOnMock invocationOnMock) {
                return TestHelpers.getPropertyIterator(1, 1L);
            }
        });
        long l = this.testObj.getSize();
        ((Node)Mockito.verify((Object)this.mockDsNode, (VerificationMode)Mockito.times((int)1))).getProperties();
        Assert.assertEquals((long)3L, (long)l);
    }

    @Test
    public void testHasMixin() throws RepositoryException {
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"fedora:datastream");
        NodeType nodeType2 = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)nodeType2.getName()).thenReturn((Object)"notfedora:datastream");
        NodeType[] nodeTypeArray = new NodeType[]{nodeType};
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getMixinNodeTypes()).thenReturn((Object)nodeTypeArray);
        Assert.assertEquals((Object)true, (Object)Datastream.hasMixin((Node)node));
        nodeTypeArray[0] = nodeType2;
        Assert.assertEquals((Object)false, (Object)Datastream.hasMixin((Node)node));
    }
}

