/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo;

import com.google.common.base.Predicate;
import java.util.Calendar;
import java.util.Collection;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.FedoraObject;
import org.fcrepo.services.ServiceHelpers;
import org.fcrepo.utils.FedoraJcrTypes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={ServiceHelpers.class})
public class FedoraObjectTest
implements FedoraJcrTypes {
    String testPid = "testObj";
    String mockUser = "mockUser";
    Session mockSession;
    Node mockRootNode;
    Node mockObjNode;
    FedoraObject testFedoraObject;
    NodeType[] mockNodetypes;

    @Before
    public void setUp() throws LoginException, RepositoryException {
        String string = "/" + this.testPid;
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.mockRootNode = (Node)Mockito.mock(Node.class);
        this.mockObjNode = (Node)Mockito.mock(Node.class);
        NodeType[] nodeTypeArray = new NodeType[]{};
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        try {
            Mockito.when((Object)this.mockObjNode.getName()).thenReturn((Object)this.testPid);
            Mockito.when((Object)this.mockObjNode.getSession()).thenReturn((Object)this.mockSession);
            Mockito.when((Object)this.mockObjNode.getMixinNodeTypes()).thenReturn((Object)nodeTypeArray);
            Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRootNode);
            Mockito.when((Object)this.mockRootNode.getNode(string)).thenReturn((Object)this.mockObjNode);
            Mockito.when((Object)this.mockSession.getUserID()).thenReturn((Object)this.mockUser);
            this.testFedoraObject = new FedoraObject(this.mockObjNode);
            this.mockNodetypes = new NodeType[2];
            this.mockNodetypes[0] = (NodeType)Mockito.mock(NodeType.class);
            this.mockNodetypes[1] = (NodeType)Mockito.mock(NodeType.class);
            Mockito.when((Object)this.mockObjNode.getMixinNodeTypes()).thenReturn((Object)this.mockNodetypes);
            Mockito.when((Object)predicate.apply((Object)this.mockObjNode)).thenReturn((Object)true);
        }
        catch (RepositoryException repositoryException) {
            repositoryException.printStackTrace();
            Assert.fail((String)repositoryException.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.mockSession = null;
        this.mockRootNode = null;
        this.mockObjNode = null;
    }

    @Test
    public void testGetName() throws RepositoryException {
        Assert.assertEquals((Object)this.testFedoraObject.getName(), (Object)this.testPid);
    }

    @Test
    public void testGetNode() {
        Assert.assertEquals((Object)this.testFedoraObject.getNode(), (Object)this.mockObjNode);
    }

    @Test
    public void testGetCreated() throws RepositoryException {
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.getDate()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)this.mockObjNode.hasProperty("jcr:created")).thenReturn((Object)true);
        Mockito.when((Object)this.mockObjNode.getProperty("jcr:created")).thenReturn((Object)property);
        this.testFedoraObject.getCreatedDate();
        ((Node)Mockito.verify((Object)this.mockObjNode)).getProperty("jcr:created");
    }

    @Test
    public void testGetLastModified() throws RepositoryException {
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)this.mockObjNode.hasProperty("jcr:lastModified")).thenReturn((Object)true);
        Mockito.when((Object)this.mockObjNode.getProperty("jcr:lastModified")).thenReturn((Object)property);
        Mockito.when((Object)property.getDate()).thenReturn((Object)Calendar.getInstance());
        this.testFedoraObject.getLastModifiedDate();
        ((Node)Mockito.verify((Object)this.mockObjNode)).getProperty("jcr:lastModified");
    }

    @Test
    public void testGetSize() throws RepositoryException {
        PowerMockito.mockStatic(ServiceHelpers.class, (Class[])new Class[0]);
        Mockito.when((Object)ServiceHelpers.getObjectSize((Node)this.mockObjNode)).thenReturn((Object)-8L);
        long l = this.testFedoraObject.getSize();
        Assert.assertEquals((long)-8L, (long)l);
    }

    @Test
    public void testGetModels() throws RepositoryException {
        Collection collection = this.testFedoraObject.getModels();
        Assert.assertNotNull((Object)collection);
    }
}

