/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.fcrepo.FedoraResource;
import org.fcrepo.rdf.GraphSubjects;
import org.fcrepo.utils.FedoraTypesUtils;
import org.fcrepo.utils.JcrPropertyStatementListener;
import org.fcrepo.utils.JcrRdfTools;
import org.fcrepo.utils.NamespaceTools;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.modeshape.common.collection.Problems;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "org.apache.xerces.*", "javax.xml.*", "org.xml.sax.*", "javax.management.*"})
@PrepareForTest(value={NamespaceTools.class, JcrRdfTools.class, FedoraTypesUtils.class})
public class FedoraResourceTest {
    FedoraResource testObj;
    Node mockNode;
    Node mockRoot;
    Session mockSession;

    @Before
    public void setUp() {
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.mockNode = (Node)Mockito.mock(Node.class);
        this.testObj = new FedoraResource(this.mockNode);
        Assert.assertEquals((Object)this.mockNode, (Object)this.testObj.getNode());
    }

    @Test
    public void testPathConstructor() throws RepositoryException {
        Node node = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)node2);
        Mockito.when((Object)node2.getNode("foo/bar")).thenReturn((Object)node);
        Mockito.when((Object)node.isNew()).thenReturn((Object)true);
        Mockito.when((Object)node.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)node.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        new FedoraResource(this.mockSession, "/foo/bar", null);
    }

    @Test
    public void testHasMixin() throws RepositoryException {
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        NodeType[] nodeTypeArray = new NodeType[]{nodeType};
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)nodeTypeArray);
        boolean bl = FedoraResource.hasMixin((Node)this.mockNode);
        Assert.assertEquals((Object)false, (Object)bl);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"fedora:resource");
        bl = FedoraResource.hasMixin((Node)this.mockNode);
        Assert.assertEquals((Object)true, (Object)bl);
    }

    @Test
    public void testGetPath() throws RepositoryException {
        this.testObj.getPath();
        ((Node)Mockito.verify((Object)this.mockNode)).getPath();
    }

    @Test
    public void testHasContent() throws RepositoryException {
        this.testObj.hasContent();
        ((Node)Mockito.verify((Object)this.mockNode)).hasNode("jcr:content");
    }

    @Test
    public void testGetCreatedDate() throws RepositoryException {
        Property property = (Property)Mockito.mock(Property.class);
        Calendar calendar = Calendar.getInstance();
        Mockito.when((Object)property.getDate()).thenReturn((Object)calendar);
        Mockito.when((Object)this.mockNode.hasProperty("jcr:created")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getProperty("jcr:created")).thenReturn((Object)property);
        Assert.assertEquals((long)calendar.getTimeInMillis(), (long)this.testObj.getCreatedDate().getTime());
    }

    @Test
    public void testGetLastModifiedDateDefault() throws RepositoryException {
        Date date;
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        try {
            Mockito.when((Object)this.mockNode.hasProperty("jcr:lastModified")).thenReturn((Object)false);
            date = (Property)Mockito.mock(Property.class);
            Mockito.when((Object)date.getDate()).thenReturn((Object)calendar);
            Mockito.when((Object)this.mockNode.hasProperty("jcr:created")).thenReturn((Object)true);
            Mockito.when((Object)this.mockNode.getProperty("jcr:created")).thenReturn((Object)date);
            Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        }
        catch (RepositoryException repositoryException) {
            repositoryException.printStackTrace();
        }
        date = this.testObj.getLastModifiedDate();
        Assert.assertEquals((long)calendar.getTimeInMillis(), (long)date.getTime());
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).save();
    }

    @Test
    public void testGetLastModifiedDate() throws RepositoryException {
        Property property;
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        try {
            property = (Property)Mockito.mock(Property.class);
            Mockito.when((Object)property.getDate()).thenReturn((Object)calendar);
            Mockito.when((Object)this.mockNode.hasProperty("jcr:created")).thenReturn((Object)true);
            Mockito.when((Object)this.mockNode.getProperty("jcr:created")).thenReturn((Object)property);
            Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        }
        catch (RepositoryException repositoryException) {
            repositoryException.printStackTrace();
        }
        property = (Property)Mockito.mock(Property.class);
        Calendar calendar2 = Calendar.getInstance();
        try {
            Mockito.when((Object)this.mockNode.hasProperty("jcr:lastModified")).thenReturn((Object)true);
            Mockito.when((Object)this.mockNode.getProperty("jcr:lastModified")).thenReturn((Object)property);
            Mockito.when((Object)property.getDate()).thenReturn((Object)calendar2);
        }
        catch (RepositoryException repositoryException) {
            System.err.println("What are we doing in the second test?");
            repositoryException.printStackTrace();
        }
        Date date = this.testObj.getLastModifiedDate();
        Assert.assertEquals((long)calendar2.getTimeInMillis(), (long)date.getTime());
    }

    @Test
    public void testGetPropertiesDataset() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        GraphSubjects graphSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)"info:fedora/xyz");
        Mockito.when((Object)JcrRdfTools.getGraphSubject((GraphSubjects)graphSubjects, (Node)this.mockNode)).thenReturn((Object)resource);
        Model model = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getJcrPropertiesModel((GraphSubjects)graphSubjects, (Node)this.mockNode)).thenReturn((Object)model);
        Model model2 = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getJcrTreeModel((GraphSubjects)graphSubjects, (Node)this.mockNode, (long)0L, (int)-1)).thenReturn((Object)model2);
        Dataset dataset = this.testObj.getPropertiesDataset(graphSubjects, 0L, -1);
        Assert.assertTrue((boolean)dataset.containsNamedModel("tree"));
        Assert.assertEquals((Object)model2, (Object)dataset.getNamedModel("tree"));
        Assert.assertEquals((Object)model, (Object)dataset.getDefaultModel());
        Assert.assertEquals((Object)"info:fedora/xyz", (Object)dataset.getContext().get(Symbol.create((String)"uri")));
    }

    @Test
    public void testGetPropertiesDatasetDefaultLimits() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        GraphSubjects graphSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)"info:fedora/xyz");
        Mockito.when((Object)JcrRdfTools.getGraphSubject((GraphSubjects)graphSubjects, (Node)this.mockNode)).thenReturn((Object)resource);
        Model model = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getJcrPropertiesModel((GraphSubjects)graphSubjects, (Node)this.mockNode)).thenReturn((Object)model);
        Model model2 = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getJcrTreeModel((GraphSubjects)graphSubjects, (Node)this.mockNode, (long)0L, (int)-1)).thenReturn((Object)model2);
        Dataset dataset = this.testObj.getPropertiesDataset(graphSubjects);
        Assert.assertTrue((boolean)dataset.containsNamedModel("tree"));
        Assert.assertEquals((Object)model2, (Object)dataset.getNamedModel("tree"));
        Assert.assertEquals((Object)model, (Object)dataset.getDefaultModel());
        Assert.assertEquals((Object)"info:fedora/xyz", (Object)dataset.getContext().get(Symbol.create((String)"uri")));
    }

    @Test
    public void testGetPropertiesDatasetDefaults() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)"info:fedora/xyz");
        Mockito.when((Object)JcrRdfTools.getGraphSubject((GraphSubjects)FedoraResource.DEFAULT_SUBJECT_FACTORY, (Node)this.mockNode)).thenReturn((Object)resource);
        Model model = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getJcrPropertiesModel((GraphSubjects)FedoraResource.DEFAULT_SUBJECT_FACTORY, (Node)this.mockNode)).thenReturn((Object)model);
        Model model2 = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getJcrTreeModel((GraphSubjects)FedoraResource.DEFAULT_SUBJECT_FACTORY, (Node)this.mockNode, (long)0L, (int)-1)).thenReturn((Object)model2);
        Dataset dataset = this.testObj.getPropertiesDataset();
        Assert.assertTrue((boolean)dataset.containsNamedModel("tree"));
        Assert.assertEquals((Object)model2, (Object)dataset.getNamedModel("tree"));
        Assert.assertEquals((Object)model, (Object)dataset.getDefaultModel());
        Assert.assertEquals((Object)"info:fedora/xyz", (Object)dataset.getContext().get(Symbol.create((String)"uri")));
    }

    @Test
    public void testGetVersionDataset() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        GraphSubjects graphSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)"info:fedora/xyz");
        Mockito.when((Object)JcrRdfTools.getGraphSubject((GraphSubjects)graphSubjects, (Node)this.mockNode)).thenReturn((Object)resource);
        Model model = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getJcrVersionsModel((GraphSubjects)graphSubjects, (Node)this.mockNode)).thenReturn((Object)model);
        Dataset dataset = this.testObj.getVersionDataset(graphSubjects);
        Assert.assertEquals((Object)model, (Object)dataset.getDefaultModel());
        Assert.assertEquals((Object)"info:fedora/xyz", (Object)dataset.getContext().get(Symbol.create((String)"uri")));
    }

    @Test
    public void testGetVersionDatasetDefaultSubject() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)"info:fedora/xyz");
        Mockito.when((Object)JcrRdfTools.getGraphSubject((GraphSubjects)FedoraResource.DEFAULT_SUBJECT_FACTORY, (Node)this.mockNode)).thenReturn((Object)resource);
        Model model = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getJcrVersionsModel((GraphSubjects)FedoraResource.DEFAULT_SUBJECT_FACTORY, (Node)this.mockNode)).thenReturn((Object)model);
        Dataset dataset = this.testObj.getVersionDataset();
        Assert.assertEquals((Object)model, (Object)dataset.getDefaultModel());
        Assert.assertEquals((Object)"info:fedora/xyz", (Object)dataset.getContext().get(Symbol.create((String)"uri")));
    }

    @Test
    public void testGetGraphProblems() throws RepositoryException {
        Problems problems = this.testObj.getDatasetProblems();
        Assert.assertEquals(null, (Object)problems);
        JcrPropertyStatementListener jcrPropertyStatementListener = (JcrPropertyStatementListener)Mockito.mock(JcrPropertyStatementListener.class);
        FedoraResourceTest.setField("listener", FedoraResource.class, jcrPropertyStatementListener, this.testObj);
        this.testObj.getDatasetProblems();
        ((JcrPropertyStatementListener)Mockito.verify((Object)jcrPropertyStatementListener)).getProblems();
    }

    @Test
    public void testAddVersionLabel() throws RepositoryException {
        PowerMockito.mockStatic(FedoraTypesUtils.class, (Class[])new Class[0]);
        VersionHistory versionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version version = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)version.getName()).thenReturn((Object)"uuid");
        Mockito.when((Object)FedoraTypesUtils.getBaseVersion((Node)this.mockNode)).thenReturn((Object)version);
        Mockito.when((Object)FedoraTypesUtils.getVersionHistory((Node)this.mockNode)).thenReturn((Object)versionHistory);
        this.testObj.addVersionLabel("v1.0.0");
        ((VersionHistory)Mockito.verify((Object)versionHistory)).addVersionLabel("uuid", "v1.0.0", true);
    }

    @Test
    public void testIsNew() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)true);
        Assert.assertTrue((String)"resource state should be the same as the node state", (boolean)this.testObj.isNew());
    }

    @Test
    public void testIsNotNew() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)false);
        Assert.assertFalse((String)"resource state should be the same as the node state", (boolean)this.testObj.isNew());
    }

    private static void setField(String string, Class<?> clazz, Object object, Object object2) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            field.set(object2, object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

