/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.Transaction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TransactionTest {
    private Transaction testObj;
    private Session mockSession;

    @Before
    public void setUp() {
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.testObj = new Transaction(this.mockSession);
    }

    @Test
    public void testRollback() throws RepositoryException {
        this.testObj.rollback();
        ((Session)Mockito.verify((Object)this.mockSession)).refresh(false);
        ((Session)Mockito.verify((Object)this.mockSession)).logout();
        Assert.assertEquals((Object)Transaction.State.ROLLED_BACK, (Object)this.testObj.getState());
        long l = this.testObj.getExpires().getTime();
        Assert.assertTrue((l <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testCommit() throws RepositoryException {
        this.testObj.commit();
        ((Session)Mockito.verify((Object)this.mockSession)).save();
        ((Session)Mockito.verify((Object)this.mockSession)).logout();
        Assert.assertEquals((Object)Transaction.State.COMMITED, (Object)this.testObj.getState());
        long l = this.testObj.getExpires().getTime();
        Assert.assertTrue((l <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testExpire() throws RepositoryException {
        long l = this.testObj.getExpires().getTime();
        this.testObj.expire();
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).save();
        ((Session)Mockito.verify((Object)this.mockSession)).logout();
        long l2 = this.testObj.getExpires().getTime();
        Assert.assertTrue((l2 < l ? 1 : 0) != 0);
        Assert.assertTrue((l2 <= System.currentTimeMillis() ? 1 : 0) != 0);
        Assert.assertTrue((l2 < l ? 1 : 0) != 0);
    }

    @Test
    public void testExpiryUpdate() throws RepositoryException {
        long l = this.testObj.getExpires().getTime();
        this.testObj.updateExpiryDate();
        long l2 = this.testObj.getExpires().getTime();
        Assert.assertTrue((String)("Unexpected negative expiry delta: " + (l2 - l)), (l2 - l >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testState() throws RepositoryException {
        Assert.assertEquals((Object)Transaction.State.NEW, (Object)this.testObj.getState());
        Mockito.when((Object)this.mockSession.hasPendingChanges()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Assert.assertEquals((Object)Transaction.State.DIRTY, (Object)this.testObj.getState());
        this.testObj.commit();
    }
}

