/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.TxAwareSession;
import org.fcrepo.TxSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TxAwareSessionTest {
    private Session mockSession;
    private Session testObj;

    @Before
    public void setUp() {
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.testObj = TxAwareSession.newInstance((Session)this.mockSession, (String)"txid");
    }

    @Test
    public void shouldProxyMethods() throws RepositoryException {
        this.testObj.getItem("/xyz");
        ((Session)Mockito.verify((Object)this.mockSession)).getItem("/xyz");
    }

    @Test
    public void shouldWrapImpersonateToReturnAnotherTxAwareSession() throws RepositoryException {
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        Mockito.when((Object)this.mockSession.impersonate(credentials)).thenReturn((Object)this.mockSession);
        Session session = this.testObj.impersonate(credentials);
        Assert.assertTrue((boolean)(session instanceof TxSession));
        Assert.assertEquals((Object)((TxSession)this.testObj).getTxId(), (Object)((TxSession)session).getTxId());
    }

    @Test
    public void shouldMakeLogoutANoop() {
        this.testObj.logout();
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).logout();
    }

    @Test
    public void shouldMakeSaveANoop() throws RepositoryException {
        this.testObj.save();
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).save();
    }
}

