/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.update.UpdateAction;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.FedoraObject;
import org.fcrepo.integration.AbstractIT;
import org.fcrepo.services.ObjectService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class FedoraObjectIT
extends AbstractIT {
    @Inject
    Repository repo;
    @Inject
    ObjectService objectService;

    @Test
    public void testCreatedObject() throws RepositoryException, IOException {
        Session session = this.repo.login();
        this.objectService.createObject(session, "/testObject");
        session.save();
        session.logout();
        session = this.repo.login();
        FedoraObject fedoraObject = this.objectService.getObject(session, "/testObject");
        Assert.assertNotNull((String)"Couldn't find object!", (Object)fedoraObject);
    }

    @Test
    public void testGetSizeWhenInATree() throws Exception {
        Session session = this.repo.login();
        FedoraObject fedoraObject = this.objectService.createObject(session, "/parentObject");
        long l = fedoraObject.getSize();
        this.objectService.createObject(session, "/parentObject/testChildObject");
        session.save();
        Assert.assertTrue((this.objectService.getObject(session, "/parentObject").getSize() > l ? 1 : 0) != 0);
    }

    @Test
    public void testObjectGraph() throws Exception {
        Session session = this.repo.login();
        FedoraObject fedoraObject = this.objectService.createObject(session, "/graphObject");
        Dataset dataset = fedoraObject.getPropertiesDataset();
        Assert.assertFalse((String)"Graph store should not contain JCR prefixes", (boolean)Pattern.compile("jcr").matcher(dataset.toString()).find());
        Assert.assertFalse((String)"Graph store should contain our fedora-internal prefix", (boolean)Pattern.compile("fedora-internal").matcher(dataset.toString()).find());
        UpdateAction.parseExecute((String)"PREFIX dc: <http://purl.org/dc/terms/>\nINSERT { <http://example/egbook> dc:title \"This is an example of an update that will be ignored\" } WHERE {}", (Dataset)dataset);
        UpdateAction.parseExecute((String)"PREFIX dc: <http://purl.org/dc/terms/>\nINSERT { <info:fedora/graphObject> dc:title \"This is an example title\" } WHERE {}", (Dataset)dataset);
        Assert.assertTrue((String)fedoraObject.getNode().getProperty("dc:title").getValues()[0].getString(), (boolean)fedoraObject.getNode().getProperty("dc:title").getValues()[0].getString().equals("This is an example title"));
        UpdateAction.parseExecute((String)"PREFIX myurn: <info:myurn/>\nINSERT { <info:fedora/graphObject> myurn:info \"This is some example data\";myurn:info  \"And so it this\"     } WHERE {}", (Dataset)dataset);
        Value[] valueArray = fedoraObject.getNode().getProperty(fedoraObject.getNode().getSession().getNamespacePrefix("info:myurn/") + ":info").getValues();
        Assert.assertEquals((Object)"This is some example data", (Object)valueArray[0].getString());
        Assert.assertEquals((Object)"And so it this", (Object)valueArray[1].getString());
        UpdateAction.parseExecute((String)"PREFIX fedora-rels-ext: <info:fedora/fedora-system:def/relations-external#>\nINSERT { <info:fedora/graphObject> fedora-rels-ext:isPartOf <info:fedora/graphObject> } WHERE {}", (Dataset)dataset);
        Assert.assertTrue((String)fedoraObject.getNode().getProperty("fedorarelsext:isPartOf").getValues()[0].getString(), (boolean)fedoraObject.getNode().getProperty("fedorarelsext:isPartOf").getValues()[0].getString().equals(fedoraObject.getNode().getIdentifier()));
        UpdateAction.parseExecute((String)"PREFIX dc: <http://purl.org/dc/terms/>\nDELETE { <info:fedora/graphObject> dc:title \"This is an example title\" } WHERE {}", (Dataset)dataset);
        Assert.assertFalse((String)"Found unexpected dc:title", (boolean)fedoraObject.getNode().hasProperty("dc:title"));
        UpdateAction.parseExecute((String)"PREFIX fedora-rels-ext: <info:fedora/fedora-system:def/relations-external#>\nDELETE { <info:fedora/graphObject> fedora-rels-ext:isPartOf <info:fedora/graphObject> } WHERE {}", (Dataset)dataset);
        Assert.assertFalse((String)"found unexpected reference", (boolean)fedoraObject.getNode().hasProperty("fedorarelsext:isPartOf"));
        session.save();
    }
}

