/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.FedoraObject;
import org.fcrepo.FedoraResource;
import org.fcrepo.RdfLexicon;
import org.fcrepo.exception.InvalidChecksumException;
import org.fcrepo.integration.AbstractIT;
import org.fcrepo.services.DatastreamService;
import org.fcrepo.services.NodeService;
import org.fcrepo.services.ObjectService;
import org.fcrepo.utils.FedoraTypesUtils;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class FedoraResourceIT
extends AbstractIT {
    @Inject
    Repository repo;
    @Inject
    NodeService nodeService;
    @Inject
    ObjectService objectService;
    @Inject
    DatastreamService datastreamService;

    @Test
    public void testGetRootNode() throws IOException, RepositoryException {
        Session session = this.repo.login();
        FedoraResource fedoraResource = this.nodeService.getObject(session, "/");
        Assert.assertEquals((Object)"/", (Object)fedoraResource.getPath());
        session.logout();
    }

    @Test
    public void testRandomNodeGraph() throws IOException, RepositoryException {
        Session session = this.repo.login();
        FedoraResource fedoraResource = this.nodeService.findOrCreateObject(session, "/testNodeGraph");
        this.logger.warn(fedoraResource.getPropertiesDataset().toString());
        Node node = NodeFactory.createURI((String)"info:fedora/testNodeGraph");
        Node node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#primaryType");
        Node node3 = NodeFactory.createLiteral((String)"nt:unstructured");
        Assert.assertTrue((boolean)fedoraResource.getPropertiesDataset().asDatasetGraph().contains(Node.ANY, node, node2, node3));
        session.logout();
    }

    @Test
    public void testRepositoryRootGraph() throws IOException, RepositoryException {
        Session session = this.repo.login();
        FedoraResource fedoraResource = this.nodeService.getObject(session, "/");
        this.logger.warn(fedoraResource.getPropertiesDataset().toString());
        Node node = NodeFactory.createURI((String)"info:fedora/");
        Node node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#primaryType");
        Node node3 = NodeFactory.createLiteral((String)"mode:root");
        Assert.assertTrue((boolean)fedoraResource.getPropertiesDataset().asDatasetGraph().contains(Node.ANY, node, node2, node3));
        node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#repository/jcr.repository.vendor.url");
        node3 = NodeFactory.createLiteral((String)"http://www.modeshape.org");
        Assert.assertTrue((boolean)fedoraResource.getPropertiesDataset().asDatasetGraph().contains(Node.ANY, node, node2, node3));
        node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#hasNodeType");
        node3 = NodeFactory.createLiteral((String)"fedora:resource");
        Assert.assertTrue((boolean)fedoraResource.getPropertiesDataset().asDatasetGraph().contains(Node.ANY, node, node2, node3));
        session.logout();
    }

    @Test
    public void testObjectGraph() throws IOException, RepositoryException {
        Session session = this.repo.login();
        FedoraObject fedoraObject = this.objectService.createObject(session, "/testObjectGraph");
        this.logger.warn(fedoraObject.getPropertiesDataset().toString());
        Node node = NodeFactory.createURI((String)"info:fedora/testObjectGraph");
        Node node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#uuid");
        Node node3 = NodeFactory.createLiteral((String)fedoraObject.getNode().getIdentifier());
        Assert.assertTrue((boolean)fedoraObject.getPropertiesDataset().asDatasetGraph().contains(Node.ANY, node, node2, node3));
        node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#mixinTypes");
        node3 = NodeFactory.createLiteral((String)"fedora:resource");
        Assert.assertTrue((boolean)fedoraObject.getPropertiesDataset().asDatasetGraph().contains(Node.ANY, node, node2, node3));
        node3 = NodeFactory.createLiteral((String)"fedora:object");
        Assert.assertTrue((boolean)fedoraObject.getPropertiesDataset().asDatasetGraph().contains(Node.ANY, node, node2, node3));
        session.logout();
    }

    @Test
    public void testDatastreamGraph() throws IOException, RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        this.objectService.createObject(session, "/testDatastreamGraphParent");
        this.datastreamService.createDatastreamNode(session, "/testDatastreamGraph", "text/plain", (InputStream)new ByteArrayInputStream("123456789test123456789".getBytes()));
        FedoraResource fedoraResource = this.nodeService.getObject(session, "/testDatastreamGraph");
        fedoraResource.getNode().setProperty("fedorarelsext:isPartOf", session.getNode("/testDatastreamGraphParent"));
        Dataset dataset = fedoraResource.getPropertiesDataset();
        Assert.assertTrue((boolean)dataset.getContext().isDefined(Symbol.create((String)"uri")));
        this.logger.warn(dataset.toString());
        Node node = NodeFactory.createURI((String)"info:fedora/testDatastreamGraph");
        Node node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#uuid");
        Node node3 = NodeFactory.createLiteral((String)fedoraResource.getNode().getIdentifier());
        DatasetGraph datasetGraph = dataset.asDatasetGraph();
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#mixinTypes");
        node3 = NodeFactory.createLiteral((String)"fedora:resource");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        node3 = NodeFactory.createLiteral((String)"fedora:datastream");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#numberOfChildren");
        RDFDatatype rDFDatatype = ResourceFactory.createTypedLiteral((Object)0L).getDatatype();
        node3 = NodeFactory.createLiteral((String)"0", (RDFDatatype)rDFDatatype);
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/relations-external#isPartOf");
        node3 = NodeFactory.createURI((String)"info:fedora/testDatastreamGraphParent");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#hasContent");
        node3 = NodeFactory.createURI((String)"info:fedora/testDatastreamGraph/fcr:content");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        node = NodeFactory.createURI((String)"info:fedora/testDatastreamGraph/fcr:content");
        node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#mimeType");
        node3 = NodeFactory.createLiteral((String)"text/plain");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        node2 = NodeFactory.createURI((String)"info:fedora/size");
        node3 = NodeFactory.createLiteral((String)"22", (RDFDatatype)ModelFactory.createDefaultModel().createTypedLiteral(22L).getDatatype());
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#hasLocation");
        node3 = Node.ANY;
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        session.logout();
    }

    @Test
    public void testObjectGraphWindow() throws IOException, RepositoryException {
        Session session = this.repo.login();
        FedoraObject fedoraObject = this.objectService.createObject(session, "/testObjectGraphWindow");
        this.objectService.createObject(session, "/testObjectGraphWindow/a");
        this.objectService.createObject(session, "/testObjectGraphWindow/b");
        this.objectService.createObject(session, "/testObjectGraphWindow/c");
        Dataset dataset = fedoraObject.getPropertiesDataset(FedoraResource.DEFAULT_SUBJECT_FACTORY, 1L, 1);
        this.logger.warn(dataset.toString());
        DatasetGraph datasetGraph = dataset.asDatasetGraph();
        Node node = NodeFactory.createURI((String)"info:fedora/testObjectGraphWindow");
        Node node2 = RdfLexicon.HAS_PRIMARY_IDENTIFIER.asNode();
        Node node3 = NodeFactory.createLiteral((String)fedoraObject.getNode().getIdentifier());
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        node2 = RdfLexicon.HAS_CHILD.asNode();
        node3 = NodeFactory.createURI((String)"info:fedora/testObjectGraphWindow/a");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        node3 = NodeFactory.createURI((String)"info:fedora/testObjectGraphWindow/b");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        node3 = NodeFactory.createURI((String)"info:fedora/testObjectGraphWindow/c");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, node3));
        node = NodeFactory.createURI((String)"info:fedora/testObjectGraphWindow/b");
        node2 = RdfLexicon.HAS_PRIMARY_IDENTIFIER.asNode();
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, node, node2, Node.ANY));
        node = NodeFactory.createURI((String)"info:fedora/testObjectGraphWindow/c");
        Assert.assertFalse((boolean)datasetGraph.contains(Node.ANY, node, node2, Node.ANY));
        session.logout();
    }

    @Test
    public void testUpdatingObjectGraph() throws RepositoryException {
        Session session = this.repo.login();
        FedoraObject fedoraObject = this.objectService.createObject(session, "/testObjectGraphUpdates");
        fedoraObject.updatePropertiesDataset("INSERT { <info:fedora/testObjectGraphUpdates> <info:fcrepo/zyx> \"a\" } WHERE {} ");
        Node node = NodeFactory.createURI((String)"info:fedora/testObjectGraphUpdates");
        Node node2 = NodeFactory.createURI((String)"info:fcrepo/zyx");
        Node node3 = NodeFactory.createLiteral((String)"a");
        Assert.assertTrue((boolean)fedoraObject.getPropertiesDataset().asDatasetGraph().contains(Node.ANY, node, node2, node3));
        fedoraObject.updatePropertiesDataset("DELETE { <info:fedora/testObjectGraphUpdates> <info:fcrepo/zyx> ?o }\nINSERT { <info:fedora/testObjectGraphUpdates> <info:fcrepo/zyx> \"b\" } WHERE { <info:fedora/testObjectGraphUpdates> <info:fcrepo/zyx> ?o } ");
        Assert.assertFalse((String)"found value we should have removed", (boolean)fedoraObject.getPropertiesDataset().asDatasetGraph().contains(Node.ANY, node, node2, node3));
        node3 = NodeFactory.createLiteral((String)"b");
        Assert.assertTrue((String)"could not find new value", (boolean)fedoraObject.getPropertiesDataset().asDatasetGraph().contains(Node.ANY, node, node2, node3));
        session.logout();
    }

    @Test
    public void testAddVersionLabel() throws RepositoryException {
        Session session = this.repo.login();
        FedoraObject fedoraObject = this.objectService.createObject(session, "/testObjectVersionLabel");
        session.save();
        fedoraObject.addVersionLabel("v0.0.1");
        session.save();
        Assert.assertTrue((boolean)Arrays.asList(FedoraTypesUtils.getVersionHistory((javax.jcr.Node)fedoraObject.getNode()).getVersionLabels()).contains("v0.0.1"));
        session.logout();
    }

    @Test
    public void testGetObjectVersionGraph() throws RepositoryException {
        Session session = this.repo.login();
        FedoraObject fedoraObject = this.objectService.createObject(session, "/testObjectVersionGraph");
        session.save();
        fedoraObject.addVersionLabel("v0.0.1");
        session.save();
        Dataset dataset = fedoraObject.getVersionDataset();
        this.logger.info(dataset.toString());
        Node node = NodeFactory.createURI((String)"info:fedora/testObjectVersionGraph");
        Node node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#hasVersion");
        ExtendedIterator extendedIterator = dataset.asDatasetGraph().getDefaultGraph().find((TripleMatch)Triple.createMatch((Node)node, (Node)node2, (Node)Node.ANY));
        List list = extendedIterator.toList();
        Assert.assertEquals((long)1L, (long)list.size());
        node = ((Triple)list.get(0)).getMatchObject();
        node2 = NodeFactory.createURI((String)"info:fedora/fedora-system:def/internal#hasVersionLabel");
        Node node3 = NodeFactory.createLiteral((String)"v0.0.1");
        Assert.assertTrue((boolean)dataset.asDatasetGraph().contains(Node.ANY, node, node2, node3));
        session.logout();
    }
}

