/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.services;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.fcrepo.Datastream;
import org.fcrepo.services.DatastreamService;
import org.fcrepo.services.LowLevelStorageService;
import org.fcrepo.services.ObjectService;
import org.fcrepo.utils.LowLevelCacheEntry;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"/spring-test/repo.xml"})
public class LowLevelStorageServiceIT {
    @Inject
    Repository repo;
    @Inject
    ObjectService objectService;
    @Inject
    DatastreamService datastreamService;
    @Inject
    LowLevelStorageService lowLevelService;

    @Test
    public void testGetBinaryBlobs() throws Exception {
        Session session = this.repo.login();
        this.objectService.createObject(session, "/testLLObject");
        this.datastreamService.createDatastreamNode(session, "/testLLObject/testRepositoryContent", "image/tiff", (InputStream)new ByteArrayInputStream("0123456789987654321012345678900987654321".getBytes()));
        session.save();
        Datastream datastream = this.datastreamService.getDatastream(session, "/testLLObject/testRepositoryContent");
        Iterator iterator = this.lowLevelService.getLowLevelCacheEntries(datastream.getNode().getNode("jcr:content")).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            InputStream inputStream = ((LowLevelCacheEntry)iterator.next()).getInputStream();
            String string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            Assert.assertEquals((Object)"0123456789987654321012345678900987654321", (Object)string);
            ++n;
        }
        Assert.assertNotEquals((long)0L, (long)n);
    }
}

