/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.services;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.update.UpdateAction;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.fcrepo.RdfLexicon;
import org.fcrepo.integration.AbstractIT;
import org.fcrepo.services.DatastreamService;
import org.fcrepo.services.ObjectService;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class ObjectServiceIT
extends AbstractIT {
    @Inject
    private Repository repository;
    @Inject
    ObjectService objectService;
    @Inject
    DatastreamService datastreamService;

    @Test
    public void testGetAllObjectsDatastreamSize() throws Exception {
        Session session = this.repository.login();
        double d = this.objectService.getRepositorySize().longValue();
        this.datastreamService.createDatastreamNode(session, "testObjectServiceNode", "application/octet-stream", (InputStream)new ByteArrayInputStream("asdf".getBytes()));
        session.save();
        session.logout();
        session = this.repository.login();
        double d2 = this.objectService.getRepositorySize().longValue();
        Util.assertEquals((Object)4.0, (Object)(d2 - d));
        session.logout();
    }

    @Test
    public void testGetNamespaceRegistryGraph() throws Exception {
        Session session = this.repository.login();
        Dataset dataset = this.objectService.getNamespaceRegistryGraph(session);
        NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
        this.logger.info(namespaceRegistry.toString());
        this.logger.info(dataset.toString());
        for (String string : namespaceRegistry.getPrefixes()) {
            if (string.isEmpty() || string.equals("xmlns") || string.equals("jcr")) continue;
            String string2 = namespaceRegistry.getURI(string);
            Assert.assertTrue((String)("expected to find JCR namespaces " + string + " in graph"), (boolean)dataset.asDatasetGraph().contains(Node.ANY, ResourceFactory.createResource((String)string2).asNode(), RdfLexicon.HAS_NAMESPACE_PREFIX.asNode(), ResourceFactory.createPlainLiteral((String)string).asNode()));
        }
        session.logout();
    }

    @Test
    public void testUpdateNamespaceRegistryGraph() throws Exception {
        Session session = this.repository.login();
        Dataset dataset = this.objectService.getNamespaceRegistryGraph(session);
        NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
        UpdateAction.parseExecute((String)("INSERT { <info:abc> <" + RdfLexicon.HAS_NAMESPACE_PREFIX.toString() + "> \"abc\" } WHERE { }"), (Dataset)dataset);
        Util.assertEquals((Object)"abc", (Object)namespaceRegistry.getPrefix("info:abc"));
        session.logout();
    }
}

