/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import javax.jcr.Repository;
import org.apache.commons.io.IOUtils;
import org.fcrepo.utils.impl.CacheStoreEntry;
import org.fcrepo.utils.impl.LocalBinaryStoreEntry;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"/spring-test/repo.xml"})
public class LowLevelCacheEntryIT {
    @Inject
    Repository repo;

    @Test
    public void testGetExternalIdentifier() throws Exception {
        BinaryStore binaryStore = ((JcrRepository)this.repo).getConfiguration().getBinaryStorage().getBinaryStore();
        LocalBinaryStoreEntry localBinaryStoreEntry = new LocalBinaryStoreEntry(binaryStore, new BinaryKey("asd"));
        Assert.assertEquals((Object)"/org.modeshape.jcr.value.binary.TransientBinaryStore", (Object)localBinaryStoreEntry.getExternalIdentifier().split(":")[0]);
    }

    @Test
    public void testEquals() throws Exception {
        BinaryStore binaryStore = ((JcrRepository)this.repo).getConfiguration().getBinaryStorage().getBinaryStore();
        LocalBinaryStoreEntry localBinaryStoreEntry = new LocalBinaryStoreEntry(binaryStore, new BinaryKey("asd"));
        LocalBinaryStoreEntry localBinaryStoreEntry2 = new LocalBinaryStoreEntry(binaryStore, new BinaryKey("asd"));
        Assert.assertEquals((Object)localBinaryStoreEntry, (Object)localBinaryStoreEntry2);
    }

    @Test
    public void testHashCode() throws Exception {
        BinaryStore binaryStore = ((JcrRepository)this.repo).getConfiguration().getBinaryStorage().getBinaryStore();
        LocalBinaryStoreEntry localBinaryStoreEntry = new LocalBinaryStoreEntry(binaryStore, new BinaryKey("asd"));
        LocalBinaryStoreEntry localBinaryStoreEntry2 = new LocalBinaryStoreEntry(binaryStore, new BinaryKey("asd"));
        Assert.assertEquals((long)localBinaryStoreEntry.hashCode(), (long)localBinaryStoreEntry2.hashCode());
    }

    @Test
    public void testEqualsIspn() throws Exception {
        DefaultCacheManager defaultCacheManager = new DefaultCacheManager("config/infinispan/basic/infinispan.xml");
        CacheStore cacheStore = ((CacheLoaderManager)defaultCacheManager.getCache("FedoraRepository").getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class)).getCacheStore();
        CacheStoreEntry cacheStoreEntry = new CacheStoreEntry(cacheStore, "FedoraRepository", new BinaryKey("asd"));
        CacheStoreEntry cacheStoreEntry2 = new CacheStoreEntry(cacheStore, "FedoraRepository", new BinaryKey("asd"));
        Assert.assertEquals((Object)cacheStoreEntry, (Object)cacheStoreEntry2);
    }

    @Test
    public void testHashCodeIspn() throws Exception {
        DefaultCacheManager defaultCacheManager = new DefaultCacheManager("config/infinispan/basic/infinispan.xml");
        CacheStore cacheStore = ((CacheLoaderManager)defaultCacheManager.getCache("FedoraRepository").getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class)).getCacheStore();
        CacheStoreEntry cacheStoreEntry = new CacheStoreEntry(cacheStore, "FedoraRepository", new BinaryKey("asd"));
        CacheStoreEntry cacheStoreEntry2 = new CacheStoreEntry(cacheStore, "FedoraRepository", new BinaryKey("asd"));
        Assert.assertEquals((long)cacheStoreEntry.hashCode(), (long)cacheStoreEntry2.hashCode());
    }

    @Test
    public void testGetExternalIdentifierWithInfinispan() throws Exception {
        DefaultCacheManager defaultCacheManager = new DefaultCacheManager("config/infinispan/basic/infinispan.xml");
        CacheStore cacheStore = ((CacheLoaderManager)defaultCacheManager.getCache("FedoraRepository").getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class)).getCacheStore();
        CacheStoreEntry cacheStoreEntry = new CacheStoreEntry(cacheStore, "FedoraRepository", new BinaryKey("asd"));
        Assert.assertEquals((Object)"/org.infinispan.loaders.file.FileCacheStore:FedoraRepository:org.infinispan.loaders.file.FileCacheStore:target/FedoraRepository/storage", (Object)cacheStoreEntry.getExternalIdentifier());
    }

    @Test
    public void testModifyingCacheStores() throws Exception {
        DefaultCacheManager defaultCacheManager = new DefaultCacheManager("config/infinispan/chained/infinispan.xml");
        CacheStore cacheStore = ((CacheLoaderManager)defaultCacheManager.getCache("FedoraRepository").getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class)).getCacheStore();
        assert (cacheStore instanceof ChainingCacheStore);
        BinaryKey binaryKey = new BinaryKey("123");
        ChainingCacheStore chainingCacheStore = (ChainingCacheStore)cacheStore;
        LinkedHashMap linkedHashMap = chainingCacheStore.getStores();
        CacheStoreEntry cacheStoreEntry = new CacheStoreEntry((CacheStore)linkedHashMap.keySet().toArray()[0], "FedoraRepository", binaryKey);
        CacheStoreEntry cacheStoreEntry2 = new CacheStoreEntry((CacheStore)linkedHashMap.keySet().toArray()[1], "FedoraRepository", binaryKey);
        cacheStoreEntry.storeValue((InputStream)new ByteArrayInputStream("123456".getBytes()));
        cacheStoreEntry2.storeValue((InputStream)new ByteArrayInputStream("asdfg".getBytes()));
        Thread.sleep(1000L);
        String string = IOUtils.toString((InputStream)cacheStoreEntry.getInputStream());
        String string2 = IOUtils.toString((InputStream)cacheStoreEntry2.getInputStream());
        Assert.assertEquals((String)"Found the wrong value in our cache store", (Object)"123456", (Object)string);
        Assert.assertEquals((String)"Found the wrong value in our cache store", (Object)"asdfg", (Object)string2);
    }
}

