/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.codec.binary.Hex;
import org.apache.poi.util.IOUtils;
import org.fcrepo.Datastream;
import org.fcrepo.binary.PolicyDecisionPoint;
import org.fcrepo.services.DatastreamService;
import org.fcrepo.services.LowLevelStorageService;
import org.fcrepo.services.ObjectService;
import org.fcrepo.utils.ContentDigest;
import org.fcrepo.utils.FixityResult;
import org.fcrepo.utils.LowLevelCacheEntry;
import org.fcrepo.utils.impl.CacheStoreEntry;
import org.fcrepo.utils.infinispan.StoreChunkOutputStream;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.jcr.JcrRepositoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfHealingIT {
    protected Logger logger;
    private static Repository repo;
    private DatastreamService datastreamService;
    private ObjectService objectService;
    private LowLevelStorageService lowLevelService;

    @Before
    public void setLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Before
    public void setRepository() throws RepositoryException {
        URL uRL = this.getClass().getClassLoader().getResource("test_selfhealing_repository.json");
        repo = new JcrRepositoryFactory().getRepository(uRL.toString(), null);
        this.datastreamService = new DatastreamService();
        this.datastreamService.setRepository(repo);
        this.datastreamService.setStoragePolicyDecisionPoint(new PolicyDecisionPoint());
        this.objectService = new ObjectService();
        this.objectService.setRepository(repo);
        this.lowLevelService = new LowLevelStorageService();
        this.lowLevelService.setRepository(repo);
        this.datastreamService.setLlStoreService(this.lowLevelService);
    }

    private void tamperWithNode(Node node) throws Exception {
        this.logger.info("Tampering with node " + node.toString());
        Set set = this.lowLevelService.getLowLevelCacheEntries(node.getNode("jcr:content"));
        Iterator iterator = set.iterator();
        LowLevelCacheEntry lowLevelCacheEntry = (LowLevelCacheEntry)iterator.next();
        CacheStore cacheStore = ((CacheStoreEntry)lowLevelCacheEntry).getLowLevelStore();
        if (cacheStore instanceof ChainingCacheStore) {
            cacheStore = (CacheStore)((ChainingCacheStore)cacheStore).getStores().keySet().iterator().next();
            StoreChunkOutputStream storeChunkOutputStream = new StoreChunkOutputStream(cacheStore, lowLevelCacheEntry.getKey().toString() + "-data");
            IOUtils.copy((InputStream)new ByteArrayInputStream("qwerty".getBytes()), (OutputStream)storeChunkOutputStream);
            storeChunkOutputStream.close();
        } else {
            lowLevelCacheEntry.storeValue((InputStream)new ByteArrayInputStream("qwerty".getBytes()));
        }
        Thread.sleep(1000L);
    }

    private Collection<FixityResult> getNodeFixity(Datastream datastream) throws NoSuchAlgorithmException, RepositoryException {
        return this.datastreamService.getFixity(datastream.getNode().getNode("jcr:content"), datastream.getContentDigest(), datastream.getContentSize());
    }

    @Test
    public void testEddiesMagicSelfHealingRepository() throws Exception {
        Session session = repo.login();
        URI uRI = ContentDigest.asURI((String)"SHA-1", (String)Hex.encodeHexString((byte[])MessageDigest.getInstance("SHA-1").digest("qn8y34jweuytgopfv3oevo29r7ajrp6r7q21jrxkkciggheh7rqqjbolsq09".getBytes())));
        URI uRI2 = ContentDigest.asURI((String)"SHA-1", (String)Hex.encodeHexString((byte[])MessageDigest.getInstance("SHA-1").digest("2e6sxpys67dslongzydxosx6ndze5vbgb6fnj1rr53buk405i1380a868xsb".getBytes())));
        this.objectService.createObject(session, "/testSelfHealingObject");
        this.datastreamService.createDatastreamNode(session, "/testSelfHealingObject/testDatastreamNode4", "application/octet-stream", (InputStream)new ByteArrayInputStream("qn8y34jweuytgopfv3oevo29r7ajrp6r7q21jrxkkciggheh7rqqjbolsq09".getBytes()), uRI);
        this.datastreamService.createDatastreamNode(session, "/testSelfHealingObject/testDatastreamNode5", "application/octet-stream", (InputStream)new ByteArrayInputStream("2e6sxpys67dslongzydxosx6ndze5vbgb6fnj1rr53buk405i1380a868xsb".getBytes()), uRI2);
        session.save();
        Thread.sleep(1000L);
        Datastream datastream = this.datastreamService.getDatastream(session, "/testSelfHealingObject/testDatastreamNode4");
        Datastream datastream2 = this.datastreamService.getDatastream(session, "/testSelfHealingObject/testDatastreamNode5");
        this.logger.info("checking that our setup succeeded");
        Collection<FixityResult> collection = this.getNodeFixity(datastream);
        Collection<FixityResult> collection2 = this.getNodeFixity(datastream2);
        Assert.assertNotEquals((long)0L, (long)collection.size());
        this.logger.info("ds1");
        boolean bl = true;
        for (FixityResult fixityResult : collection) {
            bl &= fixityResult.computedChecksum.equals(uRI);
        }
        Assert.assertTrue((String)"Expected the fixity check to pass.", (boolean)bl);
        this.logger.info("ds2");
        bl = true;
        for (FixityResult fixityResult : collection2) {
            bl &= fixityResult.computedChecksum.equals(uRI2);
        }
        Assert.assertTrue((String)"Expected the fixity check to pass.", (boolean)bl);
        this.tamperWithNode(datastream.getNode());
        collection = this.getNodeFixity(datastream);
        bl = true;
        for (FixityResult fixityResult : collection) {
            bl &= fixityResult.computedChecksum.equals(uRI);
        }
        Assert.assertFalse((String)"Expected the fixity check to fail.", (boolean)bl);
        this.datastreamService.runFixityAndFixProblems(datastream);
        collection = this.getNodeFixity(datastream);
        bl = true;
        for (FixityResult fixityResult : collection) {
            bl &= fixityResult.computedChecksum.equals(uRI);
        }
        Assert.assertTrue((String)"Expected the fixity check to pass.", (boolean)bl);
    }
}

