/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.binary.MimeTypePolicy;
import org.fcrepo.binary.Policy;
import org.fcrepo.binary.PolicyDecisionPoint;
import org.fcrepo.services.DatastreamService;
import org.fcrepo.services.LowLevelStorageService;
import org.fcrepo.services.ObjectService;
import org.fcrepo.services.functions.GetBinaryKey;
import org.fcrepo.utils.LowLevelCacheEntry;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.jcr.JcrRepositoryFactory;
import org.modeshape.jcr.value.BinaryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiffPolicyStorageIT {
    protected Logger logger;
    private static Repository repo;
    private DatastreamService datastreamService;
    private ObjectService objectService;
    private LowLevelStorageService lowLevelService;
    private PolicyDecisionPoint pdp;
    GetBinaryKey getBinaryKey = new GetBinaryKey();

    @Before
    public void setLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Before
    public void setRepository() throws RepositoryException {
        URL uRL = this.getClass().getClassLoader().getResource("test_composite_storage_repository.json");
        repo = new JcrRepositoryFactory().getRepository(uRL.toString(), null);
        this.pdp = new PolicyDecisionPoint();
        this.pdp.addPolicy((Policy)new MimeTypePolicy("image/tiff", "tiff-store"));
        this.datastreamService = new DatastreamService();
        this.datastreamService.setRepository(repo);
        this.datastreamService.setStoragePolicyDecisionPoint(this.pdp);
        this.objectService = new ObjectService();
        this.objectService.setRepository(repo);
        this.lowLevelService = new LowLevelStorageService();
        this.lowLevelService.setRepository(repo);
    }

    @Test
    @Ignore
    public void testPolicyDrivenStorage() throws Exception {
        Session session = repo.login();
        this.objectService.createObject(session, "/testCompositeObject");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("9876543219876543210987654321098765432109876543210987654321098765432109876543210987654321009876543210".getBytes());
        this.datastreamService.createDatastreamNode(session, "/testCompositeObject/content", "application/octet-stream", (InputStream)byteArrayInputStream);
        byteArrayInputStream = new ByteArrayInputStream("87acec17cd9dcd20a716cc2cf67417b71c8a701687acec17cd9dcd20a716cc2cf67417b71c8a701687acec17cd9dcd20a716cc2cf67417b71c8a701687acec17cd9dcd20a716cc2cf67417b71c8a701687acec17cd9dcd20a716cc2cf67417b71c8a701687acec17cd9dcd20a716cc2cf67417b71c8a701687acec17cd9dcd20a716cc2cf67417b71c8a7016".getBytes());
        this.datastreamService.createDatastreamNode(session, "/testCompositeObject/tiffContent", "image/tiff", (InputStream)byteArrayInputStream);
        session.save();
        Node node = session.getNode("/testCompositeObject/content");
        BinaryKey binaryKey = this.getBinaryKey.apply(node.getNode("jcr:content").getProperty("jcr:data"));
        this.logger.info("content key: {}", (Object)binaryKey);
        Node node2 = session.getNode("/testCompositeObject/tiffContent");
        BinaryKey binaryKey2 = this.getBinaryKey.apply(node2.getNode("jcr:content").getProperty("jcr:data"));
        this.logger.info("tiff key: {}", (Object)binaryKey2);
        Set set = this.lowLevelService.getLowLevelCacheEntries(binaryKey);
        Iterator iterator = set.iterator();
        Assert.assertEquals((long)1L, (long)set.size());
        Set set2 = this.lowLevelService.getLowLevelCacheEntries(binaryKey2);
        Iterator iterator2 = set2.iterator();
        Assert.assertEquals((long)1L, (long)set2.size());
        LowLevelCacheEntry lowLevelCacheEntry = (LowLevelCacheEntry)iterator.next();
        Assert.assertThat((Object)lowLevelCacheEntry.getExternalIdentifier(), (Matcher)CoreMatchers.containsString((String)"TransientBinaryStore"));
        LowLevelCacheEntry lowLevelCacheEntry2 = (LowLevelCacheEntry)iterator2.next();
        Assert.assertThat((Object)lowLevelCacheEntry2.getExternalIdentifier(), (Matcher)CoreMatchers.containsString((String)"FileSystemBinaryStore"));
    }
}

