/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.observer;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import org.fcrepo.observer.DefaultFilter;
import org.fcrepo.utils.FedoraTypesUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.modeshape.jcr.api.Repository;

public class DefaultFilterTest {
    private DefaultFilter testObj;
    private Session mockSession;

    @Before
    public void setUp() throws Exception {
        this.testObj = new DefaultFilter();
        Field field = DefaultFilter.class.getDeclaredField("repository");
        field.setAccessible(true);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        this.mockSession = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)repository.login()).thenReturn((Object)this.mockSession);
        field.set(this.testObj, repository);
        this.testObj.acquireSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldApplyToObject() throws Exception {
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Mockito.when((Object)predicate.apply(Matchers.any(Node.class))).thenReturn((Object)true);
        Predicate predicate2 = (Predicate)Mockito.mock(Predicate.class);
        Predicate predicate3 = FedoraTypesUtils.isFedoraDatastream;
        Predicate predicate4 = FedoraTypesUtils.isFedoraObject;
        try {
            FedoraTypesUtils.isFedoraDatastream = predicate2;
            FedoraTypesUtils.isFedoraObject = predicate;
            Event event = (Event)Mockito.mock(Event.class);
            Mockito.when((Object)event.getPath()).thenReturn((Object)"/foo/bar");
            Node node = (Node)Mockito.mock(Node.class);
            Mockito.when((Object)this.mockSession.getNode("/foo/bar")).thenReturn((Object)node);
            Assert.assertTrue((boolean)this.testObj.apply(event));
        }
        finally {
            FedoraTypesUtils.isFedoraDatastream = predicate3;
            FedoraTypesUtils.isFedoraObject = predicate4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldApplyToDatastream() throws Exception {
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Mockito.when((Object)predicate.apply(Matchers.any(Node.class))).thenReturn((Object)true);
        Predicate predicate2 = (Predicate)Mockito.mock(Predicate.class);
        Predicate predicate3 = FedoraTypesUtils.isFedoraDatastream;
        Predicate predicate4 = FedoraTypesUtils.isFedoraObject;
        try {
            FedoraTypesUtils.isFedoraDatastream = predicate2;
            FedoraTypesUtils.isFedoraObject = predicate;
            Event event = (Event)Mockito.mock(Event.class);
            Mockito.when((Object)event.getPath()).thenReturn((Object)"/foo/bar");
            Node node = (Node)Mockito.mock(Node.class);
            Mockito.when((Object)this.mockSession.getNode("/foo/bar")).thenReturn((Object)node);
            Assert.assertTrue((boolean)this.testObj.apply(event));
        }
        finally {
            FedoraTypesUtils.isFedoraDatastream = predicate3;
            FedoraTypesUtils.isFedoraObject = predicate4;
        }
    }

    @Test
    public void shouldNotApplyToNonExistentNodes() throws Exception {
        Event event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)event.getPath()).thenReturn((Object)"/foo/bar");
        Mockito.when((Object)this.mockSession.getNode("/foo/bar")).thenThrow(new Class[]{PathNotFoundException.class});
        Assert.assertEquals((Object)false, (Object)this.testObj.apply(event));
        ((Session)Mockito.verify((Object)this.mockSession)).getNode("/foo/bar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotApplyToSystemNodes() throws Exception {
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Predicate predicate2 = FedoraTypesUtils.isFedoraDatastream;
        Predicate predicate3 = FedoraTypesUtils.isFedoraObject;
        try {
            FedoraTypesUtils.isFedoraDatastream = predicate;
            FedoraTypesUtils.isFedoraObject = predicate;
            Event event = (Event)Mockito.mock(Event.class);
            Mockito.when((Object)event.getPath()).thenReturn((Object)"/foo/bar");
            Node node = (Node)Mockito.mock(Node.class);
            Mockito.when((Object)this.mockSession.getNode("/foo/bar")).thenReturn((Object)node);
            Assert.assertEquals((Object)false, (Object)this.testObj.apply(event));
        }
        finally {
            FedoraTypesUtils.isFedoraDatastream = predicate2;
            FedoraTypesUtils.isFedoraObject = predicate3;
        }
    }
}

