/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.observer;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.fcrepo.observer.EventFilter;
import org.fcrepo.observer.SimpleObserver;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.Repository;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={Iterables.class})
public class SimpleObserverTest {
    private SimpleObserver testObj;
    ObservationManager mockOM;

    private static void setField(String string, SimpleObserver simpleObserver, Object object) throws Exception {
        Field field = SimpleObserver.class.getDeclaredField(string);
        field.setAccessible(true);
        field.set(simpleObserver, object);
    }

    @Before
    public void setUp() throws Exception {
        this.testObj = new SimpleObserver();
    }

    @Test
    public void testBuildListener() throws Exception {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Session session = (Session)Mockito.mock(Session.class);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        this.mockOM = (ObservationManager)Mockito.mock(ObservationManager.class);
        Mockito.when((Object)workspace.getObservationManager()).thenReturn((Object)this.mockOM);
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)repository.login()).thenReturn((Object)session);
        SimpleObserverTest.setField("repository", this.testObj, repository);
        this.testObj.buildListener();
        ((ObservationManager)Mockito.verify((Object)this.mockOM)).addEventListener((EventListener)this.testObj, SimpleObserver.EVENT_TYPES.intValue(), "/", true, null, null, false);
    }

    @Test
    public void testOnEvent() throws Exception {
        EventBus eventBus = (EventBus)Mockito.mock(EventBus.class);
        EventFilter eventFilter = (EventFilter)Mockito.mock(EventFilter.class);
        SimpleObserverTest.setField("eventBus", this.testObj, eventBus);
        SimpleObserverTest.setField("eventFilter", this.testObj, eventFilter);
        Event event = (Event)Mockito.mock(Event.class);
        EventIterator eventIterator = (EventIterator)Mockito.mock(EventIterator.class);
        List<Event> list = Arrays.asList(event);
        PowerMockito.mockStatic(Iterables.class, (Class[])new Class[0]);
        Mockito.when((Object)Iterables.filter((Iterable)((Iterable)Matchers.any(Iterable.class)), (Predicate)((Predicate)Matchers.eq((Object)eventFilter)))).thenReturn(list);
        this.testObj.onEvent(eventIterator);
        ((EventBus)Mockito.verify((Object)eventBus)).post(Matchers.any(Event.class));
    }

    @Test
    public void testOnEventAllFiltered() throws Exception {
        EventBus eventBus = (EventBus)Mockito.mock(EventBus.class);
        EventFilter eventFilter = (EventFilter)Mockito.mock(EventFilter.class);
        SimpleObserverTest.setField("eventBus", this.testObj, eventBus);
        SimpleObserverTest.setField("eventFilter", this.testObj, eventFilter);
        EventIterator eventIterator = (EventIterator)Mockito.mock(EventIterator.class);
        List<Event> list = Arrays.asList(new Event[0]);
        PowerMockito.mockStatic(Iterables.class, (Class[])new Class[0]);
        Mockito.when((Object)Iterables.filter((Iterable)((Iterable)Matchers.any(Iterable.class)), (Predicate)((Predicate)Matchers.eq((Object)eventFilter)))).thenReturn(list);
        this.testObj.onEvent(eventIterator);
        ((EventBus)Mockito.verify((Object)eventBus, (VerificationMode)Mockito.never())).post(Matchers.any(Event.class));
    }
}

