/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.rdf.impl;

import com.hp.hpl.jena.rdf.model.Resource;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.rdf.impl.DefaultGraphSubjects;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultGraphSubjectsTest {
    private DefaultGraphSubjects testObj;

    @Before
    public void setUp() {
        this.testObj = new DefaultGraphSubjects();
    }

    @Test
    public void testGetGraphSubject() throws RepositoryException {
        String string = "/foo/bar";
        String string2 = "info:fedora" + string;
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)string);
        Resource resource = this.testObj.getGraphSubject(node);
        Assert.assertEquals((Object)string2, (Object)resource.getURI());
        Mockito.when((Object)node.getPath()).thenReturn((Object)(string + "/jcr:content"));
        resource = this.testObj.getGraphSubject(node);
        Assert.assertEquals((Object)(string2 + "/fcr:content"), (Object)resource.getURI());
    }

    @Test
    public void testGetNodeFromGraphSubject() throws PathNotFoundException, RepositoryException {
        String string = "/foo/bar";
        Session session = (Session)Mockito.mock(Session.class);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)session.nodeExists(string)).thenReturn((Object)true);
        Mockito.when((Object)session.getNode(string)).thenReturn((Object)node);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)("info:fedora" + string));
        Mockito.when((Object)resource.isURIResource()).thenReturn((Object)true);
        Node node2 = this.testObj.getNodeFromGraphSubject(session, resource);
        Assert.assertEquals((Object)node, (Object)node2);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)("info:fedora2" + string + "/bad"));
        node2 = this.testObj.getNodeFromGraphSubject(session, resource);
        Assert.assertEquals(null, (Object)node2);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)("info:fedora" + string + "/bad"));
        node2 = this.testObj.getNodeFromGraphSubject(session, resource);
        Assert.assertEquals(null, (Object)node2);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)("info:fedora" + string + "/fcr:content"));
        node2 = this.testObj.getNodeFromGraphSubject(session, resource);
        ((Session)Mockito.verify((Object)session)).getNode(string + "/jcr:content");
    }

    @Test
    public void testIsFedoraGraphSubject() {
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)"info:fedora/foo");
        Mockito.when((Object)resource.isURIResource()).thenReturn((Object)true);
        boolean bl = this.testObj.isFedoraGraphSubject(resource);
        Assert.assertEquals((Object)true, (Object)bl);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)"http://fedora/foo");
        bl = this.testObj.isFedoraGraphSubject(resource);
        Assert.assertEquals((Object)false, (Object)bl);
    }
}

