/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.services;

import com.google.common.base.Function;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.Datastream;
import org.fcrepo.binary.PolicyDecisionPoint;
import org.fcrepo.rdf.GraphSubjects;
import org.fcrepo.services.DatastreamService;
import org.fcrepo.services.LowLevelStorageService;
import org.fcrepo.services.ServiceHelpers;
import org.fcrepo.services.functions.CheckCacheEntryFixity;
import org.fcrepo.utils.FedoraJcrTypes;
import org.fcrepo.utils.FedoraTypesUtils;
import org.fcrepo.utils.FixityResult;
import org.fcrepo.utils.JcrRdfTools;
import org.fcrepo.utils.LowLevelCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "org.apache.xerces.*", "javax.xml.*", "org.xml.sax.*", "javax.management.*"})
@PrepareForTest(value={FedoraTypesUtils.class, ServiceHelpers.class, JcrRdfTools.class})
public class DatastreamServiceTest
implements FedoraJcrTypes {
    private static final String MOCK_CONTENT_TYPE = "application/test-data";
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_DATA = "jcr:data";
    private Session mockSession;
    private Node mockRoot;
    private DatastreamService testObj;
    private LowLevelStorageService llStore;

    @Before
    public void setUp() throws RepositoryException {
        this.testObj = new DatastreamService();
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.mockRoot = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
        this.llStore = (LowLevelStorageService)Mockito.mock(LowLevelStorageService.class);
        this.testObj.setLlStoreService(this.llStore);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCreateDatastreamNode() throws Exception {
        Node node = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        Property property = (Property)Mockito.mock(Property.class);
        org.modeshape.jcr.api.Binary binary = (org.modeshape.jcr.api.Binary)Mockito.mock(org.modeshape.jcr.api.Binary.class);
        Mockito.when((Object)this.mockRoot.getNode("/foo/bar".substring(1))).thenReturn((Object)node);
        Mockito.when((Object)node.getNode(JCR_CONTENT)).thenReturn((Object)node2);
        Mockito.when((Object)property.getBinary()).thenReturn((Object)binary);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)node2.setProperty(JCR_DATA, (Binary)binary)).thenReturn((Object)property);
        Mockito.when((Object)node2.getProperty(JCR_DATA)).thenReturn((Object)property);
        PolicyDecisionPoint policyDecisionPoint = (PolicyDecisionPoint)Mockito.mock(PolicyDecisionPoint.class);
        Mockito.when((Object)policyDecisionPoint.evaluatePolicies(node)).thenReturn(null);
        this.testObj.setStoragePolicyDecisionPoint(policyDecisionPoint);
        PowerMockito.mockStatic(FedoraTypesUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)FedoraTypesUtils.getBinary((Node)((Node)Matchers.eq((Object)node)), (InputStream)((InputStream)Matchers.eq((Object)inputStream)), (String)((String)Matchers.any(String.class)))).thenReturn((Object)binary);
        Node node3 = this.testObj.createDatastreamNode(this.mockSession, "/foo/bar", MOCK_CONTENT_TYPE, inputStream);
        Assert.assertEquals((Object)node, (Object)node3);
        ((Node)Mockito.verify((Object)node2)).setProperty(JCR_DATA, (Binary)binary);
    }

    @Test
    public void testGetDatastreamNode() throws Exception {
        Node node = (Node)Mockito.mock(Node.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"fedora:datastream");
        Mockito.when((Object)node.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{nodeType});
        Mockito.when((Object)this.mockSession.getNode("/foo/bar")).thenReturn((Object)node);
        Mockito.when((Object)this.mockRoot.getNode("/foo/bar".substring(1))).thenReturn((Object)node);
        DatastreamService datastreamService = new DatastreamService();
        datastreamService.getDatastreamNode(this.mockSession, "/foo/bar");
        ((Node)Mockito.verify((Object)this.mockRoot)).getNode("/foo/bar".substring(1));
    }

    @Test
    public void testGetDatastream() throws Exception {
        Node node = (Node)Mockito.mock(Node.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"fedora:datastream");
        Mockito.when((Object)node.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{nodeType});
        Mockito.when((Object)this.mockRoot.getNode("/foo/bar".substring(1))).thenReturn((Object)node);
        this.testObj.getDatastream(this.mockSession, "/foo/bar");
        ((Node)Mockito.verify((Object)this.mockRoot)).getNode("/foo/bar".substring(1));
    }

    @Test
    public void testExists() throws RepositoryException {
        Session session = (Session)Mockito.mock(Session.class);
        this.testObj.exists(session, "/foo/bar");
        ((Session)Mockito.verify((Object)session)).nodeExists("/foo/bar");
    }

    @Test
    public void testGetFixityResultsModel() throws RepositoryException, URISyntaxException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        FixityResult fixityResult = (FixityResult)Mockito.mock(FixityResult.class);
        Mockito.when((Object)fixityResult.matches(((Long)Matchers.any(Long.class)).longValue(), (URI)Matchers.any(URI.class))).thenReturn((Object)true);
        List<FixityResult> list = Arrays.asList(fixityResult);
        Datastream datastream = (Datastream)Mockito.mock(Datastream.class);
        Node node = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getNode(JCR_CONTENT)).thenReturn((Object)node2);
        Mockito.when((Object)datastream.getNode()).thenReturn((Object)node);
        Mockito.when((Object)datastream.getContentDigest()).thenReturn((Object)new URI("urn:sha1:abc"));
        Mockito.when((Object)this.llStore.transformLowLevelCacheEntries((Node)Matchers.eq((Object)node2), (Function)Matchers.any(Function.class))).thenReturn(list);
        GraphSubjects graphSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        Model model = (Model)Mockito.mock(Model.class);
        Mockito.when((Object)JcrRdfTools.getFixityResultsModel((GraphSubjects)((GraphSubjects)Matchers.eq((Object)graphSubjects)), (Node)((Node)Matchers.eq((Object)node)), (Iterable)((Iterable)Matchers.any(Collection.class)))).thenReturn((Object)model);
        Mockito.when((Object)JcrRdfTools.getGraphSubject((GraphSubjects)graphSubjects, (Node)node)).thenReturn((Object)ResourceFactory.createResource((String)"abc"));
        Dataset dataset = this.testObj.getFixityResultsModel(graphSubjects, datastream);
        Assert.assertTrue((boolean)dataset.getContext().isDefined(Symbol.create((String)"uri")));
    }

    @Test
    public void testGetFixity() throws NoSuchAlgorithmException, RepositoryException {
        Node node = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        URI uRI = URI.create("sha1:foo:bar");
        Mockito.when((Object)node.getNode(JCR_CONTENT)).thenReturn((Object)node2);
        this.testObj.getFixity(node2, uRI, 4L);
        ServiceHelpers.getCheckCacheFixityFunction((URI)uRI, (long)0L);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(CheckCacheEntryFixity.class);
        ((LowLevelStorageService)Mockito.verify((Object)this.llStore)).transformLowLevelCacheEntries((Node)Matchers.eq((Object)node2), (Function)argumentCaptor.capture());
        CheckCacheEntryFixity checkCacheEntryFixity = (CheckCacheEntryFixity)argumentCaptor.getValue();
        Assert.assertEquals((Object)uRI, (Object)checkCacheEntryFixity.getChecksum());
        Assert.assertEquals((long)4L, (long)checkCacheEntryFixity.getSize());
    }

    @Test
    public void testRunFixityAndFixProblems() throws RepositoryException, IOException, CacheLoaderException, URISyntaxException {
        Datastream datastream = (Datastream)Mockito.mock(Datastream.class);
        Node node = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        LowLevelCacheEntry lowLevelCacheEntry = (LowLevelCacheEntry)Mockito.mock(LowLevelCacheEntry.class);
        Mockito.when((Object)lowLevelCacheEntry.getInputStream()).thenReturn((Object)inputStream);
        LowLevelCacheEntry lowLevelCacheEntry2 = (LowLevelCacheEntry)Mockito.mock(LowLevelCacheEntry.class);
        FixityResult fixityResult = (FixityResult)Mockito.mock(FixityResult.class);
        Mockito.when((Object)fixityResult.matches(((Long)Matchers.any(Long.class)).longValue(), (URI)Matchers.any(URI.class))).thenReturn((Object)true);
        Mockito.when((Object)fixityResult.getEntry()).thenReturn((Object)lowLevelCacheEntry);
        FixityResult fixityResult2 = (FixityResult)Mockito.mock(FixityResult.class);
        Mockito.when((Object)fixityResult2.matches(((Long)Matchers.any(Long.class)).longValue(), (URI)Matchers.any(URI.class))).thenReturn((Object)false);
        Mockito.when((Object)fixityResult2.getEntry()).thenReturn((Object)lowLevelCacheEntry2);
        FixityResult fixityResult3 = (FixityResult)Mockito.mock(FixityResult.class);
        Mockito.when((Object)fixityResult3.matches(((Long)Matchers.any(Long.class)).longValue(), (URI)Matchers.any(URI.class))).thenReturn((Object)true);
        Mockito.when((Object)fixityResult3.getEntry()).thenReturn((Object)lowLevelCacheEntry);
        Mockito.when((Object)fixityResult3.isSuccess()).thenReturn((Object)true);
        List<FixityResult> list = Arrays.asList(fixityResult, fixityResult2);
        Mockito.when((Object)node.getNode(JCR_CONTENT)).thenReturn((Object)node2);
        Mockito.when((Object)datastream.getNode()).thenReturn((Object)node);
        Mockito.when((Object)datastream.getContentDigest()).thenReturn((Object)new URI("urn:sha1:abc"));
        Mockito.when((Object)this.llStore.transformLowLevelCacheEntries((Node)Matchers.eq((Object)node2), (Function)Matchers.any(CheckCacheEntryFixity.class))).thenReturn(list);
        Mockito.when((Object)lowLevelCacheEntry2.checkFixity((URI)Matchers.any(URI.class), ((Long)Matchers.any(Long.class)).longValue())).thenReturn((Object)fixityResult3);
        Collection collection = this.testObj.runFixityAndFixProblems(datastream);
        ((FixityResult)Mockito.verify((Object)fixityResult2)).setRepaired();
        ((LowLevelCacheEntry)Mockito.verify((Object)lowLevelCacheEntry2)).storeValue(inputStream);
        Assert.assertTrue((String)"expected to find good result", (boolean)collection.contains(fixityResult));
        Assert.assertTrue((String)"expected to find repaired result", (boolean)collection.contains(fixityResult2));
    }
}

