/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.services;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.fcrepo.services.LowLevelStorageService;
import org.fcrepo.services.ServiceHelpers;
import org.fcrepo.services.functions.CacheLocalTransform;
import org.fcrepo.services.functions.GetBinaryKey;
import org.fcrepo.services.functions.GetCacheStore;
import org.fcrepo.utils.LowLevelCacheEntry;
import org.fcrepo.utils.impl.CacheStoreEntry;
import org.fcrepo.utils.impl.LocalBinaryStoreEntry;
import org.infinispan.Cache;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.loaders.CacheStore;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.GetBinaryStore;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.CompositeBinaryStore;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={ServiceHelpers.class})
public class LowLevelStorageServiceTest {
    @Test
    public void testTransformBinaryBlobs() throws RepositoryException {
        GetBinaryStore getBinaryStore = (GetBinaryStore)Mockito.mock(GetBinaryStore.class);
        GetBinaryKey getBinaryKey = (GetBinaryKey)Mockito.mock(GetBinaryKey.class);
        Node node = (Node)Mockito.mock(Node.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        BinaryKey binaryKey = (BinaryKey)Mockito.mock(BinaryKey.class);
        BinaryStore binaryStore = (BinaryStore)Mockito.mock(BinaryStore.class);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node.getProperty("jcr:data")).thenReturn((Object)property);
        Mockito.when((Object)binaryStore.toString()).thenReturn((Object)"foo");
        Mockito.when((Object)getBinaryKey.apply(property)).thenReturn((Object)binaryKey);
        Mockito.when((Object)getBinaryStore.apply(repository)).thenReturn((Object)binaryStore);
        LowLevelStorageService lowLevelStorageService = new LowLevelStorageService();
        lowLevelStorageService.setGetBinaryStore(getBinaryStore);
        lowLevelStorageService.setGetBinaryKey(getBinaryKey);
        lowLevelStorageService.setRepository(repository);
        Function function = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)function.apply(Matchers.any(LowLevelCacheEntry.class))).thenReturn((Object)"bar");
        Collection collection = lowLevelStorageService.transformLowLevelCacheEntries(node, function);
        Assert.assertEquals((Object)"bar", collection.iterator().next());
        ((Function)Mockito.verify((Object)function)).apply(Matchers.any(LowLevelCacheEntry.class));
    }

    @Test
    public void testGetBinaryBlobs() throws RepositoryException {
        GetBinaryStore getBinaryStore = (GetBinaryStore)Mockito.mock(GetBinaryStore.class);
        GetBinaryKey getBinaryKey = (GetBinaryKey)Mockito.mock(GetBinaryKey.class);
        Node node = (Node)Mockito.mock(Node.class);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node.getProperty("jcr:data")).thenReturn((Object)property);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        BinaryKey binaryKey = (BinaryKey)Mockito.mock(BinaryKey.class);
        BinaryStore binaryStore = (BinaryStore)Mockito.mock(BinaryStore.class);
        Mockito.when((Object)binaryStore.toString()).thenReturn((Object)"foo");
        Mockito.when((Object)getBinaryKey.apply(property)).thenReturn((Object)binaryKey);
        Mockito.when((Object)getBinaryStore.apply(repository)).thenReturn((Object)binaryStore);
        LowLevelStorageService lowLevelStorageService = new LowLevelStorageService();
        lowLevelStorageService.setGetBinaryStore(getBinaryStore);
        lowLevelStorageService.setGetBinaryKey(getBinaryKey);
        lowLevelStorageService.setRepository(repository);
        Set set = lowLevelStorageService.getLowLevelCacheEntries(node);
        Assert.assertEquals((Object)"/foo", (Object)((LowLevelCacheEntry)set.iterator().next()).getExternalIdentifier());
    }

    @Test
    public void shouldRetrieveLowLevelCacheEntryForDefaultBinaryStore() throws RepositoryException {
        BinaryKey binaryKey = new BinaryKey("key-123");
        GetBinaryStore getBinaryStore = (GetBinaryStore)Mockito.mock(GetBinaryStore.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        BinaryStore binaryStore = (BinaryStore)Mockito.mock(BinaryStore.class);
        Mockito.when((Object)getBinaryStore.apply(repository)).thenReturn((Object)binaryStore);
        LowLevelStorageService lowLevelStorageService = (LowLevelStorageService)PowerMockito.spy((Object)new LowLevelStorageService());
        lowLevelStorageService.setRepository(repository);
        lowLevelStorageService.setGetBinaryStore(getBinaryStore);
        lowLevelStorageService.getLowLevelCacheEntries(binaryKey);
        ((LowLevelStorageService)Mockito.verify((Object)lowLevelStorageService, (VerificationMode)Mockito.times((int)1))).getLowLevelCacheEntriesFromStore(binaryStore, binaryKey);
    }

    @Test
    public void shouldRetrieveLowLevelCacheStoresForBinaryKey() throws RepositoryException {
        BinaryStore binaryStore = (BinaryStore)Mockito.mock(BinaryStore.class);
        LowLevelStorageService lowLevelStorageService = new LowLevelStorageService();
        Set set = lowLevelStorageService.getLowLevelCacheEntriesFromStore(binaryStore, new BinaryKey("key-123"));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((String)"does not contain our entry", (boolean)set.contains(new LocalBinaryStoreEntry(binaryStore, new BinaryKey("key-123"))));
    }

    @Test
    public void shouldRetrieveLowLevelCacheStoresForCompositeStore() throws Exception {
        PowerMockito.mockStatic(ServiceHelpers.class, (Class[])new Class[0]);
        Cache cache = (Cache)Mockito.mock(Cache.class);
        Cache cache2 = (Cache)Mockito.mock(Cache.class);
        CacheStore cacheStore = (CacheStore)Mockito.mock(CacheStore.class);
        CacheStore cacheStore2 = (CacheStore)Mockito.mock(CacheStore.class);
        BinaryStore binaryStore = (BinaryStore)Mockito.mock(BinaryStore.class);
        BinaryStore binaryStore2 = (BinaryStore)Mockito.mock(BinaryStore.class);
        GetCacheStore getCacheStore = (GetCacheStore)Mockito.mock(GetCacheStore.class);
        Mockito.when((Object)getCacheStore.apply(cache)).thenReturn((Object)cacheStore);
        Mockito.when((Object)getCacheStore.apply(cache2)).thenReturn((Object)cacheStore2);
        CompositeBinaryStore compositeBinaryStore = (CompositeBinaryStore)Mockito.mock(CompositeBinaryStore.class);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<Cache> arrayList = new ArrayList<Cache>();
        arrayList.add(cache);
        arrayList.add(cache2);
        hashMap.put("default", binaryStore);
        hashMap.put("a", binaryStore2);
        InfinispanBinaryStore infinispanBinaryStore = (InfinispanBinaryStore)Mockito.mock(InfinispanBinaryStore.class);
        Mockito.when((Object)infinispanBinaryStore.getCaches()).thenReturn(arrayList);
        hashMap.put("b", infinispanBinaryStore);
        Mockito.when((Object)compositeBinaryStore.getNamedStoreIterator()).thenReturn(hashMap.entrySet().iterator());
        DistributedExecutorService distributedExecutorService = (DistributedExecutorService)Mockito.mock(DistributedExecutorService.class);
        Mockito.when((Object)ServiceHelpers.getClusterExecutor((InfinispanBinaryStore)infinispanBinaryStore)).thenReturn((Object)distributedExecutorService);
        BinaryKey binaryKey = new BinaryKey("key-123");
        CacheStoreEntry cacheStoreEntry = new CacheStoreEntry(cacheStore, "cache1", binaryKey);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet immutableSet = builder.add((Object)cacheStoreEntry).build();
        builder = ImmutableSet.builder();
        CacheStoreEntry cacheStoreEntry2 = new CacheStoreEntry(cacheStore2, "cache2", binaryKey);
        ImmutableSet immutableSet2 = builder.add((Object)cacheStoreEntry2).build();
        Future future = (Future)Mockito.mock(Future.class);
        Future future2 = (Future)Mockito.mock(Future.class);
        Mockito.when(future.get((Long)Matchers.any(Long.class), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))))).thenReturn((Object)immutableSet);
        Mockito.when(future2.get((Long)Matchers.any(Long.class), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))))).thenReturn((Object)immutableSet2);
        ArrayList<Future> arrayList2 = new ArrayList<Future>(2);
        arrayList2.add(future);
        arrayList2.add(future2);
        Mockito.when((Object)distributedExecutorService.submitEverywhere((Callable)Matchers.any(CacheLocalTransform.class))).thenReturn(arrayList2);
        LowLevelStorageService lowLevelStorageService = new LowLevelStorageService();
        Mockito.when((Object)binaryStore.hasBinary(binaryKey)).thenReturn((Object)true);
        Mockito.when((Object)binaryStore2.hasBinary(binaryKey)).thenReturn((Object)false);
        Mockito.when((Object)infinispanBinaryStore.hasBinary(binaryKey)).thenReturn((Object)true);
        Set set = lowLevelStorageService.getLowLevelCacheEntriesFromStore(compositeBinaryStore, binaryKey);
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertTrue((boolean)set.contains(new LocalBinaryStoreEntry(binaryStore, binaryKey)));
        Assert.assertFalse((boolean)set.contains(new LocalBinaryStoreEntry(binaryStore2, binaryKey)));
        Assert.assertTrue((boolean)set.contains(new CacheStoreEntry(cacheStore, "cache1", binaryKey)));
        Assert.assertTrue((boolean)set.contains(new CacheStoreEntry(cacheStore2, "cache2", binaryKey)));
    }

    @Test
    public void shouldReturnAnEmptySetForMissingBinaryStore() throws RepositoryException {
        GetBinaryStore getBinaryStore = (GetBinaryStore)Mockito.mock(GetBinaryStore.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)getBinaryStore.apply(repository)).thenReturn(null);
        LowLevelStorageService lowLevelStorageService = new LowLevelStorageService();
        lowLevelStorageService.setGetBinaryStore(getBinaryStore);
        Set set = lowLevelStorageService.getLowLevelCacheEntries(new BinaryKey("key-123"));
        Assert.assertEquals((long)0L, (long)set.size());
    }
}

